/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.iam;

import java.util.List;
import software.amazon.awscdk.services.iam.CommonGrantOptions;
import software.amazon.awscdk.services.iam.GrantOnPrincipalAndResourceOptions;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.IResourceWithPolicy;
import software.amazon.jsii.JsiiSerializable;

public interface GrantOnPrincipalAndResourceOptions
extends JsiiSerializable,
CommonGrantOptions {
    public IResourceWithPolicy getResource();

    public List<String> getResourceSelfArns();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IResourceWithPolicy resource;
        private List<String> resourceSelfArns;
        private List<String> actions;
        private IGrantable grantee;
        private List<String> resourceArns;

        public Builder resource(IResourceWithPolicy resource) {
            this.resource = resource;
            return this;
        }

        public Builder resourceSelfArns(List<String> resourceSelfArns) {
            this.resourceSelfArns = resourceSelfArns;
            return this;
        }

        public Builder actions(List<String> actions) {
            this.actions = actions;
            return this;
        }

        public Builder grantee(IGrantable grantee) {
            this.grantee = grantee;
            return this;
        }

        public Builder resourceArns(List<String> resourceArns) {
            this.resourceArns = resourceArns;
            return this;
        }

        public GrantOnPrincipalAndResourceOptions build() {
            return new Jsii.Proxy(this.resource, this.resourceSelfArns, this.actions, this.grantee, this.resourceArns, null);
        }
    }
}

