package software.amazon.awscdk.services.iam;

/**
 * Represents an IAM user.
 * <p>
 * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.13.0 (build 385c325)", date = "2020-10-23T23:56:40.437Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.IUser")
@software.amazon.jsii.Jsii.Proxy(IUser.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IUser extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.iam.IIdentity {

    /**
     * The user's ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUserArn();

    /**
     * The user's name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUserName();

    /**
     * Adds this user to a group.
     * <p>
     * @param group This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addToGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGroup group);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.IUser {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The user's ARN.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getUserArn() {
            return this.jsiiGet("userArn", java.lang.String.class);
        }

        /**
         * The user's name.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getUserName() {
            return this.jsiiGet("userName", java.lang.String.class);
        }

        /**
         * When this Principal is used in an AssumeRole policy, the action to use.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getAssumeRoleAction() {
            return this.jsiiGet("assumeRoleAction", java.lang.String.class);
        }

        /**
         * Return the policy fragment that identifies this principal in a Policy.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment() {
            return this.jsiiGet("policyFragment", software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class);
        }

        /**
         * The AWS account ID of this principal.
         * <p>
         * Can be undefined when the account is not known
         * (for example, for service principals).
         * Can be a Token - in that case,
         * it's assumed to be AWS::AccountId.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.Nullable java.lang.String getPrincipalAccount() {
            return this.jsiiGet("principalAccount", java.lang.String.class);
        }

        /**
         * The principal to grant permissions to.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
            return this.jsiiGet("grantPrincipal", software.amazon.awscdk.services.iam.IPrincipal.class);
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ResourceEnvironment getEnv() {
            return this.jsiiGet("env", software.amazon.awscdk.core.ResourceEnvironment.class);
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return this.jsiiGet("stack", software.amazon.awscdk.core.Stack.class);
        }

        /**
         * The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.core.ConstructNode.class);
        }

        /**
         * Adds this user to a group.
         * <p>
         * @param group This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public void addToGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGroup group) {
            this.jsiiCall("addToGroup", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(group, "group is required") });
        }

        /**
         * Attaches a managed policy to this principal.
         * <p>
         * @param policy The managed policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public void addManagedPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IManagedPolicy policy) {
            this.jsiiCall("addManagedPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * Attaches an inline policy to this principal.
         * <p>
         * This is the same as calling <code>policy.addToXxx(principal)</code>.
         * <p>
         * @param policy The policy resource to attach to this principal [disable-awslint:ref-via-interface]. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public void attachInlinePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Policy policy) {
            this.jsiiCall("attachInlinePolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * (deprecated) Add to the policy of this principal.
         * <p>
         * @return true if the statement was added, false if the principal in
         * question does not have a policy document to add the statement to.
         * @deprecated Use `addToPrincipalPolicy` instead.
         * @param statement This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        @Override
        public @org.jetbrains.annotations.NotNull java.lang.Boolean addToPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
            return this.jsiiCall("addToPolicy", java.lang.Boolean.class, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
        }

        /**
         * Add to the policy of this principal.
         * <p>
         * @param statement This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToPrincipalPolicyResult addToPrincipalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
            return this.jsiiCall("addToPrincipalPolicy", software.amazon.awscdk.services.iam.AddToPrincipalPolicyResult.class, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
        }
    }
}
