package software.amazon.awscdk.services.iam;

/**
 * Properties for defining an IAM group.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.24.0 (build b722f66)", date = "2021-03-16T15:04:34.096Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.GroupProps")
@software.amazon.jsii.Jsii.Proxy(GroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A name for the IAM group.
     * <p>
     * For valid values, see the GroupName parameter
     * for the CreateGroup action in the IAM API Reference. If you don't specify
     * a name, AWS CloudFormation generates a unique physical ID and uses that
     * ID for the group name.
     * <p>
     * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
     * acknowledge your template's capabilities. For more information, see
     * Acknowledging IAM Resources in AWS CloudFormation Templates.
     * <p>
     * Default: Generated by CloudFormation (recommended)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGroupName() {
        return null;
    }

    /**
     * A list of managed policies associated with this role.
     * <p>
     * You can add managed policies later using
     * <code>addManagedPolicy(ManagedPolicy.fromAwsManagedPolicyName(policyName))</code>.
     * <p>
     * Default: - No managed policies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> getManagedPolicies() {
        return null;
    }

    /**
     * The path to the group.
     * <p>
     * For more information about paths, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html">IAM
     * Identifiers</a>
     * in the IAM User Guide.
     * <p>
     * Default: /
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GroupProps> {
        private java.lang.String groupName;
        private java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> managedPolicies;
        private java.lang.String path;

        /**
         * Sets the value of {@link GroupProps#getGroupName}
         * @param groupName A name for the IAM group.
         *                  For valid values, see the GroupName parameter
         *                  for the CreateGroup action in the IAM API Reference. If you don't specify
         *                  a name, AWS CloudFormation generates a unique physical ID and uses that
         *                  ID for the group name.
         *                  <p>
         *                  If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
         *                  acknowledge your template's capabilities. For more information, see
         *                  Acknowledging IAM Resources in AWS CloudFormation Templates.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupName(java.lang.String groupName) {
            this.groupName = groupName;
            return this;
        }

        /**
         * Sets the value of {@link GroupProps#getManagedPolicies}
         * @param managedPolicies A list of managed policies associated with this role.
         *                        You can add managed policies later using
         *                        <code>addManagedPolicy(ManagedPolicy.fromAwsManagedPolicyName(policyName))</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder managedPolicies(java.util.List<? extends software.amazon.awscdk.services.iam.IManagedPolicy> managedPolicies) {
            this.managedPolicies = (java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy>)managedPolicies;
            return this;
        }

        /**
         * Sets the value of {@link GroupProps#getPath}
         * @param path The path to the group.
         *             For more information about paths, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html">IAM
         *             Identifiers</a>
         *             in the IAM User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GroupProps build() {
            return new Jsii$Proxy(groupName, managedPolicies, path);
        }
    }

    /**
     * An implementation for {@link GroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GroupProps {
        private final java.lang.String groupName;
        private final java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> managedPolicies;
        private final java.lang.String path;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.groupName = software.amazon.jsii.Kernel.get(this, "groupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.managedPolicies = software.amazon.jsii.Kernel.get(this, "managedPolicies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IManagedPolicy.class)));
            this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.lang.String groupName, final java.util.List<? extends software.amazon.awscdk.services.iam.IManagedPolicy> managedPolicies, final java.lang.String path) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.groupName = groupName;
            this.managedPolicies = (java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy>)managedPolicies;
            this.path = path;
        }

        @Override
        public final java.lang.String getGroupName() {
            return this.groupName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> getManagedPolicies() {
            return this.managedPolicies;
        }

        @Override
        public final java.lang.String getPath() {
            return this.path;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getGroupName() != null) {
                data.set("groupName", om.valueToTree(this.getGroupName()));
            }
            if (this.getManagedPolicies() != null) {
                data.set("managedPolicies", om.valueToTree(this.getManagedPolicies()));
            }
            if (this.getPath() != null) {
                data.set("path", om.valueToTree(this.getPath()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-iam.GroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GroupProps.Jsii$Proxy that = (GroupProps.Jsii$Proxy) o;

            if (this.groupName != null ? !this.groupName.equals(that.groupName) : that.groupName != null) return false;
            if (this.managedPolicies != null ? !this.managedPolicies.equals(that.managedPolicies) : that.managedPolicies != null) return false;
            return this.path != null ? this.path.equals(that.path) : that.path == null;
        }

        @Override
        public final int hashCode() {
            int result = this.groupName != null ? this.groupName.hashCode() : 0;
            result = 31 * result + (this.managedPolicies != null ? this.managedPolicies.hashCode() : 0);
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            return result;
        }
    }
}
