package software.amazon.awscdk.services.iam;

/**
 * Principal entity that represents a federated identity provider such as Amazon Cognito, that can be used to provide temporary security credentials to users who have been authenticated.
 * <p>
 * Additional condition keys are available when the temporary security credentials are used to make a request.
 * You can use these keys to write policies that limit the access of federated users.
 * <p>
 * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#condition-keys-wif
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.26.0 (build 7d76e02)", date = "2021-03-25T11:30:33.818Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.FederatedPrincipal")
public class FederatedPrincipal extends software.amazon.awscdk.services.iam.PrincipalBase {

    protected FederatedPrincipal(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FederatedPrincipal(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param federated federated identity provider (i.e. 'cognito-identity.amazonaws.com' for users authenticated through Cognito). This parameter is required.
     * @param conditions The conditions under which the policy is in effect. This parameter is required.
     * @param assumeRoleAction
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FederatedPrincipal(final @org.jetbrains.annotations.NotNull java.lang.String federated, final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> conditions, final @org.jetbrains.annotations.Nullable java.lang.String assumeRoleAction) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(federated, "federated is required"), java.util.Objects.requireNonNull(conditions, "conditions is required"), assumeRoleAction });
    }

    /**
     * @param federated federated identity provider (i.e. 'cognito-identity.amazonaws.com' for users authenticated through Cognito). This parameter is required.
     * @param conditions The conditions under which the policy is in effect. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FederatedPrincipal(final @org.jetbrains.annotations.NotNull java.lang.String federated, final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> conditions) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(federated, "federated is required"), java.util.Objects.requireNonNull(conditions, "conditions is required") });
    }

    /**
     * Returns a string representation of an object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * When this Principal is used in an AssumeRole policy, the action to use.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAssumeRoleAction() {
        return software.amazon.jsii.Kernel.get(this, "assumeRoleAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The conditions under which the policy is in effect.
     * <p>
     * See <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html">the IAM documentation</a>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getConditions() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "conditions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * federated identity provider (i.e. 'cognito-identity.amazonaws.com' for users authenticated through Cognito).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFederated() {
        return software.amazon.jsii.Kernel.get(this, "federated", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Return the policy fragment that identifies this principal in a Policy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PrincipalPolicyFragment getPolicyFragment() {
        return software.amazon.jsii.Kernel.get(this, "policyFragment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PrincipalPolicyFragment.class));
    }
}
