package software.amazon.awscdk.services.iot;

/**
 * (experimental) Defines AWS IoT SQL.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket = new Bucket(this, "MyBucket");
 * TopicRule.Builder.create(this, "TopicRule")
 *         .sql(IotSql.fromStringAsVer20160323("SELECT * FROM 'device/+/data'"))
 *         .actions(List.of(
 *             S3PutObjectAction.Builder.create(bucket)
 *                     .accessControl(BucketAccessControl.PUBLIC_READ)
 *                     .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:36.167Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iot.$Module.class, fqn = "@aws-cdk/aws-iot.IotSql")
public abstract class IotSql extends software.amazon.jsii.JsiiObject {

    protected IotSql(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected IotSql(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected IotSql() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (experimental) Uses the original SQL version built on 2015-10-08.
     * <p>
     * @return Instance of IotSql
     * @param sql The actual SQL-like syntax query. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.IotSql fromStringAsVer20151008(final @org.jetbrains.annotations.NotNull java.lang.String sql) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iot.IotSql.class, "fromStringAsVer20151008", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iot.IotSql.class), new Object[] { java.util.Objects.requireNonNull(sql, "sql is required") });
    }

    /**
     * (experimental) Uses the SQL version built on 2016-03-23.
     * <p>
     * @return Instance of IotSql
     * @param sql The actual SQL-like syntax query. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.IotSql fromStringAsVer20160323(final @org.jetbrains.annotations.NotNull java.lang.String sql) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iot.IotSql.class, "fromStringAsVer20160323", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iot.IotSql.class), new Object[] { java.util.Objects.requireNonNull(sql, "sql is required") });
    }

    /**
     * (experimental) Uses the most recent beta SQL version.
     * <p>
     * If you use this version, it might
     * introduce breaking changes to your rules.
     * <p>
     * @return Instance of IotSql
     * @param sql The actual SQL-like syntax query. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.IotSql fromStringAsVerNewestUnstable(final @org.jetbrains.annotations.NotNull java.lang.String sql) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iot.IotSql.class, "fromStringAsVerNewestUnstable", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iot.IotSql.class), new Object[] { java.util.Objects.requireNonNull(sql, "sql is required") });
    }

    /**
     * (experimental) Returns the IoT SQL configuration.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.IotSqlConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.iot.IotSql {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * (experimental) Returns the IoT SQL configuration.
         * <p>
         * @param scope This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.IotSqlConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iot.IotSqlConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }
    }
}
