package software.amazon.awscdk.services.iot;

/**
 * (experimental) Properties for defining an AWS IoT Rule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket = new Bucket(this, "MyBucket");
 * TopicRule.Builder.create(this, "TopicRule")
 *         .sql(IotSql.fromStringAsVer20160323("SELECT * FROM 'device/+/data'"))
 *         .actions(List.of(
 *             S3PutObjectAction.Builder.create(bucket)
 *                     .accessControl(BucketAccessControl.PUBLIC_READ)
 *                     .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:36.169Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iot.$Module.class, fqn = "@aws-cdk/aws-iot.TopicRuleProps")
@software.amazon.jsii.Jsii.Proxy(TopicRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface TopicRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) A simplified SQL syntax to filter messages received on an MQTT topic and push the data elsewhere.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-sql-reference.html">https://docs.aws.amazon.com/iot/latest/developerguide/iot-sql-reference.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.IotSql getSql();

    /**
     * (experimental) The actions associated with the topic rule.
     * <p>
     * Default: No actions will be perform
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iot.IAction> getActions() {
        return null;
    }

    /**
     * (experimental) A textual description of the topic rule.
     * <p>
     * Default: None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * (experimental) Specifies whether the rule is enabled.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnabled() {
        return null;
    }

    /**
     * (experimental) The action AWS IoT performs when it is unable to perform a rule's action.
     * <p>
     * Default: - no action will be performed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iot.IAction getErrorAction() {
        return null;
    }

    /**
     * (experimental) The name of the topic rule.
     * <p>
     * Default: None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getTopicRuleName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TopicRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TopicRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<TopicRuleProps> {
        software.amazon.awscdk.services.iot.IotSql sql;
        java.util.List<software.amazon.awscdk.services.iot.IAction> actions;
        java.lang.String description;
        java.lang.Boolean enabled;
        software.amazon.awscdk.services.iot.IAction errorAction;
        java.lang.String topicRuleName;

        /**
         * Sets the value of {@link TopicRuleProps#getSql}
         * @param sql A simplified SQL syntax to filter messages received on an MQTT topic and push the data elsewhere. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sql(software.amazon.awscdk.services.iot.IotSql sql) {
            this.sql = sql;
            return this;
        }

        /**
         * Sets the value of {@link TopicRuleProps#getActions}
         * @param actions The actions associated with the topic rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder actions(java.util.List<? extends software.amazon.awscdk.services.iot.IAction> actions) {
            this.actions = (java.util.List<software.amazon.awscdk.services.iot.IAction>)actions;
            return this;
        }

        /**
         * Sets the value of {@link TopicRuleProps#getDescription}
         * @param description A textual description of the topic rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link TopicRuleProps#getEnabled}
         * @param enabled Specifies whether the rule is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link TopicRuleProps#getErrorAction}
         * @param errorAction The action AWS IoT performs when it is unable to perform a rule's action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder errorAction(software.amazon.awscdk.services.iot.IAction errorAction) {
            this.errorAction = errorAction;
            return this;
        }

        /**
         * Sets the value of {@link TopicRuleProps#getTopicRuleName}
         * @param topicRuleName The name of the topic rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder topicRuleName(java.lang.String topicRuleName) {
            this.topicRuleName = topicRuleName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TopicRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public TopicRuleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TopicRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicRuleProps {
        private final software.amazon.awscdk.services.iot.IotSql sql;
        private final java.util.List<software.amazon.awscdk.services.iot.IAction> actions;
        private final java.lang.String description;
        private final java.lang.Boolean enabled;
        private final software.amazon.awscdk.services.iot.IAction errorAction;
        private final java.lang.String topicRuleName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.sql = software.amazon.jsii.Kernel.get(this, "sql", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iot.IotSql.class));
            this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iot.IAction.class)));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.errorAction = software.amazon.jsii.Kernel.get(this, "errorAction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iot.IAction.class));
            this.topicRuleName = software.amazon.jsii.Kernel.get(this, "topicRuleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.sql = java.util.Objects.requireNonNull(builder.sql, "sql is required");
            this.actions = (java.util.List<software.amazon.awscdk.services.iot.IAction>)builder.actions;
            this.description = builder.description;
            this.enabled = builder.enabled;
            this.errorAction = builder.errorAction;
            this.topicRuleName = builder.topicRuleName;
        }

        @Override
        public final software.amazon.awscdk.services.iot.IotSql getSql() {
            return this.sql;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iot.IAction> getActions() {
            return this.actions;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final software.amazon.awscdk.services.iot.IAction getErrorAction() {
            return this.errorAction;
        }

        @Override
        public final java.lang.String getTopicRuleName() {
            return this.topicRuleName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("sql", om.valueToTree(this.getSql()));
            if (this.getActions() != null) {
                data.set("actions", om.valueToTree(this.getActions()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getErrorAction() != null) {
                data.set("errorAction", om.valueToTree(this.getErrorAction()));
            }
            if (this.getTopicRuleName() != null) {
                data.set("topicRuleName", om.valueToTree(this.getTopicRuleName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-iot.TopicRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TopicRuleProps.Jsii$Proxy that = (TopicRuleProps.Jsii$Proxy) o;

            if (!sql.equals(that.sql)) return false;
            if (this.actions != null ? !this.actions.equals(that.actions) : that.actions != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.errorAction != null ? !this.errorAction.equals(that.errorAction) : that.errorAction != null) return false;
            return this.topicRuleName != null ? this.topicRuleName.equals(that.topicRuleName) : that.topicRuleName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.sql.hashCode();
            result = 31 * result + (this.actions != null ? this.actions.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.errorAction != null ? this.errorAction.hashCode() : 0);
            result = 31 * result + (this.topicRuleName != null ? this.topicRuleName.hashCode() : 0);
            return result;
        }
    }
}
