/**
 * <h1>AWS IoT Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * All classes with the <code>Cfn</code> prefix in this module (<a href="https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib">CFN Resources</a>) are always stable and safe to use.
 * <p>
 * </blockquote>
 * <p>
 * <img alt="cdk-constructs: Experimental" src="https://img.shields.io/badge/cdk--constructs-experimental-important.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * The APIs of higher level constructs in this module are experimental and under active development.
 * They are subject to non-backward compatible changes or removal in any future version. These are
 * not subject to the <a href="https://semver.org/">Semantic Versioning</a> model and breaking changes will be
 * announced in the release notes. This means that while you may use them, you may need to update
 * your source code when upgrading to a newer version of this package.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * AWS IoT Core lets you connect billions of IoT devices and route trillions of
 * messages to AWS services without managing infrastructure.
 * <p>
 * <h2>Installation</h2>
 * <p>
 * Install the module:
 * <p>
 * <blockquote><pre>
 * $ npm i &#64;aws-cdk/aws-iot
 * </pre></blockquote>
 * <p>
 * Import it into your code:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.iot.*;
 * import software.amazon.awscdk.services.iot.actions.*;
 * </pre></blockquote>
 * <p>
 * <h2><code>TopicRule</code></h2>
 * <p>
 * Create a topic rule that give your devices the ability to interact with AWS services.
 * You can create a topic rule with an action that invoke the Lambda action as following:
 * <p>
 * <blockquote><pre>
 * Function func = Function.Builder.create(this, "MyFunction")
 *         .runtime(Runtime.NODEJS_14_X)
 *         .handler("index.handler")
 *         .code(Code.fromInline("\n    exports.handler = (event) =&gt; {\n      console.log(\"It is test for lambda action of AWS IoT Rule.\", event);\n    };"))
 *         .build();
 * 
 * TopicRule.Builder.create(this, "TopicRule")
 *         .topicRuleName("MyTopicRule") // optional
 *         .description("invokes the lambda function") // optional
 *         .sql(IotSql.fromStringAsVer20160323("SELECT topic(2) as device_id, timestamp() as timestamp FROM 'device/+/data'"))
 *         .actions(List.of(new LambdaFunctionAction(func)))
 *         .build();
 * </pre></blockquote>
 * <p>
 * Or, you can add an action after constructing the <code>TopicRule</code> instance as following:
 * <p>
 * <blockquote><pre>
 * Function func;
 * 
 * 
 * TopicRule topicRule = TopicRule.Builder.create(this, "TopicRule")
 *         .sql(IotSql.fromStringAsVer20160323("SELECT topic(2) as device_id, timestamp() as timestamp FROM 'device/+/data'"))
 *         .build();
 * topicRule.addAction(new LambdaFunctionAction(func));
 * </pre></blockquote>
 * <p>
 * You can also supply <code>errorAction</code> as following,
 * and the IoT Rule will trigger it if a rule's action is unable to perform:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.logs.*;
 * 
 * 
 * LogGroup logGroup = new LogGroup(this, "MyLogGroup");
 * 
 * TopicRule.Builder.create(this, "TopicRule")
 *         .sql(IotSql.fromStringAsVer20160323("SELECT topic(2) as device_id, timestamp() as timestamp FROM 'device/+/data'"))
 *         .errorAction(new CloudWatchLogsAction(logGroup))
 *         .build();
 * </pre></blockquote>
 * <p>
 * If you wanna make the topic rule disable, add property <code>enabled: false</code> as following:
 * <p>
 * <blockquote><pre>
 * TopicRule.Builder.create(this, "TopicRule")
 *         .sql(IotSql.fromStringAsVer20160323("SELECT topic(2) as device_id, timestamp() as timestamp FROM 'device/+/data'"))
 *         .enabled(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * See also <a href="https://docs.aws.amazon.com/cdk/api/latest/docs/aws-iot-actions-readme.html">&#64;aws-cdk/aws-iot-actions</a> for other actions.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.iot;
