package software.amazon.awscdk.services.iot;

/**
 * A CloudFormation <code>AWS::IoT::ThingType</code>.
 * <p>
 * Creates a new thing type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CfnThingType cfnThingType = CfnThingType.Builder.create(this, "MyCfnThingType")
 *         .deprecateThingType(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .thingTypeName("thingTypeName")
 *         .thingTypeProperties(ThingTypePropertiesProperty.builder()
 *                 .searchableAttributes(List.of("searchableAttributes"))
 *                 .thingTypeDescription("thingTypeDescription")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.84.0 (build 5404dcf)", date = "2023-06-19T16:29:57.639Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iot.$Module.class, fqn = "@aws-cdk/aws-iot.CfnThingType")
public class CfnThingType extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnThingType(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnThingType(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iot.CfnThingType.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::IoT::ThingType</code>.
     * <p>
     * @param scope <ul><li>scope in which this resource is defined.</li></ul> This parameter is required.
     * @param id <ul><li>scoped id of the resource.</li></ul> This parameter is required.
     * @param props <ul><li>resource properties.</li></ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnThingType(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iot.CfnThingTypeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new <code>AWS::IoT::ThingType</code>.
     * <p>
     * @param scope <ul><li>scope in which this resource is defined.</li></ul> This parameter is required.
     * @param id <ul><li>scoped id of the resource.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnThingType(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector <ul><li>tree inspector to collect and process attributes.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The thing type arn.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The thing type id.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Metadata which can be used to manage the thing type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * Deprecates a thing type. You can not associate new things with deprecated thing type.
     * <p>
     * Requires permission to access the <a href="https://docs.aws.amazon.com//service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeprecateThingType</a> action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeprecateThingType() {
        return software.amazon.jsii.Kernel.get(this, "deprecateThingType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Deprecates a thing type. You can not associate new things with deprecated thing type.
     * <p>
     * Requires permission to access the <a href="https://docs.aws.amazon.com//service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeprecateThingType</a> action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeprecateThingType(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "deprecateThingType", value);
    }

    /**
     * Deprecates a thing type. You can not associate new things with deprecated thing type.
     * <p>
     * Requires permission to access the <a href="https://docs.aws.amazon.com//service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeprecateThingType</a> action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeprecateThingType(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deprecateThingType", value);
    }

    /**
     * The name of the thing type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getThingTypeName() {
        return software.amazon.jsii.Kernel.get(this, "thingTypeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the thing type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setThingTypeName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "thingTypeName", value);
    }

    /**
     * The thing type properties for the thing type to create.
     * <p>
     * It contains information about the new thing type including a description, and a list of searchable thing attribute names. <code>ThingTypeProperties</code> can't be updated after the initial creation of the <code>ThingType</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getThingTypeProperties() {
        return software.amazon.jsii.Kernel.get(this, "thingTypeProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The thing type properties for the thing type to create.
     * <p>
     * It contains information about the new thing type including a description, and a list of searchable thing attribute names. <code>ThingTypeProperties</code> can't be updated after the initial creation of the <code>ThingType</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setThingTypeProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "thingTypeProperties", value);
    }

    /**
     * The thing type properties for the thing type to create.
     * <p>
     * It contains information about the new thing type including a description, and a list of searchable thing attribute names. <code>ThingTypeProperties</code> can't be updated after the initial creation of the <code>ThingType</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setThingTypeProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iot.CfnThingType.ThingTypePropertiesProperty value) {
        software.amazon.jsii.Kernel.set(this, "thingTypeProperties", value);
    }
    /**
     * The ThingTypeProperties contains information about the thing type including: a thing type description, and a list of searchable thing attribute names.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * ThingTypePropertiesProperty thingTypePropertiesProperty = ThingTypePropertiesProperty.builder()
     *         .searchableAttributes(List.of("searchableAttributes"))
     *         .thingTypeDescription("thingTypeDescription")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iot.$Module.class, fqn = "@aws-cdk/aws-iot.CfnThingType.ThingTypePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ThingTypePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ThingTypePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of searchable thing attribute names.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSearchableAttributes() {
            return null;
        }

        /**
         * The description of the thing type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getThingTypeDescription() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ThingTypePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ThingTypePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ThingTypePropertiesProperty> {
            java.util.List<java.lang.String> searchableAttributes;
            java.lang.String thingTypeDescription;

            /**
             * Sets the value of {@link ThingTypePropertiesProperty#getSearchableAttributes}
             * @param searchableAttributes A list of searchable thing attribute names.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder searchableAttributes(java.util.List<java.lang.String> searchableAttributes) {
                this.searchableAttributes = searchableAttributes;
                return this;
            }

            /**
             * Sets the value of {@link ThingTypePropertiesProperty#getThingTypeDescription}
             * @param thingTypeDescription The description of the thing type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder thingTypeDescription(java.lang.String thingTypeDescription) {
                this.thingTypeDescription = thingTypeDescription;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ThingTypePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ThingTypePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ThingTypePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ThingTypePropertiesProperty {
            private final java.util.List<java.lang.String> searchableAttributes;
            private final java.lang.String thingTypeDescription;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.searchableAttributes = software.amazon.jsii.Kernel.get(this, "searchableAttributes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.thingTypeDescription = software.amazon.jsii.Kernel.get(this, "thingTypeDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.searchableAttributes = builder.searchableAttributes;
                this.thingTypeDescription = builder.thingTypeDescription;
            }

            @Override
            public final java.util.List<java.lang.String> getSearchableAttributes() {
                return this.searchableAttributes;
            }

            @Override
            public final java.lang.String getThingTypeDescription() {
                return this.thingTypeDescription;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSearchableAttributes() != null) {
                    data.set("searchableAttributes", om.valueToTree(this.getSearchableAttributes()));
                }
                if (this.getThingTypeDescription() != null) {
                    data.set("thingTypeDescription", om.valueToTree(this.getThingTypeDescription()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-iot.CfnThingType.ThingTypePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ThingTypePropertiesProperty.Jsii$Proxy that = (ThingTypePropertiesProperty.Jsii$Proxy) o;

                if (this.searchableAttributes != null ? !this.searchableAttributes.equals(that.searchableAttributes) : that.searchableAttributes != null) return false;
                return this.thingTypeDescription != null ? this.thingTypeDescription.equals(that.thingTypeDescription) : that.thingTypeDescription == null;
            }

            @Override
            public final int hashCode() {
                int result = this.searchableAttributes != null ? this.searchableAttributes.hashCode() : 0;
                result = 31 * result + (this.thingTypeDescription != null ? this.thingTypeDescription.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iot.CfnThingType}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iot.CfnThingType> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope <ul><li>scope in which this resource is defined.</li></ul> This parameter is required.
         * @param id <ul><li>scoped id of the resource.</li></ul> This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.iot.CfnThingTypeProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Deprecates a thing type. You can not associate new things with deprecated thing type.
         * <p>
         * Requires permission to access the <a href="https://docs.aws.amazon.com//service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeprecateThingType</a> action.
         * <p>
         * @return {@code this}
         * @param deprecateThingType Deprecates a thing type. You can not associate new things with deprecated thing type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deprecateThingType(final java.lang.Boolean deprecateThingType) {
            this.props().deprecateThingType(deprecateThingType);
            return this;
        }
        /**
         * Deprecates a thing type. You can not associate new things with deprecated thing type.
         * <p>
         * Requires permission to access the <a href="https://docs.aws.amazon.com//service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeprecateThingType</a> action.
         * <p>
         * @return {@code this}
         * @param deprecateThingType Deprecates a thing type. You can not associate new things with deprecated thing type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deprecateThingType(final software.amazon.awscdk.core.IResolvable deprecateThingType) {
            this.props().deprecateThingType(deprecateThingType);
            return this;
        }

        /**
         * Metadata which can be used to manage the thing type.
         * <p>
         * @return {@code this}
         * @param tags Metadata which can be used to manage the thing type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * The name of the thing type.
         * <p>
         * @return {@code this}
         * @param thingTypeName The name of the thing type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thingTypeName(final java.lang.String thingTypeName) {
            this.props().thingTypeName(thingTypeName);
            return this;
        }

        /**
         * The thing type properties for the thing type to create.
         * <p>
         * It contains information about the new thing type including a description, and a list of searchable thing attribute names. <code>ThingTypeProperties</code> can't be updated after the initial creation of the <code>ThingType</code> .
         * <p>
         * @return {@code this}
         * @param thingTypeProperties The thing type properties for the thing type to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thingTypeProperties(final software.amazon.awscdk.core.IResolvable thingTypeProperties) {
            this.props().thingTypeProperties(thingTypeProperties);
            return this;
        }
        /**
         * The thing type properties for the thing type to create.
         * <p>
         * It contains information about the new thing type including a description, and a list of searchable thing attribute names. <code>ThingTypeProperties</code> can't be updated after the initial creation of the <code>ThingType</code> .
         * <p>
         * @return {@code this}
         * @param thingTypeProperties The thing type properties for the thing type to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thingTypeProperties(final software.amazon.awscdk.services.iot.CfnThingType.ThingTypePropertiesProperty thingTypeProperties) {
            this.props().thingTypeProperties(thingTypeProperties);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iot.CfnThingType}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iot.CfnThingType build() {
            return new software.amazon.awscdk.services.iot.CfnThingType(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.iot.CfnThingTypeProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.iot.CfnThingTypeProps.Builder();
            }
            return this.props;
        }
    }
}
