package software.amazon.awscdk.services.iot;

/**
 * (experimental) Defines an AWS IoT Rule in this stack.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket = new Bucket(this, "MyBucket");
 * TopicRule.Builder.create(this, "TopicRule")
 *         .sql(IotSql.fromStringAsVer20160323("SELECT * FROM 'device/+/data'"))
 *         .actions(List.of(
 *             S3PutObjectAction.Builder.create(bucket)
 *                     .accessControl(BucketAccessControl.PUBLIC_READ)
 *                     .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.84.0 (build 5404dcf)", date = "2023-06-19T16:29:57.724Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iot.$Module.class, fqn = "@aws-cdk/aws-iot.TopicRule")
public class TopicRule extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.iot.ITopicRule {

    protected TopicRule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TopicRule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public TopicRule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.TopicRuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Import an existing AWS IoT Rule provided an ARN.
     * <p>
     * @param scope The parent creating construct (usually <code>this</code>). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param topicRuleArn AWS IoT Rule ARN (i.e. arn:aws:iot:<region>:<account-id>:rule/MyRule). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.ITopicRule fromTopicRuleArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String topicRuleArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iot.TopicRule.class, "fromTopicRuleArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iot.ITopicRule.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(topicRuleArn, "topicRuleArn is required") });
    }

    /**
     * (experimental) Add a action to the topic rule.
     * <p>
     * @param action the action to associate with the topic rule. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.IAction action) {
        software.amazon.jsii.Kernel.call(this, "addAction", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(action, "action is required") });
    }

    /**
     * (experimental) Arn of this topic rule.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getTopicRuleArn() {
        return software.amazon.jsii.Kernel.get(this, "topicRuleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Name of this topic rule.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getTopicRuleName() {
        return software.amazon.jsii.Kernel.get(this, "topicRuleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.iot.TopicRule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iot.TopicRule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iot.TopicRuleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iot.TopicRuleProps.Builder();
        }

        /**
         * (experimental) A simplified SQL syntax to filter messages received on an MQTT topic and push the data elsewhere.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-sql-reference.html">https://docs.aws.amazon.com/iot/latest/developerguide/iot-sql-reference.html</a>
         * @param sql A simplified SQL syntax to filter messages received on an MQTT topic and push the data elsewhere. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sql(final software.amazon.awscdk.services.iot.IotSql sql) {
            this.props.sql(sql);
            return this;
        }

        /**
         * (experimental) The actions associated with the topic rule.
         * <p>
         * Default: No actions will be perform
         * <p>
         * @return {@code this}
         * @param actions The actions associated with the topic rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder actions(final java.util.List<? extends software.amazon.awscdk.services.iot.IAction> actions) {
            this.props.actions(actions);
            return this;
        }

        /**
         * (experimental) A textual description of the topic rule.
         * <p>
         * Default: None
         * <p>
         * @return {@code this}
         * @param description A textual description of the topic rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * (experimental) Specifies whether the rule is enabled.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enabled Specifies whether the rule is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        /**
         * (experimental) The action AWS IoT performs when it is unable to perform a rule's action.
         * <p>
         * Default: - no action will be performed
         * <p>
         * @return {@code this}
         * @param errorAction The action AWS IoT performs when it is unable to perform a rule's action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder errorAction(final software.amazon.awscdk.services.iot.IAction errorAction) {
            this.props.errorAction(errorAction);
            return this;
        }

        /**
         * (experimental) The name of the topic rule.
         * <p>
         * Default: None
         * <p>
         * @return {@code this}
         * @param topicRuleName The name of the topic rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder topicRuleName(final java.lang.String topicRuleName) {
            this.props.topicRuleName(topicRuleName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iot.TopicRule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.iot.TopicRule build() {
            return new software.amazon.awscdk.services.iot.TopicRule(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
