package software.amazon.awscdk.services.ivs;

/**
 * (experimental) Properties for creating a new Channel.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Channel myChannel = Channel.Builder.create(this, "Channel")
 *         .authorized(true)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:36.406Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ivs.$Module.class, fqn = "@aws-cdk/aws-ivs.ChannelProps")
@software.amazon.jsii.Jsii.Proxy(ChannelProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ChannelProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Whether the channel is authorized.
     * <p>
     * If you wish to make an authorized channel, you will need to ensure that
     * a PlaybackKeyPair has been uploaded to your account as this is used to
     * validate the signed JWT that is required for authorization
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAuthorized() {
        return null;
    }

    /**
     * (experimental) Channel latency mode.
     * <p>
     * Default: LatencyMode.LOW
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ivs.LatencyMode getLatencyMode() {
        return null;
    }

    /**
     * (experimental) Channel name.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * (experimental) The channel type, which determines the allowable resolution and bitrate.
     * <p>
     * If you exceed the allowable resolution or bitrate, the stream will disconnect immediately
     * <p>
     * Default: ChannelType.STANDARD
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ivs.ChannelType getType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ChannelProps> {
        java.lang.Boolean authorized;
        software.amazon.awscdk.services.ivs.LatencyMode latencyMode;
        java.lang.String name;
        software.amazon.awscdk.services.ivs.ChannelType type;

        /**
         * Sets the value of {@link ChannelProps#getAuthorized}
         * @param authorized Whether the channel is authorized.
         *                   If you wish to make an authorized channel, you will need to ensure that
         *                   a PlaybackKeyPair has been uploaded to your account as this is used to
         *                   validate the signed JWT that is required for authorization
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authorized(java.lang.Boolean authorized) {
            this.authorized = authorized;
            return this;
        }

        /**
         * Sets the value of {@link ChannelProps#getLatencyMode}
         * @param latencyMode Channel latency mode.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder latencyMode(software.amazon.awscdk.services.ivs.LatencyMode latencyMode) {
            this.latencyMode = latencyMode;
            return this;
        }

        /**
         * Sets the value of {@link ChannelProps#getName}
         * @param name Channel name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link ChannelProps#getType}
         * @param type The channel type, which determines the allowable resolution and bitrate.
         *             If you exceed the allowable resolution or bitrate, the stream will disconnect immediately
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder type(software.amazon.awscdk.services.ivs.ChannelType type) {
            this.type = type;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ChannelProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ChannelProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ChannelProps {
        private final java.lang.Boolean authorized;
        private final software.amazon.awscdk.services.ivs.LatencyMode latencyMode;
        private final java.lang.String name;
        private final software.amazon.awscdk.services.ivs.ChannelType type;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authorized = software.amazon.jsii.Kernel.get(this, "authorized", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.latencyMode = software.amazon.jsii.Kernel.get(this, "latencyMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ivs.LatencyMode.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ivs.ChannelType.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authorized = builder.authorized;
            this.latencyMode = builder.latencyMode;
            this.name = builder.name;
            this.type = builder.type;
        }

        @Override
        public final java.lang.Boolean getAuthorized() {
            return this.authorized;
        }

        @Override
        public final software.amazon.awscdk.services.ivs.LatencyMode getLatencyMode() {
            return this.latencyMode;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final software.amazon.awscdk.services.ivs.ChannelType getType() {
            return this.type;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAuthorized() != null) {
                data.set("authorized", om.valueToTree(this.getAuthorized()));
            }
            if (this.getLatencyMode() != null) {
                data.set("latencyMode", om.valueToTree(this.getLatencyMode()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getType() != null) {
                data.set("type", om.valueToTree(this.getType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ivs.ChannelProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ChannelProps.Jsii$Proxy that = (ChannelProps.Jsii$Proxy) o;

            if (this.authorized != null ? !this.authorized.equals(that.authorized) : that.authorized != null) return false;
            if (this.latencyMode != null ? !this.latencyMode.equals(that.latencyMode) : that.latencyMode != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            return this.type != null ? this.type.equals(that.type) : that.type == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authorized != null ? this.authorized.hashCode() : 0;
            result = 31 * result + (this.latencyMode != null ? this.latencyMode.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }
    }
}
