package software.amazon.awscdk.services.kinesis;

/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.12 (build 82990c5)", date = "2018-12-20T13:32:33.184Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesis.$Module.class, fqn = "@aws-cdk/aws-kinesis.CfnStream")
public class CfnStream extends software.amazon.awscdk.Resource {
    protected CfnStream(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesis.CfnStream.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::Kinesis::Stream``.
     * @param parent the ``cdk.Construct`` this ``CfnStream`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``CfnStream``
     */
    public CfnStream(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.kinesis.CfnStreamProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required")).toArray());
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public software.amazon.awscdk.services.kinesis.CfnStreamProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.kinesis.CfnStreamProps.class);
    }

    /**
     * @cloudformation_attribute Arn
     */
    public java.lang.String getStreamArn() {
        return this.jsiiGet("streamArn", java.lang.String.class);
    }

    public java.lang.String getStreamId() {
        return this.jsiiGet("streamId", java.lang.String.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html
     */
    public static interface StreamEncryptionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnStream.StreamEncryptionProperty.EncryptionType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-encryptiontype
         */
        java.lang.Object getEncryptionType();
        /**
         * ``CfnStream.StreamEncryptionProperty.EncryptionType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-encryptiontype
         */
        void setEncryptionType(final java.lang.String value);
        /**
         * ``CfnStream.StreamEncryptionProperty.EncryptionType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-encryptiontype
         */
        void setEncryptionType(final software.amazon.awscdk.Token value);
        /**
         * ``CfnStream.StreamEncryptionProperty.KeyId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-keyid
         */
        java.lang.Object getKeyId();
        /**
         * ``CfnStream.StreamEncryptionProperty.KeyId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-keyid
         */
        void setKeyId(final java.lang.String value);
        /**
         * ``CfnStream.StreamEncryptionProperty.KeyId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-keyid
         */
        void setKeyId(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link StreamEncryptionProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link StreamEncryptionProperty}
         */
        final class Builder {
            private java.lang.Object _encryptionType;
            private java.lang.Object _keyId;

            /**
             * Sets the value of EncryptionType
             * @param value ``CfnStream.StreamEncryptionProperty.EncryptionType``
             * @return {@code this}
             */
            public Builder withEncryptionType(final java.lang.String value) {
                this._encryptionType = java.util.Objects.requireNonNull(value, "encryptionType is required");
                return this;
            }
            /**
             * Sets the value of EncryptionType
             * @param value ``CfnStream.StreamEncryptionProperty.EncryptionType``
             * @return {@code this}
             */
            public Builder withEncryptionType(final software.amazon.awscdk.Token value) {
                this._encryptionType = java.util.Objects.requireNonNull(value, "encryptionType is required");
                return this;
            }
            /**
             * Sets the value of KeyId
             * @param value ``CfnStream.StreamEncryptionProperty.KeyId``
             * @return {@code this}
             */
            public Builder withKeyId(final java.lang.String value) {
                this._keyId = java.util.Objects.requireNonNull(value, "keyId is required");
                return this;
            }
            /**
             * Sets the value of KeyId
             * @param value ``CfnStream.StreamEncryptionProperty.KeyId``
             * @return {@code this}
             */
            public Builder withKeyId(final software.amazon.awscdk.Token value) {
                this._keyId = java.util.Objects.requireNonNull(value, "keyId is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StreamEncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public StreamEncryptionProperty build() {
                return new StreamEncryptionProperty() {
                    private java.lang.Object $encryptionType = java.util.Objects.requireNonNull(_encryptionType, "encryptionType is required");
                    private java.lang.Object $keyId = java.util.Objects.requireNonNull(_keyId, "keyId is required");

                    @Override
                    public java.lang.Object getEncryptionType() {
                        return this.$encryptionType;
                    }

                    @Override
                    public void setEncryptionType(final java.lang.String value) {
                        this.$encryptionType = java.util.Objects.requireNonNull(value, "encryptionType is required");
                    }

                    @Override
                    public void setEncryptionType(final software.amazon.awscdk.Token value) {
                        this.$encryptionType = java.util.Objects.requireNonNull(value, "encryptionType is required");
                    }

                    @Override
                    public java.lang.Object getKeyId() {
                        return this.$keyId;
                    }

                    @Override
                    public void setKeyId(final java.lang.String value) {
                        this.$keyId = java.util.Objects.requireNonNull(value, "keyId is required");
                    }

                    @Override
                    public void setKeyId(final software.amazon.awscdk.Token value) {
                        this.$keyId = java.util.Objects.requireNonNull(value, "keyId is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesis.CfnStream.StreamEncryptionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnStream.StreamEncryptionProperty.EncryptionType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-encryptiontype
             */
            @Override
            public java.lang.Object getEncryptionType() {
                return this.jsiiGet("encryptionType", java.lang.Object.class);
            }

            /**
             * ``CfnStream.StreamEncryptionProperty.EncryptionType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-encryptiontype
             */
            @Override
            public void setEncryptionType(final java.lang.String value) {
                this.jsiiSet("encryptionType", java.util.Objects.requireNonNull(value, "encryptionType is required"));
            }

            /**
             * ``CfnStream.StreamEncryptionProperty.EncryptionType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-encryptiontype
             */
            @Override
            public void setEncryptionType(final software.amazon.awscdk.Token value) {
                this.jsiiSet("encryptionType", java.util.Objects.requireNonNull(value, "encryptionType is required"));
            }

            /**
             * ``CfnStream.StreamEncryptionProperty.KeyId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-keyid
             */
            @Override
            public java.lang.Object getKeyId() {
                return this.jsiiGet("keyId", java.lang.Object.class);
            }

            /**
             * ``CfnStream.StreamEncryptionProperty.KeyId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-keyid
             */
            @Override
            public void setKeyId(final java.lang.String value) {
                this.jsiiSet("keyId", java.util.Objects.requireNonNull(value, "keyId is required"));
            }

            /**
             * ``CfnStream.StreamEncryptionProperty.KeyId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-keyid
             */
            @Override
            public void setKeyId(final software.amazon.awscdk.Token value) {
                this.jsiiSet("keyId", java.util.Objects.requireNonNull(value, "keyId is required"));
            }
        }
    }
}
