package software.amazon.awscdk.services.kinesis;

@javax.annotation.Generated(value = "jsii-pacmak/0.7.13 (build 311bf88)", date = "2019-01-11T10:49:54.379Z")
public interface IStream extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.IConstruct, software.amazon.awscdk.services.logs.ILogSubscriptionDestination {
    /**
     * The ARN of the stream.
     */
    java.lang.String getStreamArn();
    /**
     * The name of the stream
     */
    java.lang.String getStreamName();
    /**
     * Optional KMS encryption key associated with this stream.
     */
    software.amazon.awscdk.services.kms.IEncryptionKey getEncryptionKey();
    /**
     * Exports this stream from the stack.
     */
    software.amazon.awscdk.services.kinesis.StreamImportProps export();
    /**
     * Grant read permissions for this stream and its contents to an IAM
     * principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to ues the key to decrypt the
     * contents of the stream will also be granted.
     */
    void grantRead(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity);
    /**
     * Grant read permissions for this stream and its contents to an IAM
     * principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to ues the key to decrypt the
     * contents of the stream will also be granted.
     */
    void grantRead();
    /**
     * Grants read/write permissions for this stream and its contents to an IAM
     * principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     */
    void grantReadWrite(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity);
    /**
     * Grants read/write permissions for this stream and its contents to an IAM
     * principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     */
    void grantReadWrite();
    /**
     * Grant write permissions for this stream and its contents to an IAM
     * principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to ues the key to encrypt the
     * contents of the stream will also be granted.
     */
    void grantWrite(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity);
    /**
     * Grant write permissions for this stream and its contents to an IAM
     * principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to ues the key to encrypt the
     * contents of the stream will also be granted.
     */
    void grantWrite();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesis.IStream {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The ARN of the stream.
         */
        @Override
        public java.lang.String getStreamArn() {
            return this.jsiiGet("streamArn", java.lang.String.class);
        }

        /**
         * The name of the stream
         */
        @Override
        public java.lang.String getStreamName() {
            return this.jsiiGet("streamName", java.lang.String.class);
        }

        /**
         * Optional KMS encryption key associated with this stream.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.kms.IEncryptionKey getEncryptionKey() {
            return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.IEncryptionKey.class);
        }

        /**
         * The construct node in the scope tree.
         */
        @Override
        public software.amazon.awscdk.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.ConstructNode.class);
        }

        /**
         * Exports this stream from the stack.
         */
        @Override
        public software.amazon.awscdk.services.kinesis.StreamImportProps export() {
            return this.jsiiCall("export", software.amazon.awscdk.services.kinesis.StreamImportProps.class);
        }

        /**
         * Grant read permissions for this stream and its contents to an IAM
         * principal (Role/Group/User).
         * 
         * If an encryption key is used, permission to ues the key to decrypt the
         * contents of the stream will also be granted.
         */
        @Override
        public void grantRead(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity) {
            this.jsiiCall("grantRead", Void.class, java.util.stream.Stream.of(identity).toArray());
        }

        /**
         * Grant read permissions for this stream and its contents to an IAM
         * principal (Role/Group/User).
         * 
         * If an encryption key is used, permission to ues the key to decrypt the
         * contents of the stream will also be granted.
         */
        @Override
        public void grantRead() {
            this.jsiiCall("grantRead", Void.class);
        }

        /**
         * Grants read/write permissions for this stream and its contents to an IAM
         * principal (Role/Group/User).
         * 
         * If an encryption key is used, permission to use the key for
         * encrypt/decrypt will also be granted.
         */
        @Override
        public void grantReadWrite(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity) {
            this.jsiiCall("grantReadWrite", Void.class, java.util.stream.Stream.of(identity).toArray());
        }

        /**
         * Grants read/write permissions for this stream and its contents to an IAM
         * principal (Role/Group/User).
         * 
         * If an encryption key is used, permission to use the key for
         * encrypt/decrypt will also be granted.
         */
        @Override
        public void grantReadWrite() {
            this.jsiiCall("grantReadWrite", Void.class);
        }

        /**
         * Grant write permissions for this stream and its contents to an IAM
         * principal (Role/Group/User).
         * 
         * If an encryption key is used, permission to ues the key to encrypt the
         * contents of the stream will also be granted.
         */
        @Override
        public void grantWrite(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity) {
            this.jsiiCall("grantWrite", Void.class, java.util.stream.Stream.of(identity).toArray());
        }

        /**
         * Grant write permissions for this stream and its contents to an IAM
         * principal (Role/Group/User).
         * 
         * If an encryption key is used, permission to ues the key to encrypt the
         * contents of the stream will also be granted.
         */
        @Override
        public void grantWrite() {
            this.jsiiCall("grantWrite", Void.class);
        }

        /**
         * Return the properties required to send subscription events to this destination.
         * 
         * If necessary, the destination can use the properties of the SubscriptionFilter
         * object itself to configure its permissions to allow the subscription to write
         * to it.
         * 
         * The destination may reconfigure its own permissions in response to this
         * function call.
         */
        @Override
        public software.amazon.awscdk.services.logs.LogSubscriptionDestination logSubscriptionDestination(final software.amazon.awscdk.services.logs.ILogGroup sourceLogGroup) {
            return this.jsiiCall("logSubscriptionDestination", software.amazon.awscdk.services.logs.LogSubscriptionDestination.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(sourceLogGroup, "sourceLogGroup is required")).toArray());
        }
    }
}
