package software.amazon.awscdk.services.kinesis;

/**
 * Represents a Kinesis Stream.
 * 
 * Streams can be either defined within this stack:
 * 
 *    new Stream(this, 'MyStream', { props });
 * 
 * Or imported from an existing stream:
 * 
 *    Stream.import(this, 'MyImportedStream', { streamArn: ... });
 * 
 * You can also export a stream and import it into another stack:
 * 
 *    const ref = myStream.export();
 *    Stream.import(this, 'MyImportedStream', ref);
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-03-05T00:11:04.516Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesis.$Module.class, fqn = "@aws-cdk/aws-kinesis.StreamBase")
public abstract class StreamBase extends software.amazon.awscdk.Construct implements software.amazon.awscdk.services.kinesis.IStream {
    protected StreamBase(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }

    /**
     * Exports this stream from the stack.
     */
    @Override
    public abstract software.amazon.awscdk.services.kinesis.StreamImportProps export();

    /**
     * Grant write permissions for this stream and its contents to an IAM
     * principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to ues the key to decrypt the
     * contents of the stream will also be granted.
     */
    @Override
    public void grantRead(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity) {
        this.jsiiCall("grantRead", Void.class, java.util.stream.Stream.of(identity).toArray());
    }

    /**
     * Grant write permissions for this stream and its contents to an IAM
     * principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to ues the key to decrypt the
     * contents of the stream will also be granted.
     */
    @Override
    public void grantRead() {
        this.jsiiCall("grantRead", Void.class);
    }

    /**
     * Grants read/write permissions for this stream and its contents to an IAM
     * principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     */
    @Override
    public void grantReadWrite(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity) {
        this.jsiiCall("grantReadWrite", Void.class, java.util.stream.Stream.of(identity).toArray());
    }

    /**
     * Grants read/write permissions for this stream and its contents to an IAM
     * principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     */
    @Override
    public void grantReadWrite() {
        this.jsiiCall("grantReadWrite", Void.class);
    }

    /**
     * Grant read permissions for this stream and its contents to an IAM
     * principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to ues the key to decrypt the
     * contents of the stream will also be granted.
     */
    @Override
    public void grantWrite(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity) {
        this.jsiiCall("grantWrite", Void.class, java.util.stream.Stream.of(identity).toArray());
    }

    /**
     * Grant read permissions for this stream and its contents to an IAM
     * principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to ues the key to decrypt the
     * contents of the stream will also be granted.
     */
    @Override
    public void grantWrite() {
        this.jsiiCall("grantWrite", Void.class);
    }

    /**
     * Return the properties required to send subscription events to this destination.
     * 
     * If necessary, the destination can use the properties of the SubscriptionFilter
     * object itself to configure its permissions to allow the subscription to write
     * to it.
     * 
     * The destination may reconfigure its own permissions in response to this
     * function call.
     */
    @Override
    public software.amazon.awscdk.services.logs.LogSubscriptionDestination logSubscriptionDestination(final software.amazon.awscdk.services.logs.ILogGroup sourceLogGroup) {
        return this.jsiiCall("logSubscriptionDestination", software.amazon.awscdk.services.logs.LogSubscriptionDestination.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(sourceLogGroup, "sourceLogGroup is required")).toArray());
    }

    /**
     * The ARN of the stream.
     */
    @Override
    public java.lang.String getStreamArn() {
        return this.jsiiGet("streamArn", java.lang.String.class);
    }

    /**
     * The name of the stream
     */
    @Override
    public java.lang.String getStreamName() {
        return this.jsiiGet("streamName", java.lang.String.class);
    }

    /**
     * Optional KMS encryption key associated with this stream.
     */
    @Override
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.kms.IEncryptionKey getEncryptionKey() {
        return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.IEncryptionKey.class);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.kinesis.StreamBase {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The ARN of the stream.
         */
        @Override
        public java.lang.String getStreamArn() {
            return this.jsiiGet("streamArn", java.lang.String.class);
        }

        /**
         * The name of the stream
         */
        @Override
        public java.lang.String getStreamName() {
            return this.jsiiGet("streamName", java.lang.String.class);
        }

        /**
         * Optional KMS encryption key associated with this stream.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.kms.IEncryptionKey getEncryptionKey() {
            return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.IEncryptionKey.class);
        }

        /**
         * The construct node in the scope tree.
         */
        @Override
        public software.amazon.awscdk.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.ConstructNode.class);
        }

        /**
         * The set of constructs that form the root of this dependable
         * 
         * All resources under all returned constructs are included in the ordering
         * dependency.
         */
        @Override
        public java.util.List<software.amazon.awscdk.IConstruct> getDependencyRoots() {
            return this.jsiiGet("dependencyRoots", java.util.List.class);
        }

        /**
         * Exports this stream from the stack.
         */
        @Override
        public software.amazon.awscdk.services.kinesis.StreamImportProps export() {
            return this.jsiiCall("export", software.amazon.awscdk.services.kinesis.StreamImportProps.class);
        }

        /**
         * Grant read permissions for this stream and its contents to an IAM
         * principal (Role/Group/User).
         * 
         * If an encryption key is used, permission to ues the key to decrypt the
         * contents of the stream will also be granted.
         */
        @Override
        public void grantRead(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity) {
            this.jsiiCall("grantRead", Void.class, java.util.stream.Stream.of(identity).toArray());
        }

        /**
         * Grant read permissions for this stream and its contents to an IAM
         * principal (Role/Group/User).
         * 
         * If an encryption key is used, permission to ues the key to decrypt the
         * contents of the stream will also be granted.
         */
        @Override
        public void grantRead() {
            this.jsiiCall("grantRead", Void.class);
        }

        /**
         * Grants read/write permissions for this stream and its contents to an IAM
         * principal (Role/Group/User).
         * 
         * If an encryption key is used, permission to use the key for
         * encrypt/decrypt will also be granted.
         */
        @Override
        public void grantReadWrite(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity) {
            this.jsiiCall("grantReadWrite", Void.class, java.util.stream.Stream.of(identity).toArray());
        }

        /**
         * Grants read/write permissions for this stream and its contents to an IAM
         * principal (Role/Group/User).
         * 
         * If an encryption key is used, permission to use the key for
         * encrypt/decrypt will also be granted.
         */
        @Override
        public void grantReadWrite() {
            this.jsiiCall("grantReadWrite", Void.class);
        }

        /**
         * Grant write permissions for this stream and its contents to an IAM
         * principal (Role/Group/User).
         * 
         * If an encryption key is used, permission to ues the key to encrypt the
         * contents of the stream will also be granted.
         */
        @Override
        public void grantWrite(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity) {
            this.jsiiCall("grantWrite", Void.class, java.util.stream.Stream.of(identity).toArray());
        }

        /**
         * Grant write permissions for this stream and its contents to an IAM
         * principal (Role/Group/User).
         * 
         * If an encryption key is used, permission to ues the key to encrypt the
         * contents of the stream will also be granted.
         */
        @Override
        public void grantWrite() {
            this.jsiiCall("grantWrite", Void.class);
        }

        /**
         * Return the properties required to send subscription events to this destination.
         * 
         * If necessary, the destination can use the properties of the SubscriptionFilter
         * object itself to configure its permissions to allow the subscription to write
         * to it.
         * 
         * The destination may reconfigure its own permissions in response to this
         * function call.
         */
        @Override
        public software.amazon.awscdk.services.logs.LogSubscriptionDestination logSubscriptionDestination(final software.amazon.awscdk.services.logs.ILogGroup sourceLogGroup) {
            return this.jsiiCall("logSubscriptionDestination", software.amazon.awscdk.services.logs.LogSubscriptionDestination.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(sourceLogGroup, "sourceLogGroup is required")).toArray());
        }
    }
}
