package software.amazon.awscdk.services.kinesis;

@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-03-12T14:24:08.700Z")
public interface StreamProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The kind of server-side encryption to apply to this stream.
     * 
     * If you choose KMS, you can specify a KMS key via `encryptionKey`. If
     * encryption key is not specified, a key will automatically be created.
     * @default Unencrypted
     */
    software.amazon.awscdk.services.kinesis.StreamEncryption getEncryption();
    /**
     * The kind of server-side encryption to apply to this stream.
     * 
     * If you choose KMS, you can specify a KMS key via `encryptionKey`. If
     * encryption key is not specified, a key will automatically be created.
     * @default Unencrypted
     */
    void setEncryption(final software.amazon.awscdk.services.kinesis.StreamEncryption value);
    /**
     * External KMS key to use for stream encryption.
     * 
     * The 'encryption' property must be set to "Kms".
     * @default If encryption is set to "Kms" and this property is undefined, a new KMS key will be created and associated with this stream.
     */
    software.amazon.awscdk.services.kms.IEncryptionKey getEncryptionKey();
    /**
     * External KMS key to use for stream encryption.
     * 
     * The 'encryption' property must be set to "Kms".
     * @default If encryption is set to "Kms" and this property is undefined, a new KMS key will be created and associated with this stream.
     */
    void setEncryptionKey(final software.amazon.awscdk.services.kms.IEncryptionKey value);
    /**
     * The number of hours for the data records that are stored in shards to remain accessible.
     * @default 24
     */
    java.lang.Number getRetentionPeriodHours();
    /**
     * The number of hours for the data records that are stored in shards to remain accessible.
     * @default 24
     */
    void setRetentionPeriodHours(final java.lang.Number value);
    /**
     * The number of shards for the stream.
     * @default 1
     */
    java.lang.Number getShardCount();
    /**
     * The number of shards for the stream.
     * @default 1
     */
    void setShardCount(final java.lang.Number value);
    /**
     * Enforces a particular physical stream name.
     * @default <generated>
     */
    java.lang.String getStreamName();
    /**
     * Enforces a particular physical stream name.
     * @default <generated>
     */
    void setStreamName(final java.lang.String value);

    /**
     * @return a {@link Builder} of {@link StreamProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link StreamProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.kinesis.StreamEncryption _encryption;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.kms.IEncryptionKey _encryptionKey;
        @javax.annotation.Nullable
        private java.lang.Number _retentionPeriodHours;
        @javax.annotation.Nullable
        private java.lang.Number _shardCount;
        @javax.annotation.Nullable
        private java.lang.String _streamName;

        /**
         * Sets the value of Encryption
         * @param value The kind of server-side encryption to apply to this stream.

If you choose KMS, you can specify a KMS key via `encryptionKey`. If
encryption key is not specified, a key will automatically be created.
         * @return {@code this}
         */
        public Builder withEncryption(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesis.StreamEncryption value) {
            this._encryption = value;
            return this;
        }
        /**
         * Sets the value of EncryptionKey
         * @param value External KMS key to use for stream encryption.

The 'encryption' property must be set to "Kms".
         * @return {@code this}
         */
        public Builder withEncryptionKey(@javax.annotation.Nullable final software.amazon.awscdk.services.kms.IEncryptionKey value) {
            this._encryptionKey = value;
            return this;
        }
        /**
         * Sets the value of RetentionPeriodHours
         * @param value The number of hours for the data records that are stored in shards to remain accessible.
         * @return {@code this}
         */
        public Builder withRetentionPeriodHours(@javax.annotation.Nullable final java.lang.Number value) {
            this._retentionPeriodHours = value;
            return this;
        }
        /**
         * Sets the value of ShardCount
         * @param value The number of shards for the stream.
         * @return {@code this}
         */
        public Builder withShardCount(@javax.annotation.Nullable final java.lang.Number value) {
            this._shardCount = value;
            return this;
        }
        /**
         * Sets the value of StreamName
         * @param value Enforces a particular physical stream name.
         * @return {@code this}
         */
        public Builder withStreamName(@javax.annotation.Nullable final java.lang.String value) {
            this._streamName = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StreamProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public StreamProps build() {
            return new StreamProps() {
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.kinesis.StreamEncryption $encryption = _encryption;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.kms.IEncryptionKey $encryptionKey = _encryptionKey;
                @javax.annotation.Nullable
                private java.lang.Number $retentionPeriodHours = _retentionPeriodHours;
                @javax.annotation.Nullable
                private java.lang.Number $shardCount = _shardCount;
                @javax.annotation.Nullable
                private java.lang.String $streamName = _streamName;

                @Override
                public software.amazon.awscdk.services.kinesis.StreamEncryption getEncryption() {
                    return this.$encryption;
                }

                @Override
                public void setEncryption(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesis.StreamEncryption value) {
                    this.$encryption = value;
                }

                @Override
                public software.amazon.awscdk.services.kms.IEncryptionKey getEncryptionKey() {
                    return this.$encryptionKey;
                }

                @Override
                public void setEncryptionKey(@javax.annotation.Nullable final software.amazon.awscdk.services.kms.IEncryptionKey value) {
                    this.$encryptionKey = value;
                }

                @Override
                public java.lang.Number getRetentionPeriodHours() {
                    return this.$retentionPeriodHours;
                }

                @Override
                public void setRetentionPeriodHours(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$retentionPeriodHours = value;
                }

                @Override
                public java.lang.Number getShardCount() {
                    return this.$shardCount;
                }

                @Override
                public void setShardCount(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$shardCount = value;
                }

                @Override
                public java.lang.String getStreamName() {
                    return this.$streamName;
                }

                @Override
                public void setStreamName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$streamName = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesis.StreamProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The kind of server-side encryption to apply to this stream.
         * 
         * If you choose KMS, you can specify a KMS key via `encryptionKey`. If
         * encryption key is not specified, a key will automatically be created.
         * @default Unencrypted
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.kinesis.StreamEncryption getEncryption() {
            return this.jsiiGet("encryption", software.amazon.awscdk.services.kinesis.StreamEncryption.class);
        }

        /**
         * The kind of server-side encryption to apply to this stream.
         * 
         * If you choose KMS, you can specify a KMS key via `encryptionKey`. If
         * encryption key is not specified, a key will automatically be created.
         * @default Unencrypted
         */
        @Override
        public void setEncryption(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesis.StreamEncryption value) {
            this.jsiiSet("encryption", value);
        }

        /**
         * External KMS key to use for stream encryption.
         * 
         * The 'encryption' property must be set to "Kms".
         * @default If encryption is set to "Kms" and this property is undefined, a new KMS key will be created and associated with this stream.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.kms.IEncryptionKey getEncryptionKey() {
            return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.IEncryptionKey.class);
        }

        /**
         * External KMS key to use for stream encryption.
         * 
         * The 'encryption' property must be set to "Kms".
         * @default If encryption is set to "Kms" and this property is undefined, a new KMS key will be created and associated with this stream.
         */
        @Override
        public void setEncryptionKey(@javax.annotation.Nullable final software.amazon.awscdk.services.kms.IEncryptionKey value) {
            this.jsiiSet("encryptionKey", value);
        }

        /**
         * The number of hours for the data records that are stored in shards to remain accessible.
         * @default 24
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getRetentionPeriodHours() {
            return this.jsiiGet("retentionPeriodHours", java.lang.Number.class);
        }

        /**
         * The number of hours for the data records that are stored in shards to remain accessible.
         * @default 24
         */
        @Override
        public void setRetentionPeriodHours(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("retentionPeriodHours", value);
        }

        /**
         * The number of shards for the stream.
         * @default 1
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getShardCount() {
            return this.jsiiGet("shardCount", java.lang.Number.class);
        }

        /**
         * The number of shards for the stream.
         * @default 1
         */
        @Override
        public void setShardCount(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("shardCount", value);
        }

        /**
         * Enforces a particular physical stream name.
         * @default <generated>
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getStreamName() {
            return this.jsiiGet("streamName", java.lang.String.class);
        }

        /**
         * Enforces a particular physical stream name.
         * @default <generated>
         */
        @Override
        public void setStreamName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("streamName", value);
        }
    }
}
