package software.amazon.awscdk.services.kinesis;

/**
 * A reference to a stream. The easiest way to instantiate is to call
 * `stream.export()`. Then, the consumer can use `Stream.import(this, ref)` and
 * get a `Stream`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-03-20T12:58:45.709Z")
public interface StreamImportProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The ARN of the stream.
     */
    java.lang.String getStreamArn();
    /**
     * The ARN of the stream.
     */
    void setStreamArn(final java.lang.String value);
    /**
     * The KMS key securing the contents of the stream if encryption is enabled.
     */
    software.amazon.awscdk.services.kms.EncryptionKeyImportProps getEncryptionKey();
    /**
     * The KMS key securing the contents of the stream if encryption is enabled.
     */
    void setEncryptionKey(final software.amazon.awscdk.services.kms.EncryptionKeyImportProps value);

    /**
     * @return a {@link Builder} of {@link StreamImportProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link StreamImportProps}
     */
    final class Builder {
        private java.lang.String _streamArn;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.kms.EncryptionKeyImportProps _encryptionKey;

        /**
         * Sets the value of StreamArn
         * @param value The ARN of the stream.
         * @return {@code this}
         */
        public Builder withStreamArn(final java.lang.String value) {
            this._streamArn = java.util.Objects.requireNonNull(value, "streamArn is required");
            return this;
        }
        /**
         * Sets the value of EncryptionKey
         * @param value The KMS key securing the contents of the stream if encryption is enabled.
         * @return {@code this}
         */
        public Builder withEncryptionKey(@javax.annotation.Nullable final software.amazon.awscdk.services.kms.EncryptionKeyImportProps value) {
            this._encryptionKey = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StreamImportProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public StreamImportProps build() {
            return new StreamImportProps() {
                private java.lang.String $streamArn = java.util.Objects.requireNonNull(_streamArn, "streamArn is required");
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.kms.EncryptionKeyImportProps $encryptionKey = _encryptionKey;

                @Override
                public java.lang.String getStreamArn() {
                    return this.$streamArn;
                }

                @Override
                public void setStreamArn(final java.lang.String value) {
                    this.$streamArn = java.util.Objects.requireNonNull(value, "streamArn is required");
                }

                @Override
                public software.amazon.awscdk.services.kms.EncryptionKeyImportProps getEncryptionKey() {
                    return this.$encryptionKey;
                }

                @Override
                public void setEncryptionKey(@javax.annotation.Nullable final software.amazon.awscdk.services.kms.EncryptionKeyImportProps value) {
                    this.$encryptionKey = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesis.StreamImportProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The ARN of the stream.
         */
        @Override
        public java.lang.String getStreamArn() {
            return this.jsiiGet("streamArn", java.lang.String.class);
        }

        /**
         * The ARN of the stream.
         */
        @Override
        public void setStreamArn(final java.lang.String value) {
            this.jsiiSet("streamArn", java.util.Objects.requireNonNull(value, "streamArn is required"));
        }

        /**
         * The KMS key securing the contents of the stream if encryption is enabled.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.kms.EncryptionKeyImportProps getEncryptionKey() {
            return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.EncryptionKeyImportProps.class);
        }

        /**
         * The KMS key securing the contents of the stream if encryption is enabled.
         */
        @Override
        public void setEncryptionKey(@javax.annotation.Nullable final software.amazon.awscdk.services.kms.EncryptionKeyImportProps value) {
            this.jsiiSet("encryptionKey", value);
        }
    }
}
