package software.amazon.awscdk.services.kinesis;

/**
 * Represents a Kinesis Stream.
 * 
 * Streams can be either defined within this stack:
 * 
 *    new Stream(this, 'MyStream', { props });
 * 
 * Or imported from an existing stream:
 * 
 *    Stream.import(this, 'MyImportedStream', { streamArn: ... });
 * 
 * You can also export a stream and import it into another stack:
 * 
 *    const ref = myStream.export();
 *    Stream.import(this, 'MyImportedStream', ref);
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-04-04T15:06:48.568Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesis.$Module.class, fqn = "@aws-cdk/aws-kinesis.StreamBase")
public abstract class StreamBase extends software.amazon.awscdk.Construct implements software.amazon.awscdk.services.kinesis.IStream {
    protected StreamBase(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    /**
     * Creates a new construct node.
     * @param scope The scope in which to define this construct
     * @param id The scoped construct ID. Must be unique amongst siblings. If
the ID includes a path separator (`/`), then it will be replaced by double
dash `--`.
     */
    public StreamBase(final software.amazon.awscdk.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))).toArray());
    }

    /**
     * Exports this stream from the stack.
     */
    @Override
    public abstract software.amazon.awscdk.services.kinesis.StreamImportProps export();

    /**
     * Grant write permissions for this stream and its contents to an IAM
     * principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to ues the key to decrypt the
     * contents of the stream will also be granted.
     */
    @Override
    public software.amazon.awscdk.services.iam.Grant grantRead(final software.amazon.awscdk.services.iam.IGrantable grantee) {
        return this.jsiiCall("grantRead", software.amazon.awscdk.services.iam.Grant.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(grantee, "grantee is required")).toArray());
    }

    /**
     * Grants read/write permissions for this stream and its contents to an IAM
     * principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     */
    @Override
    public software.amazon.awscdk.services.iam.Grant grantReadWrite(final software.amazon.awscdk.services.iam.IGrantable grantee) {
        return this.jsiiCall("grantReadWrite", software.amazon.awscdk.services.iam.Grant.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(grantee, "grantee is required")).toArray());
    }

    /**
     * Grant read permissions for this stream and its contents to an IAM
     * principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to ues the key to decrypt the
     * contents of the stream will also be granted.
     */
    @Override
    public software.amazon.awscdk.services.iam.Grant grantWrite(final software.amazon.awscdk.services.iam.IGrantable grantee) {
        return this.jsiiCall("grantWrite", software.amazon.awscdk.services.iam.Grant.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(grantee, "grantee is required")).toArray());
    }

    /**
     * Return the properties required to send subscription events to this destination.
     * 
     * If necessary, the destination can use the properties of the SubscriptionFilter
     * object itself to configure its permissions to allow the subscription to write
     * to it.
     * 
     * The destination may reconfigure its own permissions in response to this
     * function call.
     */
    @Override
    public software.amazon.awscdk.services.logs.LogSubscriptionDestination logSubscriptionDestination(final software.amazon.awscdk.services.logs.ILogGroup sourceLogGroup) {
        return this.jsiiCall("logSubscriptionDestination", software.amazon.awscdk.services.logs.LogSubscriptionDestination.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(sourceLogGroup, "sourceLogGroup is required")).toArray());
    }

    /**
     * The ARN of the stream.
     */
    @Override
    public java.lang.String getStreamArn() {
        return this.jsiiGet("streamArn", java.lang.String.class);
    }

    /**
     * The name of the stream
     */
    @Override
    public java.lang.String getStreamName() {
        return this.jsiiGet("streamName", java.lang.String.class);
    }

    /**
     * Optional KMS encryption key associated with this stream.
     */
    @Override
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.kms.IEncryptionKey getEncryptionKey() {
        return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.IEncryptionKey.class);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.kinesis.StreamBase {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The ARN of the stream.
         */
        @Override
        public java.lang.String getStreamArn() {
            return this.jsiiGet("streamArn", java.lang.String.class);
        }

        /**
         * The name of the stream
         */
        @Override
        public java.lang.String getStreamName() {
            return this.jsiiGet("streamName", java.lang.String.class);
        }

        /**
         * Optional KMS encryption key associated with this stream.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.kms.IEncryptionKey getEncryptionKey() {
            return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.IEncryptionKey.class);
        }

        /**
         * The construct node in the scope tree.
         */
        @Override
        public software.amazon.awscdk.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.ConstructNode.class);
        }

        /**
         * The set of constructs that form the root of this dependable
         * 
         * All resources under all returned constructs are included in the ordering
         * dependency.
         */
        @Override
        public java.util.List<software.amazon.awscdk.IConstruct> getDependencyRoots() {
            return this.jsiiGet("dependencyRoots", java.util.List.class);
        }

        /**
         * Exports this stream from the stack.
         */
        @Override
        public software.amazon.awscdk.services.kinesis.StreamImportProps export() {
            return this.jsiiCall("export", software.amazon.awscdk.services.kinesis.StreamImportProps.class);
        }

        /**
         * Grant read permissions for this stream and its contents to an IAM
         * principal (Role/Group/User).
         * 
         * If an encryption key is used, permission to ues the key to decrypt the
         * contents of the stream will also be granted.
         */
        @Override
        public software.amazon.awscdk.services.iam.Grant grantRead(final software.amazon.awscdk.services.iam.IGrantable grantee) {
            return this.jsiiCall("grantRead", software.amazon.awscdk.services.iam.Grant.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(grantee, "grantee is required")).toArray());
        }

        /**
         * Grants read/write permissions for this stream and its contents to an IAM
         * principal (Role/Group/User).
         * 
         * If an encryption key is used, permission to use the key for
         * encrypt/decrypt will also be granted.
         */
        @Override
        public software.amazon.awscdk.services.iam.Grant grantReadWrite(final software.amazon.awscdk.services.iam.IGrantable grantee) {
            return this.jsiiCall("grantReadWrite", software.amazon.awscdk.services.iam.Grant.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(grantee, "grantee is required")).toArray());
        }

        /**
         * Grant write permissions for this stream and its contents to an IAM
         * principal (Role/Group/User).
         * 
         * If an encryption key is used, permission to ues the key to encrypt the
         * contents of the stream will also be granted.
         */
        @Override
        public software.amazon.awscdk.services.iam.Grant grantWrite(final software.amazon.awscdk.services.iam.IGrantable grantee) {
            return this.jsiiCall("grantWrite", software.amazon.awscdk.services.iam.Grant.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(grantee, "grantee is required")).toArray());
        }

        /**
         * Return the properties required to send subscription events to this destination.
         * 
         * If necessary, the destination can use the properties of the SubscriptionFilter
         * object itself to configure its permissions to allow the subscription to write
         * to it.
         * 
         * The destination may reconfigure its own permissions in response to this
         * function call.
         */
        @Override
        public software.amazon.awscdk.services.logs.LogSubscriptionDestination logSubscriptionDestination(final software.amazon.awscdk.services.logs.ILogGroup sourceLogGroup) {
            return this.jsiiCall("logSubscriptionDestination", software.amazon.awscdk.services.logs.LogSubscriptionDestination.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(sourceLogGroup, "sourceLogGroup is required")).toArray());
        }
    }
}
