/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.kinesis;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.kinesis.StreamEncryption;
import software.amazon.awscdk.services.kms.IEncryptionKey;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface StreamProps
extends JsiiSerializable {
    public StreamEncryption getEncryption();

    public IEncryptionKey getEncryptionKey();

    public Number getRetentionPeriodHours();

    public Number getShardCount();

    public String getStreamName();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private StreamEncryption _encryption;
        @Nullable
        private IEncryptionKey _encryptionKey;
        @Nullable
        private Number _retentionPeriodHours;
        @Nullable
        private Number _shardCount;
        @Nullable
        private String _streamName;

        public Builder withEncryption(@Nullable StreamEncryption value) {
            this._encryption = value;
            return this;
        }

        public Builder withEncryptionKey(@Nullable IEncryptionKey value) {
            this._encryptionKey = value;
            return this;
        }

        public Builder withRetentionPeriodHours(@Nullable Number value) {
            this._retentionPeriodHours = value;
            return this;
        }

        public Builder withShardCount(@Nullable Number value) {
            this._shardCount = value;
            return this;
        }

        public Builder withStreamName(@Nullable String value) {
            this._streamName = value;
            return this;
        }

        public StreamProps build() {
            return new StreamProps(){
                @Nullable
                private final StreamEncryption $encryption;
                @Nullable
                private final IEncryptionKey $encryptionKey;
                @Nullable
                private final Number $retentionPeriodHours;
                @Nullable
                private final Number $shardCount;
                @Nullable
                private final String $streamName;
                {
                    this.$encryption = _encryption;
                    this.$encryptionKey = _encryptionKey;
                    this.$retentionPeriodHours = _retentionPeriodHours;
                    this.$shardCount = _shardCount;
                    this.$streamName = _streamName;
                }

                @Override
                public StreamEncryption getEncryption() {
                    return this.$encryption;
                }

                @Override
                public IEncryptionKey getEncryptionKey() {
                    return this.$encryptionKey;
                }

                @Override
                public Number getRetentionPeriodHours() {
                    return this.$retentionPeriodHours;
                }

                @Override
                public Number getShardCount() {
                    return this.$shardCount;
                }

                @Override
                public String getStreamName() {
                    return this.$streamName;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("encryption", om.valueToTree((Object)this.getEncryption()));
                    obj.set("encryptionKey", om.valueToTree((Object)this.getEncryptionKey()));
                    obj.set("retentionPeriodHours", om.valueToTree((Object)this.getRetentionPeriodHours()));
                    obj.set("shardCount", om.valueToTree((Object)this.getShardCount()));
                    obj.set("streamName", om.valueToTree((Object)this.getStreamName()));
                    return obj;
                }
            };
        }
    }
}

