package software.amazon.awscdk.services.kinesis;

/**
 * Properties for defining a `AWS::Kinesis::StreamConsumer`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-streamconsumer.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-05-02T10:10:31.127Z")
public interface CfnStreamConsumerProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::Kinesis::StreamConsumer.ConsumerName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-streamconsumer.html#cfn-kinesis-streamconsumer-consumername
     */
    java.lang.String getConsumerName();
    /**
     * `AWS::Kinesis::StreamConsumer.StreamARN`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-streamconsumer.html#cfn-kinesis-streamconsumer-streamarn
     */
    java.lang.String getStreamArn();

    /**
     * @return a {@link Builder} of {@link CfnStreamConsumerProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnStreamConsumerProps}
     */
    final class Builder {
        private java.lang.String _consumerName;
        private java.lang.String _streamArn;

        /**
         * Sets the value of ConsumerName
         * @param value `AWS::Kinesis::StreamConsumer.ConsumerName`.
         * @return {@code this}
         */
        public Builder withConsumerName(final java.lang.String value) {
            this._consumerName = java.util.Objects.requireNonNull(value, "consumerName is required");
            return this;
        }
        /**
         * Sets the value of StreamArn
         * @param value `AWS::Kinesis::StreamConsumer.StreamARN`.
         * @return {@code this}
         */
        public Builder withStreamArn(final java.lang.String value) {
            this._streamArn = java.util.Objects.requireNonNull(value, "streamArn is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStreamConsumerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public CfnStreamConsumerProps build() {
            return new CfnStreamConsumerProps() {
                private final java.lang.String $consumerName = java.util.Objects.requireNonNull(_consumerName, "consumerName is required");
                private final java.lang.String $streamArn = java.util.Objects.requireNonNull(_streamArn, "streamArn is required");

                @Override
                public java.lang.String getConsumerName() {
                    return this.$consumerName;
                }

                @Override
                public java.lang.String getStreamArn() {
                    return this.$streamArn;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("consumerName", om.valueToTree(this.getConsumerName()));
                    obj.set("streamArn", om.valueToTree(this.getStreamArn()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesis.CfnStreamConsumerProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * `AWS::Kinesis::StreamConsumer.ConsumerName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-streamconsumer.html#cfn-kinesis-streamconsumer-consumername
         */
        @Override
        public java.lang.String getConsumerName() {
            return this.jsiiGet("consumerName", java.lang.String.class);
        }

        /**
         * `AWS::Kinesis::StreamConsumer.StreamARN`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-streamconsumer.html#cfn-kinesis-streamconsumer-streamarn
         */
        @Override
        public java.lang.String getStreamArn() {
            return this.jsiiGet("streamArn", java.lang.String.class);
        }
    }
}
