package software.amazon.awscdk.services.kinesis;

@javax.annotation.Generated(value = "jsii-pacmak/0.10.5 (build 46bc9b0)", date = "2019-05-24T10:15:27.061Z")
public interface StreamProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The kind of server-side encryption to apply to this stream.
     * 
     * If you choose KMS, you can specify a KMS key via `encryptionKey`. If
     * encryption key is not specified, a key will automatically be created.
     * 
     * Default: Unencrypted
     */
    software.amazon.awscdk.services.kinesis.StreamEncryption getEncryption();
    /**
     * External KMS key to use for stream encryption.
     * 
     * The 'encryption' property must be set to "Kms".
     * 
     * Default: If encryption is set to "Kms" and this property is undefined, a
     * new KMS key will be created and associated with this stream.
     */
    software.amazon.awscdk.services.kms.IKey getEncryptionKey();
    /**
     * The number of hours for the data records that are stored in shards to remain accessible.
     * 
     * Default: 24
     */
    java.lang.Number getRetentionPeriodHours();
    /**
     * The number of shards for the stream.
     * 
     * Default: 1
     */
    java.lang.Number getShardCount();
    /**
     * Enforces a particular physical stream name.
     * 
     * Default: <generated>
     */
    java.lang.String getStreamName();

    /**
     * @return a {@link Builder} of {@link StreamProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link StreamProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.kinesis.StreamEncryption _encryption;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.kms.IKey _encryptionKey;
        @javax.annotation.Nullable
        private java.lang.Number _retentionPeriodHours;
        @javax.annotation.Nullable
        private java.lang.Number _shardCount;
        @javax.annotation.Nullable
        private java.lang.String _streamName;

        /**
         * Sets the value of Encryption
         * @param value The kind of server-side encryption to apply to this stream.
         * @return {@code this}
         */
        public Builder withEncryption(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesis.StreamEncryption value) {
            this._encryption = value;
            return this;
        }
        /**
         * Sets the value of EncryptionKey
         * @param value External KMS key to use for stream encryption.
         * @return {@code this}
         */
        public Builder withEncryptionKey(@javax.annotation.Nullable final software.amazon.awscdk.services.kms.IKey value) {
            this._encryptionKey = value;
            return this;
        }
        /**
         * Sets the value of RetentionPeriodHours
         * @param value The number of hours for the data records that are stored in shards to remain accessible.
         * @return {@code this}
         */
        public Builder withRetentionPeriodHours(@javax.annotation.Nullable final java.lang.Number value) {
            this._retentionPeriodHours = value;
            return this;
        }
        /**
         * Sets the value of ShardCount
         * @param value The number of shards for the stream.
         * @return {@code this}
         */
        public Builder withShardCount(@javax.annotation.Nullable final java.lang.Number value) {
            this._shardCount = value;
            return this;
        }
        /**
         * Sets the value of StreamName
         * @param value Enforces a particular physical stream name.
         * @return {@code this}
         */
        public Builder withStreamName(@javax.annotation.Nullable final java.lang.String value) {
            this._streamName = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StreamProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public StreamProps build() {
            return new StreamProps() {
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.kinesis.StreamEncryption $encryption = _encryption;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.kms.IKey $encryptionKey = _encryptionKey;
                @javax.annotation.Nullable
                private final java.lang.Number $retentionPeriodHours = _retentionPeriodHours;
                @javax.annotation.Nullable
                private final java.lang.Number $shardCount = _shardCount;
                @javax.annotation.Nullable
                private final java.lang.String $streamName = _streamName;

                @Override
                public software.amazon.awscdk.services.kinesis.StreamEncryption getEncryption() {
                    return this.$encryption;
                }

                @Override
                public software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
                    return this.$encryptionKey;
                }

                @Override
                public java.lang.Number getRetentionPeriodHours() {
                    return this.$retentionPeriodHours;
                }

                @Override
                public java.lang.Number getShardCount() {
                    return this.$shardCount;
                }

                @Override
                public java.lang.String getStreamName() {
                    return this.$streamName;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("encryption", om.valueToTree(this.getEncryption()));
                    obj.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
                    obj.set("retentionPeriodHours", om.valueToTree(this.getRetentionPeriodHours()));
                    obj.set("shardCount", om.valueToTree(this.getShardCount()));
                    obj.set("streamName", om.valueToTree(this.getStreamName()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesis.StreamProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The kind of server-side encryption to apply to this stream.
         * 
         * If you choose KMS, you can specify a KMS key via `encryptionKey`. If
         * encryption key is not specified, a key will automatically be created.
         * 
         * Default: Unencrypted
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.kinesis.StreamEncryption getEncryption() {
            return this.jsiiGet("encryption", software.amazon.awscdk.services.kinesis.StreamEncryption.class);
        }

        /**
         * External KMS key to use for stream encryption.
         * 
         * The 'encryption' property must be set to "Kms".
         * 
         * Default: If encryption is set to "Kms" and this property is undefined, a
         * new KMS key will be created and associated with this stream.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.IKey.class);
        }

        /**
         * The number of hours for the data records that are stored in shards to remain accessible.
         * 
         * Default: 24
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getRetentionPeriodHours() {
            return this.jsiiGet("retentionPeriodHours", java.lang.Number.class);
        }

        /**
         * The number of shards for the stream.
         * 
         * Default: 1
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getShardCount() {
            return this.jsiiGet("shardCount", java.lang.Number.class);
        }

        /**
         * Enforces a particular physical stream name.
         * 
         * Default: <generated>
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getStreamName() {
            return this.jsiiGet("streamName", java.lang.String.class);
        }
    }
}
