package software.amazon.awscdk.services.kinesis;

/**
 * A Kinesis stream.
 * 
 * Can be encrypted with a KMS key.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.0 (build 3d6415e)", date = "2019-05-30T15:03:48.244Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesis.$Module.class, fqn = "@aws-cdk/aws-kinesis.Stream")
public class Stream extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.kinesis.IStream {
    protected Stream(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public Stream(final software.amazon.awscdk.Construct scope, final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.kinesis.StreamProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }
    public Stream(final software.amazon.awscdk.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    public static software.amazon.awscdk.services.kinesis.IStream fromStreamArn(final software.amazon.awscdk.Construct scope, final java.lang.String id, final java.lang.String streamArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kinesis.Stream.class, "fromStreamArn", software.amazon.awscdk.services.kinesis.IStream.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(streamArn, "streamArn is required") });
    }

    /**
     * Creates a Stream construct that represents an external stream.
     * 
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param attrs Stream import properties.
     */
    public static software.amazon.awscdk.services.kinesis.IStream fromStreamAttributes(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.kinesis.StreamAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kinesis.Stream.class, "fromStreamAttributes", software.amazon.awscdk.services.kinesis.IStream.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Grant write permissions for this stream and its contents to an IAM principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to ues the key to decrypt the
     * contents of the stream will also be granted.
     */
    @Override
    public software.amazon.awscdk.services.iam.Grant grantRead(final software.amazon.awscdk.services.iam.IGrantable grantee) {
        return this.jsiiCall("grantRead", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grants read/write permissions for this stream and its contents to an IAM principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     */
    @Override
    public software.amazon.awscdk.services.iam.Grant grantReadWrite(final software.amazon.awscdk.services.iam.IGrantable grantee) {
        return this.jsiiCall("grantReadWrite", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grant read permissions for this stream and its contents to an IAM principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to ues the key to decrypt the
     * contents of the stream will also be granted.
     */
    @Override
    public software.amazon.awscdk.services.iam.Grant grantWrite(final software.amazon.awscdk.services.iam.IGrantable grantee) {
        return this.jsiiCall("grantWrite", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * The ARN of the stream.
     */
    @Override
    public java.lang.String getStreamArn() {
        return this.jsiiGet("streamArn", java.lang.String.class);
    }

    /**
     * The name of the stream.
     */
    @Override
    public java.lang.String getStreamName() {
        return this.jsiiGet("streamName", java.lang.String.class);
    }

    /**
     * Optional KMS encryption key associated with this stream.
     */
    @Override
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.IKey.class);
    }
}
