/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.kinesis;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.Token;
import software.amazon.awscdk.services.kinesis.CfnStream;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnStreamProps
extends JsiiSerializable {
    public Object getShardCount();

    public String getName();

    public Object getRetentionPeriodHours();

    public Object getStreamEncryption();

    public List<CfnTag> getTags();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Object _shardCount;
        @Nullable
        private String _name;
        @Nullable
        private Object _retentionPeriodHours;
        @Nullable
        private Object _streamEncryption;
        @Nullable
        private List<CfnTag> _tags;

        public Builder withShardCount(Number value) {
            this._shardCount = Objects.requireNonNull(value, "shardCount is required");
            return this;
        }

        public Builder withShardCount(Token value) {
            this._shardCount = Objects.requireNonNull(value, "shardCount is required");
            return this;
        }

        public Builder withName(@Nullable String value) {
            this._name = value;
            return this;
        }

        public Builder withRetentionPeriodHours(@Nullable Number value) {
            this._retentionPeriodHours = value;
            return this;
        }

        public Builder withRetentionPeriodHours(@Nullable Token value) {
            this._retentionPeriodHours = value;
            return this;
        }

        public Builder withStreamEncryption(@Nullable Token value) {
            this._streamEncryption = value;
            return this;
        }

        public Builder withStreamEncryption(@Nullable CfnStream.StreamEncryptionProperty value) {
            this._streamEncryption = value;
            return this;
        }

        public Builder withTags(@Nullable List<CfnTag> value) {
            this._tags = value;
            return this;
        }

        public CfnStreamProps build() {
            return new CfnStreamProps(){
                private final Object $shardCount;
                @Nullable
                private final String $name;
                @Nullable
                private final Object $retentionPeriodHours;
                @Nullable
                private final Object $streamEncryption;
                @Nullable
                private final List<CfnTag> $tags;
                {
                    this.$shardCount = Objects.requireNonNull(_shardCount, "shardCount is required");
                    this.$name = _name;
                    this.$retentionPeriodHours = _retentionPeriodHours;
                    this.$streamEncryption = _streamEncryption;
                    this.$tags = _tags;
                }

                @Override
                public Object getShardCount() {
                    return this.$shardCount;
                }

                @Override
                public String getName() {
                    return this.$name;
                }

                @Override
                public Object getRetentionPeriodHours() {
                    return this.$retentionPeriodHours;
                }

                @Override
                public Object getStreamEncryption() {
                    return this.$streamEncryption;
                }

                @Override
                public List<CfnTag> getTags() {
                    return this.$tags;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("shardCount", om.valueToTree(this.getShardCount()));
                    if (this.getName() != null) {
                        obj.set("name", om.valueToTree((Object)this.getName()));
                    }
                    if (this.getRetentionPeriodHours() != null) {
                        obj.set("retentionPeriodHours", om.valueToTree(this.getRetentionPeriodHours()));
                    }
                    if (this.getStreamEncryption() != null) {
                        obj.set("streamEncryption", om.valueToTree(this.getStreamEncryption()));
                    }
                    if (this.getTags() != null) {
                        obj.set("tags", om.valueToTree(this.getTags()));
                    }
                    return obj;
                }
            };
        }
    }
}

