package software.amazon.awscdk.services.kinesis;

/**
 * Properties for defining a `AWS::Kinesis::Stream`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-03T12:13:02.977Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStreamProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::Kinesis::Stream.ShardCount`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-shardcount
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getShardCount();
    /**
     * `AWS::Kinesis::Stream.Name`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getName();
    /**
     * `AWS::Kinesis::Stream.RetentionPeriodHours`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-retentionperiodhours
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getRetentionPeriodHours();
    /**
     * `AWS::Kinesis::Stream.StreamEncryption`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-streamencryption
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Object getStreamEncryption();
    /**
     * `AWS::Kinesis::Stream.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.core.CfnTag> getTags();

    /**
     * @return a {@link Builder} of {@link CfnStreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnStreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.Number _shardCount;
        @javax.annotation.Nullable
        private java.lang.String _name;
        @javax.annotation.Nullable
        private java.lang.Number _retentionPeriodHours;
        @javax.annotation.Nullable
        private java.lang.Object _streamEncryption;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.core.CfnTag> _tags;

        /**
         * Sets the value of ShardCount
         * @param value `AWS::Kinesis::Stream.ShardCount`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withShardCount(final java.lang.Number value) {
            this._shardCount = java.util.Objects.requireNonNull(value, "shardCount is required");
            return this;
        }
        /**
         * Sets the value of Name
         * @param value `AWS::Kinesis::Stream.Name`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withName(@javax.annotation.Nullable final java.lang.String value) {
            this._name = value;
            return this;
        }
        /**
         * Sets the value of RetentionPeriodHours
         * @param value `AWS::Kinesis::Stream.RetentionPeriodHours`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withRetentionPeriodHours(@javax.annotation.Nullable final java.lang.Number value) {
            this._retentionPeriodHours = value;
            return this;
        }
        /**
         * Sets the value of StreamEncryption
         * @param value `AWS::Kinesis::Stream.StreamEncryption`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withStreamEncryption(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesis.CfnStream.StreamEncryptionProperty value) {
            this._streamEncryption = value;
            return this;
        }
        /**
         * Sets the value of StreamEncryption
         * @param value `AWS::Kinesis::Stream.StreamEncryption`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withStreamEncryption(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
            this._streamEncryption = value;
            return this;
        }
        /**
         * Sets the value of Tags
         * @param value `AWS::Kinesis::Stream.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withTags(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.core.CfnTag> value) {
            this._tags = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStreamProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public CfnStreamProps build() {
            return new CfnStreamProps() {
                private final java.lang.Number $shardCount = java.util.Objects.requireNonNull(_shardCount, "shardCount is required");
                @javax.annotation.Nullable
                private final java.lang.String $name = _name;
                @javax.annotation.Nullable
                private final java.lang.Number $retentionPeriodHours = _retentionPeriodHours;
                @javax.annotation.Nullable
                private final java.lang.Object $streamEncryption = _streamEncryption;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.core.CfnTag> $tags = _tags;

                @Override
                public java.lang.Number getShardCount() {
                    return this.$shardCount;
                }

                @Override
                public java.lang.String getName() {
                    return this.$name;
                }

                @Override
                public java.lang.Number getRetentionPeriodHours() {
                    return this.$retentionPeriodHours;
                }

                @Override
                public java.lang.Object getStreamEncryption() {
                    return this.$streamEncryption;
                }

                @Override
                public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
                    return this.$tags;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("shardCount", om.valueToTree(this.getShardCount()));
                    if (this.getName() != null) {
                        obj.set("name", om.valueToTree(this.getName()));
                    }
                    if (this.getRetentionPeriodHours() != null) {
                        obj.set("retentionPeriodHours", om.valueToTree(this.getRetentionPeriodHours()));
                    }
                    if (this.getStreamEncryption() != null) {
                        obj.set("streamEncryption", om.valueToTree(this.getStreamEncryption()));
                    }
                    if (this.getTags() != null) {
                        obj.set("tags", om.valueToTree(this.getTags()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesis.CfnStreamProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * `AWS::Kinesis::Stream.ShardCount`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-shardcount
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.Number getShardCount() {
            return this.jsiiGet("shardCount", java.lang.Number.class);
        }

        /**
         * `AWS::Kinesis::Stream.Name`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-name
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getName() {
            return this.jsiiGet("name", java.lang.String.class);
        }

        /**
         * `AWS::Kinesis::Stream.RetentionPeriodHours`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-retentionperiodhours
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Number getRetentionPeriodHours() {
            return this.jsiiGet("retentionPeriodHours", java.lang.Number.class);
        }

        /**
         * `AWS::Kinesis::Stream.StreamEncryption`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-streamencryption
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Object getStreamEncryption() {
            return this.jsiiGet("streamEncryption", java.lang.Object.class);
        }

        /**
         * `AWS::Kinesis::Stream.Tags`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-tags
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.jsiiGet("tags", java.util.List.class);
        }
    }
}
