package software.amazon.awscdk.services.kinesis;
public interface StreamProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Enforces a particular physical stream name.
     * @default <generated>
     */
    java.lang.String getStreamName();
    /**
     * Enforces a particular physical stream name.
     * @default <generated>
     */
    void setStreamName(final java.lang.String value);
    /**
     * The number of hours for the data records that are stored in shards to remain accessible.
     * @default 24
     */
    java.lang.Number getRetentionPeriodHours();
    /**
     * The number of hours for the data records that are stored in shards to remain accessible.
     * @default 24
     */
    void setRetentionPeriodHours(final java.lang.Number value);
    /**
     * The number of shards for the stream.
     * @default 1
     */
    java.lang.Number getShardCount();
    /**
     * The number of shards for the stream.
     * @default 1
     */
    void setShardCount(final java.lang.Number value);
    /**
     * The kind of server-side encryption to apply to this stream.
     * 
     * If you choose KMS, you can specify a KMS key via `encryptionKey`. If
     * encryption key is not specified, a key will automatically be created.
     * @default Unencrypted
     */
    software.amazon.awscdk.services.kinesis.StreamEncryption getEncryption();
    /**
     * The kind of server-side encryption to apply to this stream.
     * 
     * If you choose KMS, you can specify a KMS key via `encryptionKey`. If
     * encryption key is not specified, a key will automatically be created.
     * @default Unencrypted
     */
    void setEncryption(final software.amazon.awscdk.services.kinesis.StreamEncryption value);
    /**
     * External KMS key to use for stream encryption.
     * 
     * The 'encryption' property must be set to "Kms".
     * @default If encryption is set to "Kms" and this property is undefined, a new KMS key will be created and associated with this stream.
     */
    software.amazon.awscdk.services.kms.EncryptionKeyRef getEncryptionKey();
    /**
     * External KMS key to use for stream encryption.
     * 
     * The 'encryption' property must be set to "Kms".
     * @default If encryption is set to "Kms" and this property is undefined, a new KMS key will be created and associated with this stream.
     */
    void setEncryptionKey(final software.amazon.awscdk.services.kms.EncryptionKeyRef value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }

    /**
     * A fluent builder class for {@link StreamProps}.
     */
    public static final class Builder {
        private Jsii$Pojo instance = new Jsii$Pojo();

        /**
         * Enforces a particular physical stream name.
         * @default <generated>
         */
        public Builder withStreamName(final java.lang.String value) {
            this.instance._streamName = value;
            return this;
        }
        /**
         * The number of hours for the data records that are stored in shards to remain accessible.
         * @default 24
         */
        public Builder withRetentionPeriodHours(final java.lang.Number value) {
            this.instance._retentionPeriodHours = value;
            return this;
        }
        /**
         * The number of shards for the stream.
         * @default 1
         */
        public Builder withShardCount(final java.lang.Number value) {
            this.instance._shardCount = value;
            return this;
        }
        /**
         * The kind of server-side encryption to apply to this stream.
         * 
         * If you choose KMS, you can specify a KMS key via `encryptionKey`. If
         * encryption key is not specified, a key will automatically be created.
         * @default Unencrypted
         */
        public Builder withEncryption(final software.amazon.awscdk.services.kinesis.StreamEncryption value) {
            this.instance._encryption = value;
            return this;
        }
        /**
         * External KMS key to use for stream encryption.
         * 
         * The 'encryption' property must be set to "Kms".
         * @default If encryption is set to "Kms" and this property is undefined, a new KMS key will be created and associated with this stream.
         */
        public Builder withEncryptionKey(final software.amazon.awscdk.services.kms.EncryptionKeyRef value) {
            this.instance._encryptionKey = value;
            return this;
        }
        public StreamProps build() {
            StreamProps result = this.instance;
            this.instance = new Jsii$Pojo();
            return result;
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link StreamProps}.
     */
    final class Jsii$Pojo implements StreamProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.String _streamName;

        public java.lang.String getStreamName() {
            return this._streamName;
        }
        public void setStreamName(final java.lang.String value) {
            this._streamName = value;
        }

        protected java.lang.Number _retentionPeriodHours;

        public java.lang.Number getRetentionPeriodHours() {
            return this._retentionPeriodHours;
        }
        public void setRetentionPeriodHours(final java.lang.Number value) {
            this._retentionPeriodHours = value;
        }

        protected java.lang.Number _shardCount;

        public java.lang.Number getShardCount() {
            return this._shardCount;
        }
        public void setShardCount(final java.lang.Number value) {
            this._shardCount = value;
        }

        protected software.amazon.awscdk.services.kinesis.StreamEncryption _encryption;

        public software.amazon.awscdk.services.kinesis.StreamEncryption getEncryption() {
            return this._encryption;
        }
        public void setEncryption(final software.amazon.awscdk.services.kinesis.StreamEncryption value) {
            this._encryption = value;
        }

        protected software.amazon.awscdk.services.kms.EncryptionKeyRef _encryptionKey;

        public software.amazon.awscdk.services.kms.EncryptionKeyRef getEncryptionKey() {
            return this._encryptionKey;
        }
        public void setEncryptionKey(final software.amazon.awscdk.services.kms.EncryptionKeyRef value) {
            this._encryptionKey = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesis.StreamProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * Enforces a particular physical stream name.
         * @default <generated>
         */
        @javax.annotation.Nullable
        public java.lang.String getStreamName() {
            return this.jsiiGet("streamName", java.lang.String.class);
        }
        /**
         * Enforces a particular physical stream name.
         * @default <generated>
         */
        public void setStreamName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("streamName", value);
        }
        /**
         * The number of hours for the data records that are stored in shards to remain accessible.
         * @default 24
         */
        @javax.annotation.Nullable
        public java.lang.Number getRetentionPeriodHours() {
            return this.jsiiGet("retentionPeriodHours", java.lang.Number.class);
        }
        /**
         * The number of hours for the data records that are stored in shards to remain accessible.
         * @default 24
         */
        public void setRetentionPeriodHours(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("retentionPeriodHours", value);
        }
        /**
         * The number of shards for the stream.
         * @default 1
         */
        @javax.annotation.Nullable
        public java.lang.Number getShardCount() {
            return this.jsiiGet("shardCount", java.lang.Number.class);
        }
        /**
         * The number of shards for the stream.
         * @default 1
         */
        public void setShardCount(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("shardCount", value);
        }
        /**
         * The kind of server-side encryption to apply to this stream.
         * 
         * If you choose KMS, you can specify a KMS key via `encryptionKey`. If
         * encryption key is not specified, a key will automatically be created.
         * @default Unencrypted
         */
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.kinesis.StreamEncryption getEncryption() {
            return this.jsiiGet("encryption", software.amazon.awscdk.services.kinesis.StreamEncryption.class);
        }
        /**
         * The kind of server-side encryption to apply to this stream.
         * 
         * If you choose KMS, you can specify a KMS key via `encryptionKey`. If
         * encryption key is not specified, a key will automatically be created.
         * @default Unencrypted
         */
        public void setEncryption(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesis.StreamEncryption value) {
            this.jsiiSet("encryption", value);
        }
        /**
         * External KMS key to use for stream encryption.
         * 
         * The 'encryption' property must be set to "Kms".
         * @default If encryption is set to "Kms" and this property is undefined, a new KMS key will be created and associated with this stream.
         */
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.kms.EncryptionKeyRef getEncryptionKey() {
            return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.EncryptionKeyRef.class);
        }
        /**
         * External KMS key to use for stream encryption.
         * 
         * The 'encryption' property must be set to "Kms".
         * @default If encryption is set to "Kms" and this property is undefined, a new KMS key will be created and associated with this stream.
         */
        public void setEncryptionKey(@javax.annotation.Nullable final software.amazon.awscdk.services.kms.EncryptionKeyRef value) {
            this.jsiiSet("encryptionKey", value);
        }
    }
}
