package software.amazon.awscdk.services.kinesis.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesis.$Module.class, fqn = "@aws-cdk/aws-kinesis.cloudformation.StreamResource")
public class StreamResource extends software.amazon.awscdk.Resource {
    protected StreamResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesis.cloudformation.StreamResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::Kinesis::Stream``.
     * @param parent the ``cdk.Construct`` this ``StreamResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``StreamResource``
     */
    public StreamResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.kinesis.cloudformation.StreamResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @cloudformation_attribute Arn
     */
    public software.amazon.awscdk.services.kinesis.StreamArn getStreamArn() {
        return this.jsiiGet("streamArn", software.amazon.awscdk.services.kinesis.StreamArn.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html
     */
    public static interface StreamEncryptionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``StreamResource.StreamEncryptionProperty.EncryptionType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-encryptiontype
         */
        java.lang.Object getEncryptionType();
        /**
         * ``StreamResource.StreamEncryptionProperty.EncryptionType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-encryptiontype
         */
        void setEncryptionType(final java.lang.String value);
        /**
         * ``StreamResource.StreamEncryptionProperty.EncryptionType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-encryptiontype
         */
        void setEncryptionType(final software.amazon.awscdk.Token value);
        /**
         * ``StreamResource.StreamEncryptionProperty.KeyId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-keyid
         */
        java.lang.Object getKeyId();
        /**
         * ``StreamResource.StreamEncryptionProperty.KeyId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-keyid
         */
        void setKeyId(final java.lang.String value);
        /**
         * ``StreamResource.StreamEncryptionProperty.KeyId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-keyid
         */
        void setKeyId(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link StreamEncryptionProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``StreamResource.StreamEncryptionProperty.EncryptionType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-encryptiontype
             */
            public KeyIdStep withEncryptionType(final java.lang.String value) {
                return new FullBuilder().withEncryptionType(value);
            }
            /**
             * ``StreamResource.StreamEncryptionProperty.EncryptionType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-encryptiontype
             */
            public KeyIdStep withEncryptionType(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withEncryptionType(value);
            }

            public interface KeyIdStep {
                /**
                 * ``StreamResource.StreamEncryptionProperty.KeyId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-keyid
                 */
                Build withKeyId(final java.lang.String value);
                /**
                 * ``StreamResource.StreamEncryptionProperty.KeyId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-keyid
                 */
                Build withKeyId(final software.amazon.awscdk.Token value);
            }

            public interface Build {
                /**
                 * @return a new {@link StreamEncryptionProperty} object, initialized with the values set on this builder.
                 */
                StreamEncryptionProperty build();
            }

            final class FullBuilder implements KeyIdStep, Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``StreamResource.StreamEncryptionProperty.EncryptionType``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-encryptiontype
                 */
                public KeyIdStep withEncryptionType(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "StreamEncryptionProperty#encryptionType is required");
                    this.instance._encryptionType = value;
                    return this;
                }
                /**
                 * ``StreamResource.StreamEncryptionProperty.EncryptionType``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-encryptiontype
                 */
                public KeyIdStep withEncryptionType(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "StreamEncryptionProperty#encryptionType is required");
                    this.instance._encryptionType = value;
                    return this;
                }
                /**
                 * ``StreamResource.StreamEncryptionProperty.KeyId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-keyid
                 */
                public Build withKeyId(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "StreamEncryptionProperty#keyId is required");
                    this.instance._keyId = value;
                    return this;
                }
                /**
                 * ``StreamResource.StreamEncryptionProperty.KeyId``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-keyid
                 */
                public Build withKeyId(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "StreamEncryptionProperty#keyId is required");
                    this.instance._keyId = value;
                    return this;
                }
                public StreamEncryptionProperty build() {
                    StreamEncryptionProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link StreamEncryptionProperty}.
         */
        final class Jsii$Pojo implements StreamEncryptionProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _encryptionType;

            public java.lang.Object getEncryptionType() {
                return this._encryptionType;
            }
            public void setEncryptionType(final java.lang.String value) {
                this._encryptionType = value;
            }
            public void setEncryptionType(final software.amazon.awscdk.Token value) {
                this._encryptionType = value;
            }

            protected java.lang.Object _keyId;

            public java.lang.Object getKeyId() {
                return this._keyId;
            }
            public void setKeyId(final java.lang.String value) {
                this._keyId = value;
            }
            public void setKeyId(final software.amazon.awscdk.Token value) {
                this._keyId = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesis.cloudformation.StreamResource.StreamEncryptionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``StreamResource.StreamEncryptionProperty.EncryptionType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-encryptiontype
             */
            public java.lang.Object getEncryptionType() {
                return this.jsiiGet("encryptionType", java.lang.Object.class);
            }
            /**
             * ``StreamResource.StreamEncryptionProperty.EncryptionType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-encryptiontype
             */
            public void setEncryptionType(final java.lang.String value) {
                this.jsiiSet("encryptionType", java.util.Objects.requireNonNull(value, "encryptionType is required"));
            }
            /**
             * ``StreamResource.StreamEncryptionProperty.EncryptionType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-encryptiontype
             */
            public void setEncryptionType(final software.amazon.awscdk.Token value) {
                this.jsiiSet("encryptionType", java.util.Objects.requireNonNull(value, "encryptionType is required"));
            }
            /**
             * ``StreamResource.StreamEncryptionProperty.KeyId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-keyid
             */
            public java.lang.Object getKeyId() {
                return this.jsiiGet("keyId", java.lang.Object.class);
            }
            /**
             * ``StreamResource.StreamEncryptionProperty.KeyId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-keyid
             */
            public void setKeyId(final java.lang.String value) {
                this.jsiiSet("keyId", java.util.Objects.requireNonNull(value, "keyId is required"));
            }
            /**
             * ``StreamResource.StreamEncryptionProperty.KeyId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-keyid
             */
            public void setKeyId(final software.amazon.awscdk.Token value) {
                this.jsiiSet("keyId", java.util.Objects.requireNonNull(value, "keyId is required"));
            }
        }
    }
}
