package software.amazon.awscdk.services.kinesis;
/**
 * A reference to a stream. The easiest way to instantiate is to call
 * `stream.export()`. Then, the consumer can use `Stream.import(this, ref)` and
 * get a `Stream`.
 */
public interface StreamRefProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The ARN of the stream.
     */
    software.amazon.awscdk.services.kinesis.StreamArn getStreamArn();
    /**
     * The ARN of the stream.
     */
    void setStreamArn(final software.amazon.awscdk.services.kinesis.StreamArn value);
    /**
     * The KMS key securing the contents of the stream if encryption is enabled.
     */
    software.amazon.awscdk.services.kms.EncryptionKeyRefProps getEncryptionKey();
    /**
     * The KMS key securing the contents of the stream if encryption is enabled.
     */
    void setEncryptionKey(final software.amazon.awscdk.services.kms.EncryptionKeyRefProps value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link StreamRefProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * The ARN of the stream.
         */
        public Build withStreamArn(final software.amazon.awscdk.services.kinesis.StreamArn value) {
            return new FullBuilder().withStreamArn(value);
        }

        public interface Build {
            /**
             * @return a new {@link StreamRefProps} object, initialized with the values set on this builder.
             */
            StreamRefProps build();
            /**
             * The KMS key securing the contents of the stream if encryption is enabled.
             */
            Build withEncryptionKey(final software.amazon.awscdk.services.kms.EncryptionKeyRefProps value);
        }

        final class FullBuilder implements Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * The ARN of the stream.
             */
            public Build withStreamArn(final software.amazon.awscdk.services.kinesis.StreamArn value) {
                java.util.Objects.requireNonNull(value, "StreamRefProps#streamArn is required");
                this.instance._streamArn = value;
                return this;
            }
            /**
             * The KMS key securing the contents of the stream if encryption is enabled.
             */
            public Build withEncryptionKey(final software.amazon.awscdk.services.kms.EncryptionKeyRefProps value) {
                this.instance._encryptionKey = value;
                return this;
            }
            public StreamRefProps build() {
                StreamRefProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link StreamRefProps}.
     */
    final class Jsii$Pojo implements StreamRefProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected software.amazon.awscdk.services.kinesis.StreamArn _streamArn;

        public software.amazon.awscdk.services.kinesis.StreamArn getStreamArn() {
            return this._streamArn;
        }
        public void setStreamArn(final software.amazon.awscdk.services.kinesis.StreamArn value) {
            this._streamArn = value;
        }

        protected software.amazon.awscdk.services.kms.EncryptionKeyRefProps _encryptionKey;

        public software.amazon.awscdk.services.kms.EncryptionKeyRefProps getEncryptionKey() {
            return this._encryptionKey;
        }
        public void setEncryptionKey(final software.amazon.awscdk.services.kms.EncryptionKeyRefProps value) {
            this._encryptionKey = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesis.StreamRefProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * The ARN of the stream.
         */
        public software.amazon.awscdk.services.kinesis.StreamArn getStreamArn() {
            return this.jsiiGet("streamArn", software.amazon.awscdk.services.kinesis.StreamArn.class);
        }
        /**
         * The ARN of the stream.
         */
        public void setStreamArn(final software.amazon.awscdk.services.kinesis.StreamArn value) {
            this.jsiiSet("streamArn", java.util.Objects.requireNonNull(value, "streamArn is required"));
        }
        /**
         * The KMS key securing the contents of the stream if encryption is enabled.
         */
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.kms.EncryptionKeyRefProps getEncryptionKey() {
            return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.EncryptionKeyRefProps.class);
        }
        /**
         * The KMS key securing the contents of the stream if encryption is enabled.
         */
        public void setEncryptionKey(@javax.annotation.Nullable final software.amazon.awscdk.services.kms.EncryptionKeyRefProps value) {
            this.jsiiSet("encryptionKey", value);
        }
    }
}
