package software.amazon.awscdk.services.kinesis.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html
 */
public interface StreamResourceProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * ``AWS::Kinesis::Stream.ShardCount``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-shardcount
     */
    java.lang.Object getShardCount();
    /**
     * ``AWS::Kinesis::Stream.ShardCount``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-shardcount
     */
    void setShardCount(final java.lang.Number value);
    /**
     * ``AWS::Kinesis::Stream.ShardCount``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-shardcount
     */
    void setShardCount(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::Kinesis::Stream.Name``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-name
     */
    java.lang.Object getStreamName();
    /**
     * ``AWS::Kinesis::Stream.Name``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-name
     */
    void setStreamName(final java.lang.String value);
    /**
     * ``AWS::Kinesis::Stream.Name``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-name
     */
    void setStreamName(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::Kinesis::Stream.RetentionPeriodHours``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-retentionperiodhours
     */
    java.lang.Object getRetentionPeriodHours();
    /**
     * ``AWS::Kinesis::Stream.RetentionPeriodHours``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-retentionperiodhours
     */
    void setRetentionPeriodHours(final java.lang.Number value);
    /**
     * ``AWS::Kinesis::Stream.RetentionPeriodHours``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-retentionperiodhours
     */
    void setRetentionPeriodHours(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::Kinesis::Stream.StreamEncryption``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-streamencryption
     */
    java.lang.Object getStreamEncryption();
    /**
     * ``AWS::Kinesis::Stream.StreamEncryption``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-streamencryption
     */
    void setStreamEncryption(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::Kinesis::Stream.StreamEncryption``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-streamencryption
     */
    void setStreamEncryption(final software.amazon.awscdk.services.kinesis.cloudformation.StreamResource.StreamEncryptionProperty value);
    /**
     * ``AWS::Kinesis::Stream.Tags``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-tags
     */
    java.lang.Object getTags();
    /**
     * ``AWS::Kinesis::Stream.Tags``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-tags
     */
    void setTags(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::Kinesis::Stream.Tags``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-tags
     */
    void setTags(final java.util.List<java.lang.Object> value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link StreamResourceProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * ``AWS::Kinesis::Stream.ShardCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-shardcount
         */
        public Build withShardCount(final java.lang.Number value) {
            return new FullBuilder().withShardCount(value);
        }
        /**
         * ``AWS::Kinesis::Stream.ShardCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-shardcount
         */
        public Build withShardCount(final software.amazon.awscdk.Token value) {
            return new FullBuilder().withShardCount(value);
        }

        public interface Build {
            /**
             * @return a new {@link StreamResourceProps} object, initialized with the values set on this builder.
             */
            StreamResourceProps build();
            /**
             * ``AWS::Kinesis::Stream.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-name
             */
            Build withStreamName(final java.lang.String value);
            /**
             * ``AWS::Kinesis::Stream.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-name
             */
            Build withStreamName(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::Kinesis::Stream.RetentionPeriodHours``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-retentionperiodhours
             */
            Build withRetentionPeriodHours(final java.lang.Number value);
            /**
             * ``AWS::Kinesis::Stream.RetentionPeriodHours``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-retentionperiodhours
             */
            Build withRetentionPeriodHours(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::Kinesis::Stream.StreamEncryption``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-streamencryption
             */
            Build withStreamEncryption(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::Kinesis::Stream.StreamEncryption``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-streamencryption
             */
            Build withStreamEncryption(final software.amazon.awscdk.services.kinesis.cloudformation.StreamResource.StreamEncryptionProperty value);
            /**
             * ``AWS::Kinesis::Stream.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-tags
             */
            Build withTags(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::Kinesis::Stream.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-tags
             */
            Build withTags(final java.util.List<java.lang.Object> value);
        }

        final class FullBuilder implements Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``AWS::Kinesis::Stream.ShardCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-shardcount
             */
            public Build withShardCount(final java.lang.Number value) {
                java.util.Objects.requireNonNull(value, "StreamResourceProps#shardCount is required");
                this.instance._shardCount = value;
                return this;
            }
            /**
             * ``AWS::Kinesis::Stream.ShardCount``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-shardcount
             */
            public Build withShardCount(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "StreamResourceProps#shardCount is required");
                this.instance._shardCount = value;
                return this;
            }
            /**
             * ``AWS::Kinesis::Stream.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-name
             */
            public Build withStreamName(final java.lang.String value) {
                this.instance._streamName = value;
                return this;
            }
            /**
             * ``AWS::Kinesis::Stream.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-name
             */
            public Build withStreamName(final software.amazon.awscdk.Token value) {
                this.instance._streamName = value;
                return this;
            }
            /**
             * ``AWS::Kinesis::Stream.RetentionPeriodHours``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-retentionperiodhours
             */
            public Build withRetentionPeriodHours(final java.lang.Number value) {
                this.instance._retentionPeriodHours = value;
                return this;
            }
            /**
             * ``AWS::Kinesis::Stream.RetentionPeriodHours``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-retentionperiodhours
             */
            public Build withRetentionPeriodHours(final software.amazon.awscdk.Token value) {
                this.instance._retentionPeriodHours = value;
                return this;
            }
            /**
             * ``AWS::Kinesis::Stream.StreamEncryption``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-streamencryption
             */
            public Build withStreamEncryption(final software.amazon.awscdk.Token value) {
                this.instance._streamEncryption = value;
                return this;
            }
            /**
             * ``AWS::Kinesis::Stream.StreamEncryption``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-streamencryption
             */
            public Build withStreamEncryption(final software.amazon.awscdk.services.kinesis.cloudformation.StreamResource.StreamEncryptionProperty value) {
                this.instance._streamEncryption = value;
                return this;
            }
            /**
             * ``AWS::Kinesis::Stream.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-tags
             */
            public Build withTags(final software.amazon.awscdk.Token value) {
                this.instance._tags = value;
                return this;
            }
            /**
             * ``AWS::Kinesis::Stream.Tags``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-tags
             */
            public Build withTags(final java.util.List<java.lang.Object> value) {
                this.instance._tags = value;
                return this;
            }
            public StreamResourceProps build() {
                StreamResourceProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link StreamResourceProps}.
     */
    final class Jsii$Pojo implements StreamResourceProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.Object _shardCount;

        public java.lang.Object getShardCount() {
            return this._shardCount;
        }
        public void setShardCount(final java.lang.Number value) {
            this._shardCount = value;
        }
        public void setShardCount(final software.amazon.awscdk.Token value) {
            this._shardCount = value;
        }

        protected java.lang.Object _streamName;

        public java.lang.Object getStreamName() {
            return this._streamName;
        }
        public void setStreamName(final java.lang.String value) {
            this._streamName = value;
        }
        public void setStreamName(final software.amazon.awscdk.Token value) {
            this._streamName = value;
        }

        protected java.lang.Object _retentionPeriodHours;

        public java.lang.Object getRetentionPeriodHours() {
            return this._retentionPeriodHours;
        }
        public void setRetentionPeriodHours(final java.lang.Number value) {
            this._retentionPeriodHours = value;
        }
        public void setRetentionPeriodHours(final software.amazon.awscdk.Token value) {
            this._retentionPeriodHours = value;
        }

        protected java.lang.Object _streamEncryption;

        public java.lang.Object getStreamEncryption() {
            return this._streamEncryption;
        }
        public void setStreamEncryption(final software.amazon.awscdk.Token value) {
            this._streamEncryption = value;
        }
        public void setStreamEncryption(final software.amazon.awscdk.services.kinesis.cloudformation.StreamResource.StreamEncryptionProperty value) {
            this._streamEncryption = value;
        }

        protected java.lang.Object _tags;

        public java.lang.Object getTags() {
            return this._tags;
        }
        public void setTags(final software.amazon.awscdk.Token value) {
            this._tags = value;
        }
        public void setTags(final java.util.List<java.lang.Object> value) {
            this._tags = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesis.cloudformation.StreamResourceProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * ``AWS::Kinesis::Stream.ShardCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-shardcount
         */
        public java.lang.Object getShardCount() {
            return this.jsiiGet("shardCount", java.lang.Object.class);
        }
        /**
         * ``AWS::Kinesis::Stream.ShardCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-shardcount
         */
        public void setShardCount(final java.lang.Number value) {
            this.jsiiSet("shardCount", java.util.Objects.requireNonNull(value, "shardCount is required"));
        }
        /**
         * ``AWS::Kinesis::Stream.ShardCount``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-shardcount
         */
        public void setShardCount(final software.amazon.awscdk.Token value) {
            this.jsiiSet("shardCount", java.util.Objects.requireNonNull(value, "shardCount is required"));
        }
        /**
         * ``AWS::Kinesis::Stream.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-name
         */
        @javax.annotation.Nullable
        public java.lang.Object getStreamName() {
            return this.jsiiGet("streamName", java.lang.Object.class);
        }
        /**
         * ``AWS::Kinesis::Stream.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-name
         */
        public void setStreamName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("streamName", value);
        }
        /**
         * ``AWS::Kinesis::Stream.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-name
         */
        public void setStreamName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("streamName", value);
        }
        /**
         * ``AWS::Kinesis::Stream.RetentionPeriodHours``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-retentionperiodhours
         */
        @javax.annotation.Nullable
        public java.lang.Object getRetentionPeriodHours() {
            return this.jsiiGet("retentionPeriodHours", java.lang.Object.class);
        }
        /**
         * ``AWS::Kinesis::Stream.RetentionPeriodHours``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-retentionperiodhours
         */
        public void setRetentionPeriodHours(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("retentionPeriodHours", value);
        }
        /**
         * ``AWS::Kinesis::Stream.RetentionPeriodHours``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-retentionperiodhours
         */
        public void setRetentionPeriodHours(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("retentionPeriodHours", value);
        }
        /**
         * ``AWS::Kinesis::Stream.StreamEncryption``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-streamencryption
         */
        @javax.annotation.Nullable
        public java.lang.Object getStreamEncryption() {
            return this.jsiiGet("streamEncryption", java.lang.Object.class);
        }
        /**
         * ``AWS::Kinesis::Stream.StreamEncryption``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-streamencryption
         */
        public void setStreamEncryption(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("streamEncryption", value);
        }
        /**
         * ``AWS::Kinesis::Stream.StreamEncryption``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-streamencryption
         */
        public void setStreamEncryption(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesis.cloudformation.StreamResource.StreamEncryptionProperty value) {
            this.jsiiSet("streamEncryption", value);
        }
        /**
         * ``AWS::Kinesis::Stream.Tags``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-tags
         */
        @javax.annotation.Nullable
        public java.lang.Object getTags() {
            return this.jsiiGet("tags", java.lang.Object.class);
        }
        /**
         * ``AWS::Kinesis::Stream.Tags``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-tags
         */
        public void setTags(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("tags", value);
        }
        /**
         * ``AWS::Kinesis::Stream.Tags``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-tags
         */
        public void setTags(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
            this.jsiiSet("tags", value);
        }
    }
}
