package software.amazon.awscdk.services.kinesis;

/**
 * Represents a Kinesis Stream.
 * 
 * Streams can be either defined within this stack:
 * 
 *      new Stream(this, 'MyStream', { props });
 * 
 * Or imported from an existing stream:
 * 
 *      StreamRef.import(this, 'MyImportedStream', { streamArn: ... });
 * 
 * You can also export a stream and import it into another stack:
 * 
 *      const ref = myStream.export();
 *      StreamRef.import(this, 'MyImportedStream', ref);
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.5 (build 845cc48)", date = "2018-09-14T09:17:40.763Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesis.$Module.class, fqn = "@aws-cdk/aws-kinesis.StreamRef")
public abstract class StreamRef extends software.amazon.awscdk.Construct implements software.amazon.awscdk.services.logs.ILogSubscriptionDestination {
    protected StreamRef(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }

    /**
     * Creates a Stream construct that represents an external stream.
     * @param parent The parent creating construct (usually `this`).
     * @param name The construct's name.
     */
    public static software.amazon.awscdk.services.kinesis.StreamRef import_(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.kinesis.StreamRefProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kinesis.StreamRef.class, "import", software.amazon.awscdk.services.kinesis.StreamRef.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * Exports this stream from the stack.
     */
    public software.amazon.awscdk.services.kinesis.StreamRefProps export() {
        return this.jsiiCall("export", software.amazon.awscdk.services.kinesis.StreamRefProps.class);
    }

    /**
     * Grant write permissions for this stream and its contents to an IAM
     * principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to ues the key to decrypt the
     * contents of the stream will also be granted.
     */
    public void grantRead(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IIdentityResource identity) {
        this.jsiiCall("grantRead", Void.class, java.util.stream.Stream.of(identity).toArray());
    }

    /**
     * Grant write permissions for this stream and its contents to an IAM
     * principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to ues the key to decrypt the
     * contents of the stream will also be granted.
     */
    public void grantRead() {
        this.jsiiCall("grantRead", Void.class);
    }

    /**
     * Grants read/write permissions for this stream and its contents to an IAM
     * principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     */
    public void grantReadWrite(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IIdentityResource identity) {
        this.jsiiCall("grantReadWrite", Void.class, java.util.stream.Stream.of(identity).toArray());
    }

    /**
     * Grants read/write permissions for this stream and its contents to an IAM
     * principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     */
    public void grantReadWrite() {
        this.jsiiCall("grantReadWrite", Void.class);
    }

    /**
     * Grant read permissions for this stream and its contents to an IAM
     * principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to ues the key to decrypt the
     * contents of the stream will also be granted.
     */
    public void grantWrite(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IIdentityResource identity) {
        this.jsiiCall("grantWrite", Void.class, java.util.stream.Stream.of(identity).toArray());
    }

    /**
     * Grant read permissions for this stream and its contents to an IAM
     * principal (Role/Group/User).
     * 
     * If an encryption key is used, permission to ues the key to decrypt the
     * contents of the stream will also be granted.
     */
    public void grantWrite() {
        this.jsiiCall("grantWrite", Void.class);
    }

    /**
     * Return the properties required to send subscription events to this destination.
     * 
     * If necessary, the destination can use the properties of the SubscriptionFilter
     * object itself to configure its permissions to allow the subscription to write
     * to it.
     * 
     * The destination may reconfigure its own permissions in response to this
     * function call.
     */
    @Override
    public software.amazon.awscdk.services.logs.LogSubscriptionDestination logSubscriptionDestination(final software.amazon.awscdk.services.logs.LogGroupRef sourceLogGroup) {
        return this.jsiiCall("logSubscriptionDestination", software.amazon.awscdk.services.logs.LogSubscriptionDestination.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(sourceLogGroup, "sourceLogGroup is required")).toArray());
    }

    /**
     * The ARN of the stream.
     */
    public software.amazon.awscdk.services.kinesis.StreamArn getStreamArn() {
        return this.jsiiGet("streamArn", software.amazon.awscdk.services.kinesis.StreamArn.class);
    }

    /**
     * The name of the stream
     */
    public software.amazon.awscdk.services.kinesis.StreamName getStreamName() {
        return this.jsiiGet("streamName", software.amazon.awscdk.services.kinesis.StreamName.class);
    }

    /**
     * Optional KMS encryption key associated with this stream.
     */
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.kms.EncryptionKeyRef getEncryptionKey() {
        return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.EncryptionKeyRef.class);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.kinesis.StreamRef {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The ARN of the stream.
         */
        @Override
        public software.amazon.awscdk.services.kinesis.StreamArn getStreamArn() {
            return this.jsiiGet("streamArn", software.amazon.awscdk.services.kinesis.StreamArn.class);
        }

        /**
         * The name of the stream
         */
        @Override
        public software.amazon.awscdk.services.kinesis.StreamName getStreamName() {
            return this.jsiiGet("streamName", software.amazon.awscdk.services.kinesis.StreamName.class);
        }

        /**
         * Optional KMS encryption key associated with this stream.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.kms.EncryptionKeyRef getEncryptionKey() {
            return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.EncryptionKeyRef.class);
        }

        /**
         * Return the properties required to send subscription events to this destination.
         * 
         * If necessary, the destination can use the properties of the SubscriptionFilter
         * object itself to configure its permissions to allow the subscription to write
         * to it.
         * 
         * The destination may reconfigure its own permissions in response to this
         * function call.
         */
        @Override
        public software.amazon.awscdk.services.logs.LogSubscriptionDestination logSubscriptionDestination(final software.amazon.awscdk.services.logs.LogGroupRef sourceLogGroup) {
            return this.jsiiCall("logSubscriptionDestination", software.amazon.awscdk.services.logs.LogSubscriptionDestination.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(sourceLogGroup, "sourceLogGroup is required")).toArray());
        }
    }
}
