package software.amazon.awscdk.services.kinesis;

/**
 * A reference to a stream. The easiest way to instantiate is to call
 * `stream.export()`. Then, the consumer can use `Stream.import(this, ref)` and
 * get a `Stream`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.5 (build 845cc48)", date = "2018-09-14T09:17:40.764Z")
public interface StreamRefProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The ARN of the stream.
     */
    software.amazon.awscdk.services.kinesis.StreamArn getStreamArn();
    /**
     * The ARN of the stream.
     */
    void setStreamArn(final software.amazon.awscdk.services.kinesis.StreamArn value);
    /**
     * The KMS key securing the contents of the stream if encryption is enabled.
     */
    software.amazon.awscdk.services.kms.EncryptionKeyRefProps getEncryptionKey();
    /**
     * The KMS key securing the contents of the stream if encryption is enabled.
     */
    void setEncryptionKey(final software.amazon.awscdk.services.kms.EncryptionKeyRefProps value);

    /**
     * @return a {@link Builder} of {@link StreamRefProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link StreamRefProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.kinesis.StreamArn _streamArn;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.kms.EncryptionKeyRefProps _encryptionKey;

        /**
         * Sets the value of StreamArn
         * @param value The ARN of the stream.
         * @return {@code this}
         */
        public Builder withStreamArn(final software.amazon.awscdk.services.kinesis.StreamArn value) {
            this._streamArn = java.util.Objects.requireNonNull(value, "streamArn is required");
            return this;
        }
        /**
         * Sets the value of EncryptionKey
         * @param value The KMS key securing the contents of the stream if encryption is enabled.
         * @return {@code this}
         */
        public Builder withEncryptionKey(@javax.annotation.Nullable final software.amazon.awscdk.services.kms.EncryptionKeyRefProps value) {
            this._encryptionKey = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StreamRefProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public StreamRefProps build() {
            return new StreamRefProps() {
                private software.amazon.awscdk.services.kinesis.StreamArn $streamArn = java.util.Objects.requireNonNull(_streamArn, "streamArn is required");
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.kms.EncryptionKeyRefProps $encryptionKey = _encryptionKey;

                @Override
                public software.amazon.awscdk.services.kinesis.StreamArn getStreamArn() {
                    return this.$streamArn;
                }

                @Override
                public void setStreamArn(final software.amazon.awscdk.services.kinesis.StreamArn value) {
                    this.$streamArn = java.util.Objects.requireNonNull(value, "streamArn is required");
                }

                @Override
                public software.amazon.awscdk.services.kms.EncryptionKeyRefProps getEncryptionKey() {
                    return this.$encryptionKey;
                }

                @Override
                public void setEncryptionKey(@javax.annotation.Nullable final software.amazon.awscdk.services.kms.EncryptionKeyRefProps value) {
                    this.$encryptionKey = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesis.StreamRefProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The ARN of the stream.
         */
        @Override
        public software.amazon.awscdk.services.kinesis.StreamArn getStreamArn() {
            return this.jsiiGet("streamArn", software.amazon.awscdk.services.kinesis.StreamArn.class);
        }

        /**
         * The ARN of the stream.
         */
        @Override
        public void setStreamArn(final software.amazon.awscdk.services.kinesis.StreamArn value) {
            this.jsiiSet("streamArn", java.util.Objects.requireNonNull(value, "streamArn is required"));
        }

        /**
         * The KMS key securing the contents of the stream if encryption is enabled.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.kms.EncryptionKeyRefProps getEncryptionKey() {
            return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.EncryptionKeyRefProps.class);
        }

        /**
         * The KMS key securing the contents of the stream if encryption is enabled.
         */
        @Override
        public void setEncryptionKey(@javax.annotation.Nullable final software.amazon.awscdk.services.kms.EncryptionKeyRefProps value) {
            this.jsiiSet("encryptionKey", value);
        }
    }
}
