/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.kinesis;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface StreamAttributes
extends JsiiSerializable {
    public String getStreamArn();

    public IKey getEncryptionKey();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _streamArn;
        @Nullable
        private IKey _encryptionKey;

        public Builder withStreamArn(String value) {
            this._streamArn = Objects.requireNonNull(value, "streamArn is required");
            return this;
        }

        public Builder withEncryptionKey(@Nullable IKey value) {
            this._encryptionKey = value;
            return this;
        }

        public StreamAttributes build() {
            return new StreamAttributes(){
                private final String $streamArn;
                @Nullable
                private final IKey $encryptionKey;
                {
                    this.$streamArn = Objects.requireNonNull(_streamArn, "streamArn is required");
                    this.$encryptionKey = _encryptionKey;
                }

                @Override
                public String getStreamArn() {
                    return this.$streamArn;
                }

                @Override
                public IKey getEncryptionKey() {
                    return this.$encryptionKey;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("streamArn", om.valueToTree((Object)this.getStreamArn()));
                    if (this.getEncryptionKey() != null) {
                        obj.set("encryptionKey", om.valueToTree((Object)this.getEncryptionKey()));
                    }
                    return obj;
                }
            };
        }
    }
}

