package software.amazon.awscdk.services.kinesis;

/**
 * Properties for defining a `AWS::Kinesis::Stream`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.0 (build 7d5d104)", date = "2019-09-30T08:33:59.810Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnStreamProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::Kinesis::Stream.ShardCount`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-shardcount
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Number getShardCount();

    /**
     * `AWS::Kinesis::Stream.Name`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getName();

    /**
     * `AWS::Kinesis::Stream.RetentionPeriodHours`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-retentionperiodhours
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Number getRetentionPeriodHours();

    /**
     * `AWS::Kinesis::Stream.StreamEncryption`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-streamencryption
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getStreamEncryption();

    /**
     * `AWS::Kinesis::Stream.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.util.List<software.amazon.awscdk.core.CfnTag> getTags();

    /**
     * @return a {@link Builder} of {@link CfnStreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.Number shardCount;
        private java.lang.String name;
        private java.lang.Number retentionPeriodHours;
        private java.lang.Object streamEncryption;
        private java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of ShardCount
         * @param shardCount `AWS::Kinesis::Stream.ShardCount`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder shardCount(java.lang.Number shardCount) {
            this.shardCount = shardCount;
            return this;
        }

        /**
         * Sets the value of Name
         * @param name `AWS::Kinesis::Stream.Name`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of RetentionPeriodHours
         * @param retentionPeriodHours `AWS::Kinesis::Stream.RetentionPeriodHours`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder retentionPeriodHours(java.lang.Number retentionPeriodHours) {
            this.retentionPeriodHours = retentionPeriodHours;
            return this;
        }

        /**
         * Sets the value of StreamEncryption
         * @param streamEncryption `AWS::Kinesis::Stream.StreamEncryption`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder streamEncryption(software.amazon.awscdk.services.kinesis.CfnStream.StreamEncryptionProperty streamEncryption) {
            this.streamEncryption = streamEncryption;
            return this;
        }

        /**
         * Sets the value of StreamEncryption
         * @param streamEncryption `AWS::Kinesis::Stream.StreamEncryption`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder streamEncryption(software.amazon.awscdk.core.IResolvable streamEncryption) {
            this.streamEncryption = streamEncryption;
            return this;
        }

        /**
         * Sets the value of Tags
         * @param tags `AWS::Kinesis::Stream.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStreamProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnStreamProps build() {
            return new Jsii$Proxy(shardCount, name, retentionPeriodHours, streamEncryption, tags);
        }
    }

    /**
     * An implementation for {@link CfnStreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStreamProps {
        private final java.lang.Number shardCount;
        private final java.lang.String name;
        private final java.lang.Number retentionPeriodHours;
        private final java.lang.Object streamEncryption;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.shardCount = this.jsiiGet("shardCount", java.lang.Number.class);
            this.name = this.jsiiGet("name", java.lang.String.class);
            this.retentionPeriodHours = this.jsiiGet("retentionPeriodHours", java.lang.Number.class);
            this.streamEncryption = this.jsiiGet("streamEncryption", java.lang.Object.class);
            this.tags = this.jsiiGet("tags", java.util.List.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.Number shardCount, java.lang.String name, java.lang.Number retentionPeriodHours, java.lang.Object streamEncryption, java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.shardCount = java.util.Objects.requireNonNull(shardCount, "shardCount is required");
            this.name = name;
            this.retentionPeriodHours = retentionPeriodHours;
            this.streamEncryption = streamEncryption;
            this.tags = tags;
        }

        @Override
        public java.lang.Number getShardCount() {
            return this.shardCount;
        }

        @Override
        public java.lang.String getName() {
            return this.name;
        }

        @Override
        public java.lang.Number getRetentionPeriodHours() {
            return this.retentionPeriodHours;
        }

        @Override
        public java.lang.Object getStreamEncryption() {
            return this.streamEncryption;
        }

        @Override
        public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("shardCount", om.valueToTree(this.getShardCount()));
            if (this.getName() != null) {
                obj.set("name", om.valueToTree(this.getName()));
            }
            if (this.getRetentionPeriodHours() != null) {
                obj.set("retentionPeriodHours", om.valueToTree(this.getRetentionPeriodHours()));
            }
            if (this.getStreamEncryption() != null) {
                obj.set("streamEncryption", om.valueToTree(this.getStreamEncryption()));
            }
            if (this.getTags() != null) {
                obj.set("tags", om.valueToTree(this.getTags()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStreamProps.Jsii$Proxy that = (CfnStreamProps.Jsii$Proxy) o;

            if (!shardCount.equals(that.shardCount)) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.retentionPeriodHours != null ? !this.retentionPeriodHours.equals(that.retentionPeriodHours) : that.retentionPeriodHours != null) return false;
            if (this.streamEncryption != null ? !this.streamEncryption.equals(that.streamEncryption) : that.streamEncryption != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public int hashCode() {
            int result = this.shardCount.hashCode();
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.retentionPeriodHours != null ? this.retentionPeriodHours.hashCode() : 0);
            result = 31 * result + (this.streamEncryption != null ? this.streamEncryption.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
