package software.amazon.awscdk.services.kinesis;

/**
 * A Kinesis Stream.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-05-10T21:38:02.853Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesis.$Module.class, fqn = "@aws-cdk/aws-kinesis.IStream")
@software.amazon.jsii.Jsii.Proxy(IStream.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IStream extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.core.IResource {

    /**
     * The ARN of the stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStreamArn();

    /**
     * The name of the stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStreamName();

    /**
     * Optional KMS encryption key associated with this stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * Grant the indicated permissions on this stream to the provided IAM principal.
     * <p>
     * @param grantee This parameter is required.
     * @param actions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions);

    /**
     * Grant read permissions for this stream and its contents to an IAM principal (Role/Group/User).
     * <p>
     * If an encryption key is used, permission to ues the key to decrypt the
     * contents of the stream will also be granted.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * Grants read/write permissions for this stream and its contents to an IAM principal (Role/Group/User).
     * <p>
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * Grant write permissions for this stream and its contents to an IAM principal (Role/Group/User).
     * <p>
     * If an encryption key is used, permission to ues the key to encrypt the
     * contents of the stream will also be granted.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * Return stream metric based from its metric name.
     * <p>
     * @param metricName name of the stream metric. This parameter is required.
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * Return stream metric based from its metric name.
     * <p>
     * @param metricName name of the stream metric. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName);

    /**
     * The number of records retrieved from the shard, measured over the specified time period.
     * <p>
     * Minimum, Maximum, and
     * Average statistics represent the records in a single GetRecords operation for the stream in the specified time
     * period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecords(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of records retrieved from the shard, measured over the specified time period.
     * <p>
     * Minimum, Maximum, and
     * Average statistics represent the records in a single GetRecords operation for the stream in the specified time
     * period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecords();

    /**
     * The number of bytes retrieved from the Kinesis stream, measured over the specified time period.
     * <p>
     * Minimum, Maximum,
     * and Average statistics represent the bytes in a single GetRecords operation for the stream in the specified time
     * period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecordsBytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of bytes retrieved from the Kinesis stream, measured over the specified time period.
     * <p>
     * Minimum, Maximum,
     * and Average statistics represent the bytes in a single GetRecords operation for the stream in the specified time
     * period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecordsBytes();

    /**
     * The age of the last record in all GetRecords calls made against a Kinesis stream, measured over the specified time period.
     * <p>
     * Age is the difference between the current time and when the last record of the GetRecords call was written
     * to the stream. The Minimum and Maximum statistics can be used to track the progress of Kinesis consumer
     * applications. A value of zero indicates that the records being read are completely caught up with the stream.
     * <p>
     * The metric defaults to maximum over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecordsIteratorAgeMilliseconds(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The age of the last record in all GetRecords calls made against a Kinesis stream, measured over the specified time period.
     * <p>
     * Age is the difference between the current time and when the last record of the GetRecords call was written
     * to the stream. The Minimum and Maximum statistics can be used to track the progress of Kinesis consumer
     * applications. A value of zero indicates that the records being read are completely caught up with the stream.
     * <p>
     * The metric defaults to maximum over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecordsIteratorAgeMilliseconds();

    /**
     * The time taken per GetRecords operation, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecordsLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The time taken per GetRecords operation, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecordsLatency();

    /**
     * The number of successful GetRecords operations per stream, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecordsSuccess(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of successful GetRecords operations per stream, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecordsSuccess();

    /**
     * The number of bytes successfully put to the Kinesis stream over the specified time period.
     * <p>
     * This metric includes
     * bytes from PutRecord and PutRecords operations. Minimum, Maximum, and Average statistics represent the bytes in a
     * single put operation for the stream in the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIncomingBytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of bytes successfully put to the Kinesis stream over the specified time period.
     * <p>
     * This metric includes
     * bytes from PutRecord and PutRecords operations. Minimum, Maximum, and Average statistics represent the bytes in a
     * single put operation for the stream in the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIncomingBytes();

    /**
     * The number of records successfully put to the Kinesis stream over the specified time period.
     * <p>
     * This metric includes
     * record counts from PutRecord and PutRecords operations. Minimum, Maximum, and Average statistics represent the
     * records in a single put operation for the stream in the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIncomingRecords(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of records successfully put to the Kinesis stream over the specified time period.
     * <p>
     * This metric includes
     * record counts from PutRecord and PutRecords operations. Minimum, Maximum, and Average statistics represent the
     * records in a single put operation for the stream in the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIncomingRecords();

    /**
     * The number of bytes put to the Kinesis stream using the PutRecord operation over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordBytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of bytes put to the Kinesis stream using the PutRecord operation over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordBytes();

    /**
     * The time taken per PutRecord operation, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The time taken per PutRecord operation, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordLatency();

    /**
     * The number of bytes put to the Kinesis stream using the PutRecords operation over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsBytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of bytes put to the Kinesis stream using the PutRecords operation over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsBytes();

    /**
     * The number of records rejected due to internal failures in a PutRecords operation per Kinesis data stream, measured over the specified time period.
     * <p>
     * Occasional internal failures are to be expected and should be retried.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsFailedRecords(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of records rejected due to internal failures in a PutRecords operation per Kinesis data stream, measured over the specified time period.
     * <p>
     * Occasional internal failures are to be expected and should be retried.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsFailedRecords();

    /**
     * The time taken per PutRecords operation, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The time taken per PutRecords operation, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsLatency();

    /**
     * The number of PutRecords operations where at least one record succeeded, per Kinesis stream, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsSuccess(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of PutRecords operations where at least one record succeeded, per Kinesis stream, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsSuccess();

    /**
     * The number of successful records in a PutRecords operation per Kinesis data stream, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsSuccessfulRecords(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of successful records in a PutRecords operation per Kinesis data stream, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsSuccessfulRecords();

    /**
     * The number of records rejected due to throttling in a PutRecords operation per Kinesis data stream, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsThrottledRecords(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of records rejected due to throttling in a PutRecords operation per Kinesis data stream, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsThrottledRecords();

    /**
     * The total number of records sent in a PutRecords operation per Kinesis data stream, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsTotalRecords(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The total number of records sent in a PutRecords operation per Kinesis data stream, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsTotalRecords();

    /**
     * The number of successful PutRecord operations per Kinesis stream, measured over the specified time period.
     * <p>
     * Average
     * reflects the percentage of successful writes to a stream.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordSuccess(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of successful PutRecord operations per Kinesis stream, measured over the specified time period.
     * <p>
     * Average
     * reflects the percentage of successful writes to a stream.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordSuccess();

    /**
     * The number of GetRecords calls throttled for the stream over the specified time period.
     * <p>
     * The most commonly used
     * statistic for this metric is Average.
     * <p>
     * When the Minimum statistic has a value of 1, all records were throttled for the stream during the specified time
     * period.
     * <p>
     * When the Maximum statistic has a value of 0 (zero), no records were throttled for the stream during the specified
     * time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricReadProvisionedThroughputExceeded(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of GetRecords calls throttled for the stream over the specified time period.
     * <p>
     * The most commonly used
     * statistic for this metric is Average.
     * <p>
     * When the Minimum statistic has a value of 1, all records were throttled for the stream during the specified time
     * period.
     * <p>
     * When the Maximum statistic has a value of 0 (zero), no records were throttled for the stream during the specified
     * time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricReadProvisionedThroughputExceeded();

    /**
     * The number of records rejected due to throttling for the stream over the specified time period.
     * <p>
     * This metric
     * includes throttling from PutRecord and PutRecords operations.
     * <p>
     * When the Minimum statistic has a non-zero value, records were being throttled for the stream during the specified
     * time period.
     * <p>
     * When the Maximum statistic has a value of 0 (zero), no records were being throttled for the stream during the
     * specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricWriteProvisionedThroughputExceeded(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * The number of records rejected due to throttling for the stream over the specified time period.
     * <p>
     * This metric
     * includes throttling from PutRecord and PutRecords operations.
     * <p>
     * When the Minimum statistic has a non-zero value, records were being throttled for the stream during the specified
     * time period.
     * <p>
     * When the Maximum statistic has a value of 0 (zero), no records were being throttled for the stream during the
     * specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricWriteProvisionedThroughputExceeded();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesis.IStream.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ConstructNode.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Stack.class));
        }

        /**
         * The ARN of the stream.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getStreamArn() {
            return software.amazon.jsii.Kernel.get(this, "streamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The name of the stream.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getStreamName() {
            return software.amazon.jsii.Kernel.get(this, "streamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Optional KMS encryption key associated with this stream.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
        }

        /**
         * Grant the indicated permissions on this stream to the provided IAM principal.
         * <p>
         * @param grantee This parameter is required.
         * @param actions This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
            return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
        }

        /**
         * Grant read permissions for this stream and its contents to an IAM principal (Role/Group/User).
         * <p>
         * If an encryption key is used, permission to ues the key to decrypt the
         * contents of the stream will also be granted.
         * <p>
         * @param grantee This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Grants read/write permissions for this stream and its contents to an IAM principal (Role/Group/User).
         * <p>
         * If an encryption key is used, permission to use the key for
         * encrypt/decrypt will also be granted.
         * <p>
         * @param grantee This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantReadWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Grant write permissions for this stream and its contents to an IAM principal (Role/Group/User).
         * <p>
         * If an encryption key is used, permission to ues the key to encrypt the
         * contents of the stream will also be granted.
         * <p>
         * @param grantee This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Return stream metric based from its metric name.
         * <p>
         * @param metricName name of the stream metric. This parameter is required.
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
        }

        /**
         * Return stream metric based from its metric name.
         * <p>
         * @param metricName name of the stream metric. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
            return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
        }

        /**
         * The number of records retrieved from the shard, measured over the specified time period.
         * <p>
         * Minimum, Maximum, and
         * Average statistics represent the records in a single GetRecords operation for the stream in the specified time
         * period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecords(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricGetRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of records retrieved from the shard, measured over the specified time period.
         * <p>
         * Minimum, Maximum, and
         * Average statistics represent the records in a single GetRecords operation for the stream in the specified time
         * period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecords() {
            return software.amazon.jsii.Kernel.call(this, "metricGetRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The number of bytes retrieved from the Kinesis stream, measured over the specified time period.
         * <p>
         * Minimum, Maximum,
         * and Average statistics represent the bytes in a single GetRecords operation for the stream in the specified time
         * period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecordsBytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricGetRecordsBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of bytes retrieved from the Kinesis stream, measured over the specified time period.
         * <p>
         * Minimum, Maximum,
         * and Average statistics represent the bytes in a single GetRecords operation for the stream in the specified time
         * period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecordsBytes() {
            return software.amazon.jsii.Kernel.call(this, "metricGetRecordsBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The age of the last record in all GetRecords calls made against a Kinesis stream, measured over the specified time period.
         * <p>
         * Age is the difference between the current time and when the last record of the GetRecords call was written
         * to the stream. The Minimum and Maximum statistics can be used to track the progress of Kinesis consumer
         * applications. A value of zero indicates that the records being read are completely caught up with the stream.
         * <p>
         * The metric defaults to maximum over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecordsIteratorAgeMilliseconds(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricGetRecordsIteratorAgeMilliseconds", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The age of the last record in all GetRecords calls made against a Kinesis stream, measured over the specified time period.
         * <p>
         * Age is the difference between the current time and when the last record of the GetRecords call was written
         * to the stream. The Minimum and Maximum statistics can be used to track the progress of Kinesis consumer
         * applications. A value of zero indicates that the records being read are completely caught up with the stream.
         * <p>
         * The metric defaults to maximum over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecordsIteratorAgeMilliseconds() {
            return software.amazon.jsii.Kernel.call(this, "metricGetRecordsIteratorAgeMilliseconds", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The time taken per GetRecords operation, measured over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecordsLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricGetRecordsLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The time taken per GetRecords operation, measured over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecordsLatency() {
            return software.amazon.jsii.Kernel.call(this, "metricGetRecordsLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The number of successful GetRecords operations per stream, measured over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecordsSuccess(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricGetRecordsSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of successful GetRecords operations per stream, measured over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecordsSuccess() {
            return software.amazon.jsii.Kernel.call(this, "metricGetRecordsSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The number of bytes successfully put to the Kinesis stream over the specified time period.
         * <p>
         * This metric includes
         * bytes from PutRecord and PutRecords operations. Minimum, Maximum, and Average statistics represent the bytes in a
         * single put operation for the stream in the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIncomingBytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricIncomingBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of bytes successfully put to the Kinesis stream over the specified time period.
         * <p>
         * This metric includes
         * bytes from PutRecord and PutRecords operations. Minimum, Maximum, and Average statistics represent the bytes in a
         * single put operation for the stream in the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIncomingBytes() {
            return software.amazon.jsii.Kernel.call(this, "metricIncomingBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The number of records successfully put to the Kinesis stream over the specified time period.
         * <p>
         * This metric includes
         * record counts from PutRecord and PutRecords operations. Minimum, Maximum, and Average statistics represent the
         * records in a single put operation for the stream in the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIncomingRecords(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricIncomingRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of records successfully put to the Kinesis stream over the specified time period.
         * <p>
         * This metric includes
         * record counts from PutRecord and PutRecords operations. Minimum, Maximum, and Average statistics represent the
         * records in a single put operation for the stream in the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIncomingRecords() {
            return software.amazon.jsii.Kernel.call(this, "metricIncomingRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The number of bytes put to the Kinesis stream using the PutRecord operation over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordBytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of bytes put to the Kinesis stream using the PutRecord operation over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordBytes() {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The time taken per PutRecord operation, measured over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The time taken per PutRecord operation, measured over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordLatency() {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The number of bytes put to the Kinesis stream using the PutRecords operation over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsBytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordsBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of bytes put to the Kinesis stream using the PutRecords operation over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsBytes() {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordsBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The number of records rejected due to internal failures in a PutRecords operation per Kinesis data stream, measured over the specified time period.
         * <p>
         * Occasional internal failures are to be expected and should be retried.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsFailedRecords(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordsFailedRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of records rejected due to internal failures in a PutRecords operation per Kinesis data stream, measured over the specified time period.
         * <p>
         * Occasional internal failures are to be expected and should be retried.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsFailedRecords() {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordsFailedRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The time taken per PutRecords operation, measured over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordsLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The time taken per PutRecords operation, measured over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsLatency() {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordsLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The number of PutRecords operations where at least one record succeeded, per Kinesis stream, measured over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsSuccess(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordsSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of PutRecords operations where at least one record succeeded, per Kinesis stream, measured over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsSuccess() {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordsSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The number of successful records in a PutRecords operation per Kinesis data stream, measured over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsSuccessfulRecords(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordsSuccessfulRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of successful records in a PutRecords operation per Kinesis data stream, measured over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsSuccessfulRecords() {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordsSuccessfulRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The number of records rejected due to throttling in a PutRecords operation per Kinesis data stream, measured over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsThrottledRecords(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordsThrottledRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of records rejected due to throttling in a PutRecords operation per Kinesis data stream, measured over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsThrottledRecords() {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordsThrottledRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The total number of records sent in a PutRecords operation per Kinesis data stream, measured over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsTotalRecords(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordsTotalRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The total number of records sent in a PutRecords operation per Kinesis data stream, measured over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsTotalRecords() {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordsTotalRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The number of successful PutRecord operations per Kinesis stream, measured over the specified time period.
         * <p>
         * Average
         * reflects the percentage of successful writes to a stream.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordSuccess(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of successful PutRecord operations per Kinesis stream, measured over the specified time period.
         * <p>
         * Average
         * reflects the percentage of successful writes to a stream.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordSuccess() {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The number of GetRecords calls throttled for the stream over the specified time period.
         * <p>
         * The most commonly used
         * statistic for this metric is Average.
         * <p>
         * When the Minimum statistic has a value of 1, all records were throttled for the stream during the specified time
         * period.
         * <p>
         * When the Maximum statistic has a value of 0 (zero), no records were throttled for the stream during the specified
         * time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricReadProvisionedThroughputExceeded(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricReadProvisionedThroughputExceeded", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of GetRecords calls throttled for the stream over the specified time period.
         * <p>
         * The most commonly used
         * statistic for this metric is Average.
         * <p>
         * When the Minimum statistic has a value of 1, all records were throttled for the stream during the specified time
         * period.
         * <p>
         * When the Maximum statistic has a value of 0 (zero), no records were throttled for the stream during the specified
         * time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricReadProvisionedThroughputExceeded() {
            return software.amazon.jsii.Kernel.call(this, "metricReadProvisionedThroughputExceeded", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * The number of records rejected due to throttling for the stream over the specified time period.
         * <p>
         * This metric
         * includes throttling from PutRecord and PutRecords operations.
         * <p>
         * When the Minimum statistic has a non-zero value, records were being throttled for the stream during the specified
         * time period.
         * <p>
         * When the Maximum statistic has a value of 0 (zero), no records were being throttled for the stream during the
         * specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricWriteProvisionedThroughputExceeded(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricWriteProvisionedThroughputExceeded", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of records rejected due to throttling for the stream over the specified time period.
         * <p>
         * This metric
         * includes throttling from PutRecord and PutRecords operations.
         * <p>
         * When the Minimum statistic has a non-zero value, records were being throttled for the stream during the specified
         * time period.
         * <p>
         * When the Maximum statistic has a value of 0 (zero), no records were being throttled for the stream during the
         * specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricWriteProvisionedThroughputExceeded() {
            return software.amazon.jsii.Kernel.call(this, "metricWriteProvisionedThroughputExceeded", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }
    }

    /**
     * Internal default implementation for {@link IStream}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IStream, software.amazon.awscdk.core.IResource.Jsii$Default {

        /**
         * The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ConstructNode.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Stack.class));
        }

        /**
         * The ARN of the stream.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getStreamArn() {
            return software.amazon.jsii.Kernel.get(this, "streamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The name of the stream.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getStreamName() {
            return software.amazon.jsii.Kernel.get(this, "streamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Optional KMS encryption key associated with this stream.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
        }

        /**
         * Grant the indicated permissions on this stream to the provided IAM principal.
         * <p>
         * @param grantee This parameter is required.
         * @param actions This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
            return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
        }

        /**
         * Grant read permissions for this stream and its contents to an IAM principal (Role/Group/User).
         * <p>
         * If an encryption key is used, permission to ues the key to decrypt the
         * contents of the stream will also be granted.
         * <p>
         * @param grantee This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Grants read/write permissions for this stream and its contents to an IAM principal (Role/Group/User).
         * <p>
         * If an encryption key is used, permission to use the key for
         * encrypt/decrypt will also be granted.
         * <p>
         * @param grantee This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantReadWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Grant write permissions for this stream and its contents to an IAM principal (Role/Group/User).
         * <p>
         * If an encryption key is used, permission to ues the key to encrypt the
         * contents of the stream will also be granted.
         * <p>
         * @param grantee This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Return stream metric based from its metric name.
         * <p>
         * @param metricName name of the stream metric. This parameter is required.
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
        }

        /**
         * The number of records retrieved from the shard, measured over the specified time period.
         * <p>
         * Minimum, Maximum, and
         * Average statistics represent the records in a single GetRecords operation for the stream in the specified time
         * period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecords(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricGetRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of bytes retrieved from the Kinesis stream, measured over the specified time period.
         * <p>
         * Minimum, Maximum,
         * and Average statistics represent the bytes in a single GetRecords operation for the stream in the specified time
         * period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecordsBytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricGetRecordsBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The age of the last record in all GetRecords calls made against a Kinesis stream, measured over the specified time period.
         * <p>
         * Age is the difference between the current time and when the last record of the GetRecords call was written
         * to the stream. The Minimum and Maximum statistics can be used to track the progress of Kinesis consumer
         * applications. A value of zero indicates that the records being read are completely caught up with the stream.
         * <p>
         * The metric defaults to maximum over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecordsIteratorAgeMilliseconds(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricGetRecordsIteratorAgeMilliseconds", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The time taken per GetRecords operation, measured over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecordsLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricGetRecordsLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of successful GetRecords operations per stream, measured over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecordsSuccess(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricGetRecordsSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of bytes successfully put to the Kinesis stream over the specified time period.
         * <p>
         * This metric includes
         * bytes from PutRecord and PutRecords operations. Minimum, Maximum, and Average statistics represent the bytes in a
         * single put operation for the stream in the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIncomingBytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricIncomingBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of records successfully put to the Kinesis stream over the specified time period.
         * <p>
         * This metric includes
         * record counts from PutRecord and PutRecords operations. Minimum, Maximum, and Average statistics represent the
         * records in a single put operation for the stream in the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIncomingRecords(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricIncomingRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of bytes put to the Kinesis stream using the PutRecord operation over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordBytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The time taken per PutRecord operation, measured over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of bytes put to the Kinesis stream using the PutRecords operation over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsBytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordsBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of records rejected due to internal failures in a PutRecords operation per Kinesis data stream, measured over the specified time period.
         * <p>
         * Occasional internal failures are to be expected and should be retried.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsFailedRecords(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordsFailedRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The time taken per PutRecords operation, measured over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordsLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of PutRecords operations where at least one record succeeded, per Kinesis stream, measured over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsSuccess(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordsSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of successful records in a PutRecords operation per Kinesis data stream, measured over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsSuccessfulRecords(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordsSuccessfulRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of records rejected due to throttling in a PutRecords operation per Kinesis data stream, measured over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsThrottledRecords(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordsThrottledRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The total number of records sent in a PutRecords operation per Kinesis data stream, measured over the specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsTotalRecords(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordsTotalRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of successful PutRecord operations per Kinesis stream, measured over the specified time period.
         * <p>
         * Average
         * reflects the percentage of successful writes to a stream.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordSuccess(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricPutRecordSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of GetRecords calls throttled for the stream over the specified time period.
         * <p>
         * The most commonly used
         * statistic for this metric is Average.
         * <p>
         * When the Minimum statistic has a value of 1, all records were throttled for the stream during the specified time
         * period.
         * <p>
         * When the Maximum statistic has a value of 0 (zero), no records were throttled for the stream during the specified
         * time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricReadProvisionedThroughputExceeded(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricReadProvisionedThroughputExceeded", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * The number of records rejected due to throttling for the stream over the specified time period.
         * <p>
         * This metric
         * includes throttling from PutRecord and PutRecords operations.
         * <p>
         * When the Minimum statistic has a non-zero value, records were being throttled for the stream during the specified
         * time period.
         * <p>
         * When the Maximum statistic has a value of 0 (zero), no records were being throttled for the stream during the
         * specified time period.
         * <p>
         * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
         * <p>
         * @param props properties of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricWriteProvisionedThroughputExceeded(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricWriteProvisionedThroughputExceeded", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }
    }
}
