package software.amazon.awscdk.services.kinesis;

/**
 * A reference to a stream.
 * 
 * The easiest way to instantiate is to call
 * `stream.export()`. Then, the consumer can use `Stream.import(this, ref)` and
 * get a `Stream`.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-15T19:55:42.150Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface StreamAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the stream.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getStreamArn();

    /**
     * The KMS key securing the contents of the stream if encryption is enabled.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.kms.IKey getEncryptionKey();

    /**
     * @return a {@link Builder} of {@link StreamAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StreamAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private java.lang.String streamArn;
        private software.amazon.awscdk.services.kms.IKey encryptionKey;

        /**
         * Sets the value of StreamArn
         * @param streamArn The ARN of the stream. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder streamArn(java.lang.String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        /**
         * Sets the value of EncryptionKey
         * @param encryptionKey The KMS key securing the contents of the stream if encryption is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StreamAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public StreamAttributes build() {
            return new Jsii$Proxy(streamArn, encryptionKey);
        }
    }

    /**
     * An implementation for {@link StreamAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StreamAttributes {
        private final java.lang.String streamArn;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.streamArn = this.jsiiGet("streamArn", java.lang.String.class);
            this.encryptionKey = this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.IKey.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String streamArn, software.amazon.awscdk.services.kms.IKey encryptionKey) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.streamArn = java.util.Objects.requireNonNull(streamArn, "streamArn is required");
            this.encryptionKey = encryptionKey;
        }

        @Override
        public java.lang.String getStreamArn() {
            return this.streamArn;
        }

        @Override
        public software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("streamArn", om.valueToTree(this.getStreamArn()));
            if (this.getEncryptionKey() != null) {
                obj.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StreamAttributes.Jsii$Proxy that = (StreamAttributes.Jsii$Proxy) o;

            if (!streamArn.equals(that.streamArn)) return false;
            return this.encryptionKey != null ? this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey == null;
        }

        @Override
        public int hashCode() {
            int result = this.streamArn.hashCode();
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            return result;
        }
    }
}
