package software.amazon.awscdk.services.kinesis;

/**
 * Properties for defining a `CfnStreamConsumer`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kinesis.*;
 * CfnStreamConsumerProps cfnStreamConsumerProps = CfnStreamConsumerProps.builder()
 *         .consumerName("consumerName")
 *         .streamArn("streamArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.58.0 (build f8ba112)", date = "2022-05-11T19:24:14.210Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesis.$Module.class, fqn = "@aws-cdk/aws-kinesis.CfnStreamConsumerProps")
@software.amazon.jsii.Jsii.Proxy(CfnStreamConsumerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStreamConsumerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the consumer is something you choose when you register the consumer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConsumerName();

    /**
     * The ARN of the stream with which you registered the consumer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStreamArn();

    /**
     * @return a {@link Builder} of {@link CfnStreamConsumerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStreamConsumerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStreamConsumerProps> {
        java.lang.String consumerName;
        java.lang.String streamArn;

        /**
         * Sets the value of {@link CfnStreamConsumerProps#getConsumerName}
         * @param consumerName The name of the consumer is something you choose when you register the consumer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder consumerName(java.lang.String consumerName) {
            this.consumerName = consumerName;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamConsumerProps#getStreamArn}
         * @param streamArn The ARN of the stream with which you registered the consumer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamArn(java.lang.String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStreamConsumerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStreamConsumerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStreamConsumerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStreamConsumerProps {
        private final java.lang.String consumerName;
        private final java.lang.String streamArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.consumerName = software.amazon.jsii.Kernel.get(this, "consumerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.streamArn = software.amazon.jsii.Kernel.get(this, "streamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.consumerName = java.util.Objects.requireNonNull(builder.consumerName, "consumerName is required");
            this.streamArn = java.util.Objects.requireNonNull(builder.streamArn, "streamArn is required");
        }

        @Override
        public final java.lang.String getConsumerName() {
            return this.consumerName;
        }

        @Override
        public final java.lang.String getStreamArn() {
            return this.streamArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("consumerName", om.valueToTree(this.getConsumerName()));
            data.set("streamArn", om.valueToTree(this.getStreamArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-kinesis.CfnStreamConsumerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStreamConsumerProps.Jsii$Proxy that = (CfnStreamConsumerProps.Jsii$Proxy) o;

            if (!consumerName.equals(that.consumerName)) return false;
            return this.streamArn.equals(that.streamArn);
        }

        @Override
        public final int hashCode() {
            int result = this.consumerName.hashCode();
            result = 31 * result + (this.streamArn.hashCode());
            return result;
        }
    }
}
