package software.amazon.awscdk.services.kinesis;

/**
 * Properties for defining a `CfnStream`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kinesis.*;
 * CfnStreamProps cfnStreamProps = CfnStreamProps.builder()
 *         .name("name")
 *         .retentionPeriodHours(123)
 *         .shardCount(123)
 *         .streamEncryption(StreamEncryptionProperty.builder()
 *                 .encryptionType("encryptionType")
 *                 .keyId("keyId")
 *                 .build())
 *         .streamModeDetails(StreamModeDetailsProperty.builder()
 *                 .streamMode("streamMode")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.58.0 (build f8ba112)", date = "2022-05-27T16:28:00.184Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesis.$Module.class, fqn = "@aws-cdk/aws-kinesis.CfnStreamProps")
@software.amazon.jsii.Jsii.Proxy(CfnStreamProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStreamProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the Kinesis stream.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the stream name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     * <p>
     * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The number of hours for the data records that are stored in shards to remain accessible.
     * <p>
     * The default value is 24. For more information about the stream retention period, see <a href="https://docs.aws.amazon.com/streams/latest/dev/kinesis-extended-retention.html">Changing the Data Retention Period</a> in the Amazon Kinesis Developer Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRetentionPeriodHours() {
        return null;
    }

    /**
     * The number of shards that the stream uses.
     * <p>
     * For greater provisioned throughput, increase the number of shards.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getShardCount() {
        return null;
    }

    /**
     * When specified, enables or updates server-side encryption using an AWS KMS key for a specified stream.
     * <p>
     * Removing this property from your stack template and updating your stack disables encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStreamEncryption() {
        return null;
    }

    /**
     * Specifies the capacity mode to which you want to set your data stream.
     * <p>
     * Currently, in Kinesis Data Streams, you can choose between an <em>on-demand</em> capacity mode and a <em>provisioned</em> capacity mode for your data streams.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStreamModeDetails() {
        return null;
    }

    /**
     * An arbitrary set of tags (key–value pairs) to associate with the Kinesis stream.
     * <p>
     * For information about constraints for this property, see <a href="https://docs.aws.amazon.com/streams/latest/dev/tagging.html#tagging-restrictions">Tag Restrictions</a> in the <em>Amazon Kinesis Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnStreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStreamProps> {
        java.lang.String name;
        java.lang.Number retentionPeriodHours;
        java.lang.Number shardCount;
        java.lang.Object streamEncryption;
        java.lang.Object streamModeDetails;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnStreamProps#getName}
         * @param name The name of the Kinesis stream.
         *             If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the stream name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
         *             <p>
         *             If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProps#getRetentionPeriodHours}
         * @param retentionPeriodHours The number of hours for the data records that are stored in shards to remain accessible.
         *                             The default value is 24. For more information about the stream retention period, see <a href="https://docs.aws.amazon.com/streams/latest/dev/kinesis-extended-retention.html">Changing the Data Retention Period</a> in the Amazon Kinesis Developer Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionPeriodHours(java.lang.Number retentionPeriodHours) {
            this.retentionPeriodHours = retentionPeriodHours;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProps#getShardCount}
         * @param shardCount The number of shards that the stream uses.
         *                   For greater provisioned throughput, increase the number of shards.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shardCount(java.lang.Number shardCount) {
            this.shardCount = shardCount;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProps#getStreamEncryption}
         * @param streamEncryption When specified, enables or updates server-side encryption using an AWS KMS key for a specified stream.
         *                         Removing this property from your stack template and updating your stack disables encryption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamEncryption(software.amazon.awscdk.services.kinesis.CfnStream.StreamEncryptionProperty streamEncryption) {
            this.streamEncryption = streamEncryption;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProps#getStreamEncryption}
         * @param streamEncryption When specified, enables or updates server-side encryption using an AWS KMS key for a specified stream.
         *                         Removing this property from your stack template and updating your stack disables encryption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamEncryption(software.amazon.awscdk.core.IResolvable streamEncryption) {
            this.streamEncryption = streamEncryption;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProps#getStreamModeDetails}
         * @param streamModeDetails Specifies the capacity mode to which you want to set your data stream.
         *                          Currently, in Kinesis Data Streams, you can choose between an <em>on-demand</em> capacity mode and a <em>provisioned</em> capacity mode for your data streams.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamModeDetails(software.amazon.awscdk.core.IResolvable streamModeDetails) {
            this.streamModeDetails = streamModeDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProps#getStreamModeDetails}
         * @param streamModeDetails Specifies the capacity mode to which you want to set your data stream.
         *                          Currently, in Kinesis Data Streams, you can choose between an <em>on-demand</em> capacity mode and a <em>provisioned</em> capacity mode for your data streams.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamModeDetails(software.amazon.awscdk.services.kinesis.CfnStream.StreamModeDetailsProperty streamModeDetails) {
            this.streamModeDetails = streamModeDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnStreamProps#getTags}
         * @param tags An arbitrary set of tags (key–value pairs) to associate with the Kinesis stream.
         *             For information about constraints for this property, see <a href="https://docs.aws.amazon.com/streams/latest/dev/tagging.html#tagging-restrictions">Tag Restrictions</a> in the <em>Amazon Kinesis Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStreamProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStreamProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStreamProps {
        private final java.lang.String name;
        private final java.lang.Number retentionPeriodHours;
        private final java.lang.Number shardCount;
        private final java.lang.Object streamEncryption;
        private final java.lang.Object streamModeDetails;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.retentionPeriodHours = software.amazon.jsii.Kernel.get(this, "retentionPeriodHours", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.shardCount = software.amazon.jsii.Kernel.get(this, "shardCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.streamEncryption = software.amazon.jsii.Kernel.get(this, "streamEncryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.streamModeDetails = software.amazon.jsii.Kernel.get(this, "streamModeDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = builder.name;
            this.retentionPeriodHours = builder.retentionPeriodHours;
            this.shardCount = builder.shardCount;
            this.streamEncryption = builder.streamEncryption;
            this.streamModeDetails = builder.streamModeDetails;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Number getRetentionPeriodHours() {
            return this.retentionPeriodHours;
        }

        @Override
        public final java.lang.Number getShardCount() {
            return this.shardCount;
        }

        @Override
        public final java.lang.Object getStreamEncryption() {
            return this.streamEncryption;
        }

        @Override
        public final java.lang.Object getStreamModeDetails() {
            return this.streamModeDetails;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getRetentionPeriodHours() != null) {
                data.set("retentionPeriodHours", om.valueToTree(this.getRetentionPeriodHours()));
            }
            if (this.getShardCount() != null) {
                data.set("shardCount", om.valueToTree(this.getShardCount()));
            }
            if (this.getStreamEncryption() != null) {
                data.set("streamEncryption", om.valueToTree(this.getStreamEncryption()));
            }
            if (this.getStreamModeDetails() != null) {
                data.set("streamModeDetails", om.valueToTree(this.getStreamModeDetails()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-kinesis.CfnStreamProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStreamProps.Jsii$Proxy that = (CfnStreamProps.Jsii$Proxy) o;

            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.retentionPeriodHours != null ? !this.retentionPeriodHours.equals(that.retentionPeriodHours) : that.retentionPeriodHours != null) return false;
            if (this.shardCount != null ? !this.shardCount.equals(that.shardCount) : that.shardCount != null) return false;
            if (this.streamEncryption != null ? !this.streamEncryption.equals(that.streamEncryption) : that.streamEncryption != null) return false;
            if (this.streamModeDetails != null ? !this.streamModeDetails.equals(that.streamModeDetails) : that.streamModeDetails != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.retentionPeriodHours != null ? this.retentionPeriodHours.hashCode() : 0);
            result = 31 * result + (this.shardCount != null ? this.shardCount.hashCode() : 0);
            result = 31 * result + (this.streamEncryption != null ? this.streamEncryption.hashCode() : 0);
            result = 31 * result + (this.streamModeDetails != null ? this.streamModeDetails.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
