/**
 * <h2>Amazon Kinesis Construct Library</h2>
 * <!-- raw HTML omitted -->
 * <hr />
 * <p><img src="https://img.shields.io/badge/stability-Experimental-important.svg?style=for-the-badge" alt="Stability: Experimental" /></p>
 * <blockquote>
 * <p><strong>This is a <em>developer preview</em> (public beta) module. Releases might lack important features and might have
 * future breaking changes.</strong></p>
 * <p>This API is still under active development and subject to non-backward
 * compatible changes or removal in any future version. Use of the API is not recommended in production
 * environments. Experimental APIs are not subject to the Semantic Versioning model.</p>
 * </blockquote>
 * <hr />
 * <!-- raw HTML omitted -->
 * <p>Define an unencrypted Kinesis stream.</p>
 * <pre><code class="language-ts">new Stream(this, 'MyFirstStream');
 * </code></pre>
 * <h3>Encryption</h3>
 * <p>Define a KMS-encrypted stream:</p>
 * <pre><code class="language-ts">const stream = new Stream(this, 'MyEncryptedStream', {
 *     encryption: StreamEncryption.Kms
 * });
 * 
 * // you can access the encryption key:
 * assert(stream.encryptionKey instanceof kms.Key);
 * </code></pre>
 * <p>You can also supply your own key:</p>
 * <pre><code class="language-ts">const myKmsKey = new kms.Key(this, 'MyKey');
 * 
 * const stream = new Stream(this, 'MyEncryptedStream', {
 *     encryption: StreamEncryption.Kms,
 *     encryptionKey: myKmsKey
 * });
 * 
 * assert(stream.encryptionKey === myKmsKey);
 * </code></pre>
 * 
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.kinesis;
