/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.kinesis;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.kinesis.;
import software.amazon.awscdk.services.kinesis.CfnStream;
import software.amazon.awscdk.services.kinesis.CfnStreamProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-kinesis.CfnStream")
public class CfnStream
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnStream.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnStream(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStream(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnStream(Construct scope, String id, CfnStreamProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(TreeInspector inspector) {
        this.jsiiCall("inspect", Void.class, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    protected Map<String, Object> renderProperties(Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", Map.class, new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    public String getAttrArn() {
        return (String)this.jsiiGet("attrArn", String.class);
    }

    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", Map.class));
    }

    public TagManager getTags() {
        return (TagManager)this.jsiiGet("tags", TagManager.class);
    }

    public Number getShardCount() {
        return (Number)this.jsiiGet("shardCount", Number.class);
    }

    public void setShardCount(Number value) {
        this.jsiiSet("shardCount", Objects.requireNonNull(value, "shardCount is required"));
    }

    public String getName() {
        return (String)this.jsiiGet("name", String.class);
    }

    public void setName(String value) {
        this.jsiiSet("name", value);
    }

    public Number getRetentionPeriodHours() {
        return (Number)this.jsiiGet("retentionPeriodHours", Number.class);
    }

    public void setRetentionPeriodHours(Number value) {
        this.jsiiSet("retentionPeriodHours", value);
    }

    public Object getStreamEncryption() {
        return this.jsiiGet("streamEncryption", Object.class);
    }

    public void setStreamEncryption(StreamEncryptionProperty value) {
        this.jsiiSet("streamEncryption", value);
    }

    public void setStreamEncryption(IResolvable value) {
        this.jsiiSet("streamEncryption", value);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final CfnStreamProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnStreamProps.Builder();
        }

        public Builder shardCount(Number shardCount) {
            this.props.shardCount(shardCount);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder retentionPeriodHours(Number retentionPeriodHours) {
            this.props.retentionPeriodHours(retentionPeriodHours);
            return this;
        }

        public Builder streamEncryption(StreamEncryptionProperty streamEncryption) {
            this.props.streamEncryption(streamEncryption);
            return this;
        }

        public Builder streamEncryption(IResolvable streamEncryption) {
            this.props.streamEncryption(streamEncryption);
            return this;
        }

        public Builder tags(List<CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnStream build() {
            return new CfnStream(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-kinesis.CfnStream.StreamEncryptionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StreamEncryptionProperty
    extends JsiiSerializable {
        public String getEncryptionType();

        public String getKeyId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String encryptionType;
            private String keyId;

            public Builder encryptionType(String encryptionType) {
                this.encryptionType = encryptionType;
                return this;
            }

            public Builder keyId(String keyId) {
                this.keyId = keyId;
                return this;
            }

            public StreamEncryptionProperty build() {
                return new Jsii.Proxy(this.encryptionType, this.keyId, null);
            }
        }
    }
}

