package software.amazon.awscdk.services.kinesis;

/**
 * A Kinesis stream.
 * <p>
 * Can be encrypted with a KMS key.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Key key = new Key(this, "MyKey");
 * Stream.Builder.create(this, "MyEncryptedStream")
 *         .encryption(StreamEncryption.KMS)
 *         .encryptionKey(key)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-04-20T17:18:06.684Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesis.$Module.class, fqn = "@aws-cdk/aws-kinesis.Stream")
public class Stream extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.kinesis.IStream {

    protected Stream(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Stream(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Stream(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesis.StreamProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Stream(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import an existing Kinesis Stream provided an ARN.
     * <p>
     * @param scope The parent creating construct (usually `this`). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param streamArn Stream ARN (i.e. arn:aws:kinesis:<region>:<account-id>:stream/Foo). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.IStream fromStreamArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String streamArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kinesis.Stream.class, "fromStreamArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.IStream.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(streamArn, "streamArn is required") });
    }

    /**
     * Creates a Stream construct that represents an external stream.
     * <p>
     * @param scope The parent creating construct (usually `this`). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param attrs Stream import properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.IStream fromStreamAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.StreamAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kinesis.Stream.class, "fromStreamAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.IStream.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Grant the indicated permissions on this stream to the given IAM principal (Role/Group/User).
     * <p>
     * @param grantee This parameter is required.
     * @param actions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * Grant read permissions for this stream and its contents to an IAM principal (Role/Group/User).
     * <p>
     * If an encryption key is used, permission to ues the key to decrypt the
     * contents of the stream will also be granted.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grants read/write permissions for this stream and its contents to an IAM principal (Role/Group/User).
     * <p>
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantReadWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grant write permissions for this stream and its contents to an IAM principal (Role/Group/User).
     * <p>
     * If an encryption key is used, permission to ues the key to encrypt the
     * contents of the stream will also be granted.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Return stream metric based from its metric name.
     * <p>
     * @param metricName name of the stream metric. This parameter is required.
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * Return stream metric based from its metric name.
     * <p>
     * @param metricName name of the stream metric. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * The number of records retrieved from the shard, measured over the specified time period.
     * <p>
     * Minimum, Maximum, and
     * Average statistics represent the records in a single GetRecords operation for the stream in the specified time
     * period.
     * <p>
     * average
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecords(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricGetRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of records retrieved from the shard, measured over the specified time period.
     * <p>
     * Minimum, Maximum, and
     * Average statistics represent the records in a single GetRecords operation for the stream in the specified time
     * period.
     * <p>
     * average
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecords() {
        return software.amazon.jsii.Kernel.call(this, "metricGetRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The number of bytes retrieved from the Kinesis stream, measured over the specified time period.
     * <p>
     * Minimum, Maximum,
     * and Average statistics represent the bytes in a single GetRecords operation for the stream in the specified time
     * period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecordsBytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricGetRecordsBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of bytes retrieved from the Kinesis stream, measured over the specified time period.
     * <p>
     * Minimum, Maximum,
     * and Average statistics represent the bytes in a single GetRecords operation for the stream in the specified time
     * period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecordsBytes() {
        return software.amazon.jsii.Kernel.call(this, "metricGetRecordsBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The age of the last record in all GetRecords calls made against a Kinesis stream, measured over the specified time period.
     * <p>
     * Age is the difference between the current time and when the last record of the GetRecords call was written
     * to the stream. The Minimum and Maximum statistics can be used to track the progress of Kinesis consumer
     * applications. A value of zero indicates that the records being read are completely caught up with the stream.
     * <p>
     * The metric defaults to maximum over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecordsIteratorAgeMilliseconds(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricGetRecordsIteratorAgeMilliseconds", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The age of the last record in all GetRecords calls made against a Kinesis stream, measured over the specified time period.
     * <p>
     * Age is the difference between the current time and when the last record of the GetRecords call was written
     * to the stream. The Minimum and Maximum statistics can be used to track the progress of Kinesis consumer
     * applications. A value of zero indicates that the records being read are completely caught up with the stream.
     * <p>
     * The metric defaults to maximum over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecordsIteratorAgeMilliseconds() {
        return software.amazon.jsii.Kernel.call(this, "metricGetRecordsIteratorAgeMilliseconds", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The number of successful GetRecords operations per stream, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecordsLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricGetRecordsLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of successful GetRecords operations per stream, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecordsLatency() {
        return software.amazon.jsii.Kernel.call(this, "metricGetRecordsLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The number of successful GetRecords operations per stream, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecordsSuccess(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricGetRecordsSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of successful GetRecords operations per stream, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricGetRecordsSuccess() {
        return software.amazon.jsii.Kernel.call(this, "metricGetRecordsSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The number of bytes successfully put to the Kinesis stream over the specified time period.
     * <p>
     * This metric includes
     * bytes from PutRecord and PutRecords operations. Minimum, Maximum, and Average statistics represent the bytes in a
     * single put operation for the stream in the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIncomingBytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricIncomingBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of bytes successfully put to the Kinesis stream over the specified time period.
     * <p>
     * This metric includes
     * bytes from PutRecord and PutRecords operations. Minimum, Maximum, and Average statistics represent the bytes in a
     * single put operation for the stream in the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIncomingBytes() {
        return software.amazon.jsii.Kernel.call(this, "metricIncomingBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The number of records successfully put to the Kinesis stream over the specified time period.
     * <p>
     * This metric includes
     * record counts from PutRecord and PutRecords operations. Minimum, Maximum, and Average statistics represent the
     * records in a single put operation for the stream in the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIncomingRecords(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricIncomingRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of records successfully put to the Kinesis stream over the specified time period.
     * <p>
     * This metric includes
     * record counts from PutRecord and PutRecords operations. Minimum, Maximum, and Average statistics represent the
     * records in a single put operation for the stream in the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIncomingRecords() {
        return software.amazon.jsii.Kernel.call(this, "metricIncomingRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The number of bytes put to the Kinesis stream using the PutRecord operation over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordBytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricPutRecordBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of bytes put to the Kinesis stream using the PutRecord operation over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordBytes() {
        return software.amazon.jsii.Kernel.call(this, "metricPutRecordBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The time taken per PutRecord operation, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricPutRecordLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The time taken per PutRecord operation, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordLatency() {
        return software.amazon.jsii.Kernel.call(this, "metricPutRecordLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The number of bytes put to the Kinesis stream using the PutRecords operation over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsBytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricPutRecordsBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of bytes put to the Kinesis stream using the PutRecords operation over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsBytes() {
        return software.amazon.jsii.Kernel.call(this, "metricPutRecordsBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The number of records rejected due to internal failures in a PutRecords operation per Kinesis data stream, measured over the specified time period.
     * <p>
     * Occasional internal failures are to be expected and should be retried.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsFailedRecords(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricPutRecordsFailedRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of records rejected due to internal failures in a PutRecords operation per Kinesis data stream, measured over the specified time period.
     * <p>
     * Occasional internal failures are to be expected and should be retried.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsFailedRecords() {
        return software.amazon.jsii.Kernel.call(this, "metricPutRecordsFailedRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The time taken per PutRecords operation, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricPutRecordsLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The time taken per PutRecords operation, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsLatency() {
        return software.amazon.jsii.Kernel.call(this, "metricPutRecordsLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The number of PutRecords operations where at least one record succeeded, per Kinesis stream, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsSuccess(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricPutRecordsSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of PutRecords operations where at least one record succeeded, per Kinesis stream, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsSuccess() {
        return software.amazon.jsii.Kernel.call(this, "metricPutRecordsSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The number of successful records in a PutRecords operation per Kinesis data stream, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsSuccessfulRecords(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricPutRecordsSuccessfulRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of successful records in a PutRecords operation per Kinesis data stream, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsSuccessfulRecords() {
        return software.amazon.jsii.Kernel.call(this, "metricPutRecordsSuccessfulRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The number of records rejected due to throttling in a PutRecords operation per Kinesis data stream, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsThrottledRecords(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricPutRecordsThrottledRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of records rejected due to throttling in a PutRecords operation per Kinesis data stream, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsThrottledRecords() {
        return software.amazon.jsii.Kernel.call(this, "metricPutRecordsThrottledRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The total number of records sent in a PutRecords operation per Kinesis data stream, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsTotalRecords(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricPutRecordsTotalRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The total number of records sent in a PutRecords operation per Kinesis data stream, measured over the specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordsTotalRecords() {
        return software.amazon.jsii.Kernel.call(this, "metricPutRecordsTotalRecords", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The number of successful PutRecord operations per Kinesis stream, measured over the specified time period.
     * <p>
     * Average
     * reflects the percentage of successful writes to a stream.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordSuccess(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricPutRecordSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of successful PutRecord operations per Kinesis stream, measured over the specified time period.
     * <p>
     * Average
     * reflects the percentage of successful writes to a stream.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricPutRecordSuccess() {
        return software.amazon.jsii.Kernel.call(this, "metricPutRecordSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The number of GetRecords calls throttled for the stream over the specified time period.
     * <p>
     * The most commonly used
     * statistic for this metric is Average.
     * <p>
     * When the Minimum statistic has a value of 1, all records were throttled for the stream during the specified time
     * period.
     * <p>
     * When the Maximum statistic has a value of 0 (zero), no records were throttled for the stream during the specified
     * time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricReadProvisionedThroughputExceeded(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricReadProvisionedThroughputExceeded", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of GetRecords calls throttled for the stream over the specified time period.
     * <p>
     * The most commonly used
     * statistic for this metric is Average.
     * <p>
     * When the Minimum statistic has a value of 1, all records were throttled for the stream during the specified time
     * period.
     * <p>
     * When the Maximum statistic has a value of 0 (zero), no records were throttled for the stream during the specified
     * time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricReadProvisionedThroughputExceeded() {
        return software.amazon.jsii.Kernel.call(this, "metricReadProvisionedThroughputExceeded", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The number of records rejected due to throttling for the stream over the specified time period.
     * <p>
     * This metric
     * includes throttling from PutRecord and PutRecords operations.
     * <p>
     * When the Minimum statistic has a non-zero value, records were being throttled for the stream during the specified
     * time period.
     * <p>
     * When the Maximum statistic has a value of 0 (zero), no records were being throttled for the stream during the
     * specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     * <p>
     * @param props properties of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricWriteProvisionedThroughputExceeded(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricWriteProvisionedThroughputExceeded", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The number of records rejected due to throttling for the stream over the specified time period.
     * <p>
     * This metric
     * includes throttling from PutRecord and PutRecords operations.
     * <p>
     * When the Minimum statistic has a non-zero value, records were being throttled for the stream during the specified
     * time period.
     * <p>
     * When the Maximum statistic has a value of 0 (zero), no records were being throttled for the stream during the
     * specified time period.
     * <p>
     * The metric defaults to average over 5 minutes, it can be changed by passing <code>statistic</code> and <code>period</code> properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricWriteProvisionedThroughputExceeded() {
        return software.amazon.jsii.Kernel.call(this, "metricWriteProvisionedThroughputExceeded", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The ARN of the stream.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStreamArn() {
        return software.amazon.jsii.Kernel.get(this, "streamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the stream.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStreamName() {
        return software.amazon.jsii.Kernel.get(this, "streamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Optional KMS encryption key associated with this stream.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.kinesis.Stream}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.kinesis.Stream> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.kinesis.StreamProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The kind of server-side encryption to apply to this stream.
         * <p>
         * If you choose KMS, you can specify a KMS key via <code>encryptionKey</code>. If
         * encryption key is not specified, a key will automatically be created.
         * <p>
         * Default: - StreamEncryption.KMS if encrypted Streams are supported in the region
         * or StreamEncryption.UNENCRYPTED otherwise.
         * StreamEncryption.KMS if an encryption key is supplied through the encryptionKey property
         * <p>
         * @return {@code this}
         * @param encryption The kind of server-side encryption to apply to this stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(final software.amazon.awscdk.services.kinesis.StreamEncryption encryption) {
            this.props().encryption(encryption);
            return this;
        }

        /**
         * External KMS key to use for stream encryption.
         * <p>
         * The 'encryption' property must be set to "Kms".
         * <p>
         * Default: - Kinesis Data Streams master key ('/alias/aws/kinesis').
         * If encryption is set to StreamEncryption.KMS and this property is undefined, a new KMS key
         * will be created and associated with this stream.
         * <p>
         * @return {@code this}
         * @param encryptionKey External KMS key to use for stream encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(final software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.props().encryptionKey(encryptionKey);
            return this;
        }

        /**
         * The number of hours for the data records that are stored in shards to remain accessible.
         * <p>
         * Default: Duration.hours(24)
         * <p>
         * @return {@code this}
         * @param retentionPeriod The number of hours for the data records that are stored in shards to remain accessible. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionPeriod(final software.amazon.awscdk.core.Duration retentionPeriod) {
            this.props().retentionPeriod(retentionPeriod);
            return this;
        }

        /**
         * The number of shards for the stream.
         * <p>
         * Can only be provided if streamMode is Provisioned.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param shardCount The number of shards for the stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shardCount(final java.lang.Number shardCount) {
            this.props().shardCount(shardCount);
            return this;
        }

        /**
         * The capacity mode of this stream.
         * <p>
         * Default: StreamMode.PROVISIONED
         * <p>
         * @return {@code this}
         * @param streamMode The capacity mode of this stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamMode(final software.amazon.awscdk.services.kinesis.StreamMode streamMode) {
            this.props().streamMode(streamMode);
            return this;
        }

        /**
         * Enforces a particular physical stream name.
         * <p>
         * Default: <generated>
         * <p>
         * @return {@code this}
         * @param streamName Enforces a particular physical stream name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamName(final java.lang.String streamName) {
            this.props().streamName(streamName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.kinesis.Stream}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.kinesis.Stream build() {
            return new software.amazon.awscdk.services.kinesis.Stream(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.kinesis.StreamProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.kinesis.StreamProps.Builder();
            }
            return this.props;
        }
    }
}
