package software.amazon.awscdk.services.kinesis;

/**
 * A CloudFormation `AWS::Kinesis::Stream`.
 * <p>
 * Creates a Kinesis stream that captures and transports data records that are emitted from data sources. For information about creating streams, see <a href="https://docs.aws.amazon.com/kinesis/latest/APIReference/API_CreateStream.html">CreateStream</a> in the Amazon Kinesis API Reference.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kinesis.*;
 * CfnStream cfnStream = CfnStream.Builder.create(this, "MyCfnStream")
 *         .name("name")
 *         .retentionPeriodHours(123)
 *         .shardCount(123)
 *         .streamEncryption(StreamEncryptionProperty.builder()
 *                 .encryptionType("encryptionType")
 *                 .keyId("keyId")
 *                 .build())
 *         .streamModeDetails(StreamModeDetailsProperty.builder()
 *                 .streamMode("streamMode")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-05-19T23:09:26.531Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesis.$Module.class, fqn = "@aws-cdk/aws-kinesis.CfnStream")
public class CfnStream extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnStream(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStream(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesis.CfnStream.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Kinesis::Stream`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnStream(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesis.CfnStreamProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::Kinesis::Stream`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnStream(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon resource name (ARN) of the Kinesis stream, such as `arn:aws:kinesis:us-east-2:123456789012:stream/mystream` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An arbitrary set of tags (key–value pairs) to associate with the Kinesis stream.
     * <p>
     * For information about constraints for this property, see <a href="https://docs.aws.amazon.com/streams/latest/dev/tagging.html#tagging-restrictions">Tag Restrictions</a> in the <em>Amazon Kinesis Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The name of the Kinesis stream.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the stream name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     * <p>
     * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Kinesis stream.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the stream name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     * <p>
     * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The number of hours for the data records that are stored in shards to remain accessible.
     * <p>
     * The default value is 24. For more information about the stream retention period, see <a href="https://docs.aws.amazon.com/streams/latest/dev/kinesis-extended-retention.html">Changing the Data Retention Period</a> in the Amazon Kinesis Developer Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getRetentionPeriodHours() {
        return software.amazon.jsii.Kernel.get(this, "retentionPeriodHours", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of hours for the data records that are stored in shards to remain accessible.
     * <p>
     * The default value is 24. For more information about the stream retention period, see <a href="https://docs.aws.amazon.com/streams/latest/dev/kinesis-extended-retention.html">Changing the Data Retention Period</a> in the Amazon Kinesis Developer Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRetentionPeriodHours(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "retentionPeriodHours", value);
    }

    /**
     * The number of shards that the stream uses.
     * <p>
     * For greater provisioned throughput, increase the number of shards.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getShardCount() {
        return software.amazon.jsii.Kernel.get(this, "shardCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of shards that the stream uses.
     * <p>
     * For greater provisioned throughput, increase the number of shards.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setShardCount(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "shardCount", value);
    }

    /**
     * When specified, enables or updates server-side encryption using an AWS KMS key for a specified stream.
     * <p>
     * Removing this property from your stack template and updating your stack disables encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStreamEncryption() {
        return software.amazon.jsii.Kernel.get(this, "streamEncryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * When specified, enables or updates server-side encryption using an AWS KMS key for a specified stream.
     * <p>
     * Removing this property from your stack template and updating your stack disables encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStreamEncryption(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesis.CfnStream.StreamEncryptionProperty value) {
        software.amazon.jsii.Kernel.set(this, "streamEncryption", value);
    }

    /**
     * When specified, enables or updates server-side encryption using an AWS KMS key for a specified stream.
     * <p>
     * Removing this property from your stack template and updating your stack disables encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStreamEncryption(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "streamEncryption", value);
    }

    /**
     * Specifies the capacity mode to which you want to set your data stream.
     * <p>
     * Currently, in Kinesis Data Streams, you can choose between an <em>on-demand</em> capacity mode and a <em>provisioned</em> capacity mode for your data streams.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStreamModeDetails() {
        return software.amazon.jsii.Kernel.get(this, "streamModeDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the capacity mode to which you want to set your data stream.
     * <p>
     * Currently, in Kinesis Data Streams, you can choose between an <em>on-demand</em> capacity mode and a <em>provisioned</em> capacity mode for your data streams.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStreamModeDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "streamModeDetails", value);
    }

    /**
     * Specifies the capacity mode to which you want to set your data stream.
     * <p>
     * Currently, in Kinesis Data Streams, you can choose between an <em>on-demand</em> capacity mode and a <em>provisioned</em> capacity mode for your data streams.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStreamModeDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesis.CfnStream.StreamModeDetailsProperty value) {
        software.amazon.jsii.Kernel.set(this, "streamModeDetails", value);
    }
    /**
     * Enables or updates server-side encryption using an AWS KMS key for a specified stream.
     * <p>
     * <blockquote>
     * <p>
     * When invoking this API, you must use either the <code>StreamARN</code> or the <code>StreamName</code> parameter, or both. It is recommended that you use the <code>StreamARN</code> input parameter when you invoke this API.
     * <p>
     * </blockquote>
     * <p>
     * Starting encryption is an asynchronous operation. Upon receiving the request, Kinesis Data Streams returns immediately and sets the status of the stream to <code>UPDATING</code> . After the update is complete, Kinesis Data Streams sets the status of the stream back to <code>ACTIVE</code> . Updating or applying encryption normally takes a few seconds to complete, but it can take minutes. You can continue to read and write data to your stream while its status is <code>UPDATING</code> . Once the status of the stream is <code>ACTIVE</code> , encryption begins for records written to the stream.
     * <p>
     * API Limits: You can successfully apply a new AWS KMS key for server-side encryption 25 times in a rolling 24-hour period.
     * <p>
     * Note: It can take up to 5 seconds after the stream is in an <code>ACTIVE</code> status before all records written to the stream are encrypted. After you enable encryption, you can verify that encryption is applied by inspecting the API response from <code>PutRecord</code> or <code>PutRecords</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesis.*;
     * StreamEncryptionProperty streamEncryptionProperty = StreamEncryptionProperty.builder()
     *         .encryptionType("encryptionType")
     *         .keyId("keyId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesis.$Module.class, fqn = "@aws-cdk/aws-kinesis.CfnStream.StreamEncryptionProperty")
    @software.amazon.jsii.Jsii.Proxy(StreamEncryptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StreamEncryptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The encryption type to use.
         * <p>
         * The only valid value is <code>KMS</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEncryptionType();

        /**
         * The GUID for the customer-managed AWS KMS key to use for encryption.
         * <p>
         * This value can be a globally unique identifier, a fully specified Amazon Resource Name (ARN) to either an alias or a key, or an alias name prefixed by "alias/".You can also use a master key owned by Kinesis Data Streams by specifying the alias <code>aws/kinesis</code> .
         * <p>
         * <ul>
         * <li>Key ARN example: <code>arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</code></li>
         * <li>Alias ARN example: <code>arn:aws:kms:us-east-1:123456789012:alias/MyAliasName</code></li>
         * <li>Globally unique key ID example: <code>12345678-1234-1234-1234-123456789012</code></li>
         * <li>Alias name example: <code>alias/MyAliasName</code></li>
         * <li>Master key owned by Kinesis Data Streams: <code>alias/aws/kinesis</code></li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKeyId();

        /**
         * @return a {@link Builder} of {@link StreamEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StreamEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StreamEncryptionProperty> {
            java.lang.String encryptionType;
            java.lang.String keyId;

            /**
             * Sets the value of {@link StreamEncryptionProperty#getEncryptionType}
             * @param encryptionType The encryption type to use. This parameter is required.
             *                       The only valid value is <code>KMS</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionType(java.lang.String encryptionType) {
                this.encryptionType = encryptionType;
                return this;
            }

            /**
             * Sets the value of {@link StreamEncryptionProperty#getKeyId}
             * @param keyId The GUID for the customer-managed AWS KMS key to use for encryption. This parameter is required.
             *              This value can be a globally unique identifier, a fully specified Amazon Resource Name (ARN) to either an alias or a key, or an alias name prefixed by "alias/".You can also use a master key owned by Kinesis Data Streams by specifying the alias <code>aws/kinesis</code> .
             *              <p>
             *              <ul>
             *              <li>Key ARN example: <code>arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</code></li>
             *              <li>Alias ARN example: <code>arn:aws:kms:us-east-1:123456789012:alias/MyAliasName</code></li>
             *              <li>Globally unique key ID example: <code>12345678-1234-1234-1234-123456789012</code></li>
             *              <li>Alias name example: <code>alias/MyAliasName</code></li>
             *              <li>Master key owned by Kinesis Data Streams: <code>alias/aws/kinesis</code></li>
             *              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyId(java.lang.String keyId) {
                this.keyId = keyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StreamEncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StreamEncryptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StreamEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StreamEncryptionProperty {
            private final java.lang.String encryptionType;
            private final java.lang.String keyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encryptionType = software.amazon.jsii.Kernel.get(this, "encryptionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keyId = software.amazon.jsii.Kernel.get(this, "keyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encryptionType = java.util.Objects.requireNonNull(builder.encryptionType, "encryptionType is required");
                this.keyId = java.util.Objects.requireNonNull(builder.keyId, "keyId is required");
            }

            @Override
            public final java.lang.String getEncryptionType() {
                return this.encryptionType;
            }

            @Override
            public final java.lang.String getKeyId() {
                return this.keyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("encryptionType", om.valueToTree(this.getEncryptionType()));
                data.set("keyId", om.valueToTree(this.getKeyId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-kinesis.CfnStream.StreamEncryptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StreamEncryptionProperty.Jsii$Proxy that = (StreamEncryptionProperty.Jsii$Proxy) o;

                if (!encryptionType.equals(that.encryptionType)) return false;
                return this.keyId.equals(that.keyId);
            }

            @Override
            public final int hashCode() {
                int result = this.encryptionType.hashCode();
                result = 31 * result + (this.keyId.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies the capacity mode to which you want to set your data stream.
     * <p>
     * Currently, in Kinesis Data Streams, you can choose between an <em>on-demand</em> capacity mode and a <em>provisioned</em> capacity mode for your data streams.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesis.*;
     * StreamModeDetailsProperty streamModeDetailsProperty = StreamModeDetailsProperty.builder()
     *         .streamMode("streamMode")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesis.$Module.class, fqn = "@aws-cdk/aws-kinesis.CfnStream.StreamModeDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(StreamModeDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StreamModeDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the capacity mode to which you want to set your data stream.
         * <p>
         * Currently, in Kinesis Data Streams, you can choose between an <em>on-demand</em> capacity mode and a <em>provisioned</em> capacity mode for your data streams.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStreamMode();

        /**
         * @return a {@link Builder} of {@link StreamModeDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StreamModeDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StreamModeDetailsProperty> {
            java.lang.String streamMode;

            /**
             * Sets the value of {@link StreamModeDetailsProperty#getStreamMode}
             * @param streamMode Specifies the capacity mode to which you want to set your data stream. This parameter is required.
             *                   Currently, in Kinesis Data Streams, you can choose between an <em>on-demand</em> capacity mode and a <em>provisioned</em> capacity mode for your data streams.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamMode(java.lang.String streamMode) {
                this.streamMode = streamMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StreamModeDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StreamModeDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StreamModeDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StreamModeDetailsProperty {
            private final java.lang.String streamMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.streamMode = software.amazon.jsii.Kernel.get(this, "streamMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.streamMode = java.util.Objects.requireNonNull(builder.streamMode, "streamMode is required");
            }

            @Override
            public final java.lang.String getStreamMode() {
                return this.streamMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("streamMode", om.valueToTree(this.getStreamMode()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-kinesis.CfnStream.StreamModeDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StreamModeDetailsProperty.Jsii$Proxy that = (StreamModeDetailsProperty.Jsii$Proxy) o;

                return this.streamMode.equals(that.streamMode);
            }

            @Override
            public final int hashCode() {
                int result = this.streamMode.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.kinesis.CfnStream}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.kinesis.CfnStream> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.kinesis.CfnStreamProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The name of the Kinesis stream.
         * <p>
         * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the stream name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
         * <p>
         * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         * <p>
         * @return {@code this}
         * @param name The name of the Kinesis stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * The number of hours for the data records that are stored in shards to remain accessible.
         * <p>
         * The default value is 24. For more information about the stream retention period, see <a href="https://docs.aws.amazon.com/streams/latest/dev/kinesis-extended-retention.html">Changing the Data Retention Period</a> in the Amazon Kinesis Developer Guide.
         * <p>
         * @return {@code this}
         * @param retentionPeriodHours The number of hours for the data records that are stored in shards to remain accessible. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionPeriodHours(final java.lang.Number retentionPeriodHours) {
            this.props().retentionPeriodHours(retentionPeriodHours);
            return this;
        }

        /**
         * The number of shards that the stream uses.
         * <p>
         * For greater provisioned throughput, increase the number of shards.
         * <p>
         * @return {@code this}
         * @param shardCount The number of shards that the stream uses. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shardCount(final java.lang.Number shardCount) {
            this.props().shardCount(shardCount);
            return this;
        }

        /**
         * When specified, enables or updates server-side encryption using an AWS KMS key for a specified stream.
         * <p>
         * Removing this property from your stack template and updating your stack disables encryption.
         * <p>
         * @return {@code this}
         * @param streamEncryption When specified, enables or updates server-side encryption using an AWS KMS key for a specified stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamEncryption(final software.amazon.awscdk.services.kinesis.CfnStream.StreamEncryptionProperty streamEncryption) {
            this.props().streamEncryption(streamEncryption);
            return this;
        }
        /**
         * When specified, enables or updates server-side encryption using an AWS KMS key for a specified stream.
         * <p>
         * Removing this property from your stack template and updating your stack disables encryption.
         * <p>
         * @return {@code this}
         * @param streamEncryption When specified, enables or updates server-side encryption using an AWS KMS key for a specified stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamEncryption(final software.amazon.awscdk.core.IResolvable streamEncryption) {
            this.props().streamEncryption(streamEncryption);
            return this;
        }

        /**
         * Specifies the capacity mode to which you want to set your data stream.
         * <p>
         * Currently, in Kinesis Data Streams, you can choose between an <em>on-demand</em> capacity mode and a <em>provisioned</em> capacity mode for your data streams.
         * <p>
         * @return {@code this}
         * @param streamModeDetails Specifies the capacity mode to which you want to set your data stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamModeDetails(final software.amazon.awscdk.core.IResolvable streamModeDetails) {
            this.props().streamModeDetails(streamModeDetails);
            return this;
        }
        /**
         * Specifies the capacity mode to which you want to set your data stream.
         * <p>
         * Currently, in Kinesis Data Streams, you can choose between an <em>on-demand</em> capacity mode and a <em>provisioned</em> capacity mode for your data streams.
         * <p>
         * @return {@code this}
         * @param streamModeDetails Specifies the capacity mode to which you want to set your data stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamModeDetails(final software.amazon.awscdk.services.kinesis.CfnStream.StreamModeDetailsProperty streamModeDetails) {
            this.props().streamModeDetails(streamModeDetails);
            return this;
        }

        /**
         * An arbitrary set of tags (key–value pairs) to associate with the Kinesis stream.
         * <p>
         * For information about constraints for this property, see <a href="https://docs.aws.amazon.com/streams/latest/dev/tagging.html#tagging-restrictions">Tag Restrictions</a> in the <em>Amazon Kinesis Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param tags An arbitrary set of tags (key–value pairs) to associate with the Kinesis stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.kinesis.CfnStream}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.kinesis.CfnStream build() {
            return new software.amazon.awscdk.services.kinesis.CfnStream(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.kinesis.CfnStreamProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.kinesis.CfnStreamProps.Builder();
            }
            return this.props;
        }
    }
}
