/**
 * <h2>Amazon Kinesis Construct Library</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="Stability: Experimental" src="https://img.shields.io/badge/stability-Experimental-important.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * <strong>This is a <em>developer preview</em> (public beta) module.</strong>
 * <p>
 * All classes with the <code>Cfn</code> prefix in this module (<a href="https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib">CFN Resources</a>)
 * are auto-generated from CloudFormation. They are stable and safe to use.
 * <p>
 * However, all other classes, i.e., higher level constructs, are under active development and subject to non-backward
 * compatible changes or removal in any future version. These are not subject to the <a href="https://semver.org/">Semantic Versioning</a> model.
 * This means that while you may use them, you may need to update your source code when upgrading to a newer version of this package.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * Define an unencrypted Kinesis stream.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * new Stream(this, "MyFirstStream");
 * </pre></blockquote>
 * <p>
 * <h3>Encryption</h3>
 * <p>
 * Define a KMS-encrypted stream:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var stream = Stream.Builder.create(this, "MyEncryptedStream")
 *         .encryption(StreamEncryption.getKms())
 *         .build();
 * 
 * // you can access the encryption key:
 * assert(stream.getEncryptionKey() instanceof kms.getKey());
 * </pre></blockquote>
 * <p>
 * You can also supply your own key:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var myKmsKey = new Key(this, "MyKey");
 * 
 * var stream = Stream.Builder.create(this, "MyEncryptedStream")
 *         .encryption(StreamEncryption.getKms())
 *         .encryptionKey(myKmsKey)
 *         .build();
 * 
 * assert(stream.getEncryptionKey() === myKmsKey);
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.kinesis;
