/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.kinesis;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.kinesis.$Module;
import software.amazon.awscdk.services.kinesis.IStream;
import software.amazon.awscdk.services.kinesis.StreamAttributes;
import software.amazon.awscdk.services.kinesis.StreamEncryption;
import software.amazon.awscdk.services.kinesis.StreamProps;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesis.Stream")
public class Stream
extends Resource
implements IStream {
    protected Stream(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Stream(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Stream(@NotNull Construct scope, @NotNull String id, @Nullable StreamProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public Stream(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IStream fromStreamArn(@NotNull Construct scope, @NotNull String id, @NotNull String streamArn) {
        return (IStream)JsiiObject.jsiiStaticCall(Stream.class, (String)"fromStreamArn", IStream.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(streamArn, "streamArn is required")});
    }

    @NotNull
    public static IStream fromStreamAttributes(@NotNull Construct scope, @NotNull String id, @NotNull StreamAttributes attrs) {
        return (IStream)JsiiObject.jsiiStaticCall(Stream.class, (String)"fromStreamAttributes", IStream.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    @NotNull
    public Grant grantRead(@NotNull IGrantable grantee) {
        return (Grant)this.jsiiCall("grantRead", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public Grant grantReadWrite(@NotNull IGrantable grantee) {
        return (Grant)this.jsiiCall("grantReadWrite", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public Grant grantWrite(@NotNull IGrantable grantee) {
        return (Grant)this.jsiiCall("grantWrite", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public String getStreamArn() {
        return (String)this.jsiiGet("streamArn", String.class);
    }

    @Override
    @NotNull
    public String getStreamName() {
        return (String)this.jsiiGet("streamName", String.class);
    }

    @Override
    @Nullable
    public IKey getEncryptionKey() {
        return (IKey)this.jsiiGet("encryptionKey", IKey.class);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private StreamProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder encryption(StreamEncryption encryption) {
            this.props().encryption(encryption);
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.props().encryptionKey(encryptionKey);
            return this;
        }

        public Builder retentionPeriodHours(Number retentionPeriodHours) {
            this.props().retentionPeriodHours(retentionPeriodHours);
            return this;
        }

        public Builder shardCount(Number shardCount) {
            this.props().shardCount(shardCount);
            return this;
        }

        public Builder streamName(String streamName) {
            this.props().streamName(streamName);
            return this;
        }

        public Stream build() {
            return new Stream(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private StreamProps.Builder props() {
            if (this.props == null) {
                this.props = new StreamProps.Builder();
            }
            return this.props;
        }
    }
}

