/**
 * <h2>Amazon Kinesis Construct Library</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="Stability: Experimental" src="https://img.shields.io/badge/stability-Experimental-important.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * <strong>This is a <em>developer preview</em> (public beta) module.</strong>
 * <p>
 * All classes with the <code>Cfn</code> prefix in this module (<a href="https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib">CFN Resources</a>)
 * are auto-generated from CloudFormation. They are stable and safe to use.
 * <p>
 * However, all other classes, i.e., higher level constructs, are under active development and subject to non-backward
 * compatible changes or removal in any future version. These are not subject to the <a href="https://semver.org/">Semantic Versioning</a> model.
 * This means that while you may use them, you may need to update your source code when upgrading to a newer version of this package.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * <a href="https://docs.aws.amazon.com/streams/latest/dev/introduction.html">Amazon Kinesis</a> provides collection and processing of large
 * <a href="https://aws.amazon.com/streaming-data/">streams</a> of data records in real time. Kinesis data streams can be used for rapid and continuous data
 * intake and aggregation.
 * <p>
 * <h2>Table Of Contents</h2>
 * <p>
 * <ul>
 * <li><a href="#streams">Streams</a>
 * <p>
 * <ul>
 * <li><a href="#encryption">Encryption</a></li>
 * <li><a href="#import">Import</a></li>
 * </ul></li>
 * </ul>
 * <p>
 * <h2>Streams</h2>
 * <p>
 * Amazon Kinesis Data Streams ingests a large amount of data in real time, durably stores the data, and makes the data available for consumption.
 * <p>
 * Using the CDK, a new Kinesis stream can be created as part of the stack using the construct's constructor. You may specify the <code>streamName</code> to give
 * your own identifier to the stream. If not, CloudFormation will generate a name.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Stream.Builder.create(this, "MyFirstStream")
 *         .streamName("my-awesome-stream")
 *         .build();
 * </pre></blockquote>
 * <p>
 * You can also specify properties such as <code>shardCount</code> to indicate how many shards the stream should choose and a <code>retentionPeriod</code>
 * to specify how long the data in the shards should remain accessible.
 * Read more at <a href="https://docs.aws.amazon.com/streams/latest/dev/working-with-streams.html">Creating and Managing Streams</a>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Stream.Builder.create(this, "MyFirstStream")
 *         .streamName("my-awesome-stream")
 *         .shardCount(3)
 *         .retentionPeriod(Duration.hours(48))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Encryption</h3>
 * <p>
 * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html">Stream encryption</a> enables
 * server-side encryption using an AWS KMS key for a specified stream.
 * <p>
 * Encryption is enabled by default on your stream with the master key owned by Kinesis Data Streams in regions where it is supported.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * new Stream(this, "MyEncryptedStream");
 * </pre></blockquote>
 * <p>
 * You can enable encryption on your stream with a user-managed key by specifying the <code>encryption</code> property.
 * A KMS key will be created for you and associated with the stream.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Stream.Builder.create(this, "MyEncryptedStream")
 *         .encryption(StreamEncryption.getKMS())
 *         .build();
 * </pre></blockquote>
 * <p>
 * You can also supply your own external KMS key to use for stream encryption by specifying the <code>encryptionKey</code> property.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.kms.*;
 * 
 * Key key = new Key(this, "MyKey");
 * 
 * Stream.Builder.create(this, "MyEncryptedStream")
 *         .encryption(StreamEncryption.getKMS())
 *         .encryptionKey(key)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Import</h3>
 * <p>
 * Any Kinesis stream that has been created outside the stack can be imported into your CDK app.
 * <p>
 * Streams can be imported by their ARN via the <code>Stream.fromStreamArn()</code> API
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var stack = new Stack(app, "MyStack");
 * 
 * var importedStream = Stream.fromStreamArn(stack, "ImportedStream", "arn:aws:kinesis:us-east-2:123456789012:stream/f3j09j2230j");
 * </pre></blockquote>
 * <p>
 * Encrypted Streams can also be imported by their attributes via the <code>Stream.fromStreamAttributes()</code> API
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.kms.Key;
 * 
 * var stack = new Stack(app, "MyStack");
 * 
 * var importedStream = Stream.fromStreamAttributes(stack, "ImportedEncryptedStream", Map.of(
 *         "streamArn", "arn:aws:kinesis:us-east-2:123456789012:stream/f3j09j2230j",
 *         "encryptionKey", kms.Key.fromKeyArn("arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012")));
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.kinesis;
