package software.amazon.awscdk.services.kinesis;

/**
 * Properties for a Kinesis Stream.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.3.2 (build 237c474)", date = "2020-04-22T03:19:38.988Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesis.$Module.class, fqn = "@aws-cdk/aws-kinesis.StreamProps")
@software.amazon.jsii.Jsii.Proxy(StreamProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StreamProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The kind of server-side encryption to apply to this stream.
     * <p>
     * If you choose KMS, you can specify a KMS key via <code>encryptionKey</code>. If
     * encryption key is not specified, a key will automatically be created.
     * <p>
     * Default: - StreamEncryption.KMS if encrypted Streams are supported in the region
     * or StreamEncryption.UNENCRYPTED otherwise.
     * StreamEncryption.KMS if an encryption key is supplied through the encryptionKey property
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesis.StreamEncryption getEncryption() {
        return null;
    }

    /**
     * External KMS key to use for stream encryption.
     * <p>
     * The 'encryption' property must be set to "Kms".
     * <p>
     * Default: - Kinesis Data Streams master key ('/alias/aws/kinesis').
     * If encryption is set to StreamEncryption.KMS and this property is undefined, a new KMS key
     * will be created and associated with this stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * The number of hours for the data records that are stored in shards to remain accessible.
     * <p>
     * Default: Duration.hours(24)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getRetentionPeriod() {
        return null;
    }

    /**
     * The number of shards for the stream.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getShardCount() {
        return null;
    }

    /**
     * Enforces a particular physical stream name.
     * <p>
     * Default: <generated>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStreamName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.services.kinesis.StreamEncryption encryption;
        private software.amazon.awscdk.services.kms.IKey encryptionKey;
        private software.amazon.awscdk.core.Duration retentionPeriod;
        private java.lang.Number shardCount;
        private java.lang.String streamName;

        /**
         * Sets the value of {@link StreamProps#getEncryption}
         * @param encryption The kind of server-side encryption to apply to this stream.
         *                   If you choose KMS, you can specify a KMS key via <code>encryptionKey</code>. If
         *                   encryption key is not specified, a key will automatically be created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(software.amazon.awscdk.services.kinesis.StreamEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        /**
         * Sets the value of {@link StreamProps#getEncryptionKey}
         * @param encryptionKey External KMS key to use for stream encryption.
         *                      The 'encryption' property must be set to "Kms".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link StreamProps#getRetentionPeriod}
         * @param retentionPeriod The number of hours for the data records that are stored in shards to remain accessible.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionPeriod(software.amazon.awscdk.core.Duration retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link StreamProps#getShardCount}
         * @param shardCount The number of shards for the stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shardCount(java.lang.Number shardCount) {
            this.shardCount = shardCount;
            return this;
        }

        /**
         * Sets the value of {@link StreamProps#getStreamName}
         * @param streamName Enforces a particular physical stream name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamName(java.lang.String streamName) {
            this.streamName = streamName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StreamProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public StreamProps build() {
            return new Jsii$Proxy(encryption, encryptionKey, retentionPeriod, shardCount, streamName);
        }
    }

    /**
     * An implementation for {@link StreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StreamProps {
        private final software.amazon.awscdk.services.kinesis.StreamEncryption encryption;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final software.amazon.awscdk.core.Duration retentionPeriod;
        private final java.lang.Number shardCount;
        private final java.lang.String streamName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.encryption = this.jsiiGet("encryption", software.amazon.awscdk.services.kinesis.StreamEncryption.class);
            this.encryptionKey = this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.IKey.class);
            this.retentionPeriod = this.jsiiGet("retentionPeriod", software.amazon.awscdk.core.Duration.class);
            this.shardCount = this.jsiiGet("shardCount", java.lang.Number.class);
            this.streamName = this.jsiiGet("streamName", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.kinesis.StreamEncryption encryption, final software.amazon.awscdk.services.kms.IKey encryptionKey, final software.amazon.awscdk.core.Duration retentionPeriod, final java.lang.Number shardCount, final java.lang.String streamName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.encryption = encryption;
            this.encryptionKey = encryptionKey;
            this.retentionPeriod = retentionPeriod;
            this.shardCount = shardCount;
            this.streamName = streamName;
        }

        @Override
        public software.amazon.awscdk.services.kinesis.StreamEncryption getEncryption() {
            return this.encryption;
        }

        @Override
        public software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public software.amazon.awscdk.core.Duration getRetentionPeriod() {
            return this.retentionPeriod;
        }

        @Override
        public java.lang.Number getShardCount() {
            return this.shardCount;
        }

        @Override
        public java.lang.String getStreamName() {
            return this.streamName;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEncryption() != null) {
                data.set("encryption", om.valueToTree(this.getEncryption()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getRetentionPeriod() != null) {
                data.set("retentionPeriod", om.valueToTree(this.getRetentionPeriod()));
            }
            if (this.getShardCount() != null) {
                data.set("shardCount", om.valueToTree(this.getShardCount()));
            }
            if (this.getStreamName() != null) {
                data.set("streamName", om.valueToTree(this.getStreamName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-kinesis.StreamProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StreamProps.Jsii$Proxy that = (StreamProps.Jsii$Proxy) o;

            if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.retentionPeriod != null ? !this.retentionPeriod.equals(that.retentionPeriod) : that.retentionPeriod != null) return false;
            if (this.shardCount != null ? !this.shardCount.equals(that.shardCount) : that.shardCount != null) return false;
            return this.streamName != null ? this.streamName.equals(that.streamName) : that.streamName == null;
        }

        @Override
        public int hashCode() {
            int result = this.encryption != null ? this.encryption.hashCode() : 0;
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.retentionPeriod != null ? this.retentionPeriod.hashCode() : 0);
            result = 31 * result + (this.shardCount != null ? this.shardCount.hashCode() : 0);
            result = 31 * result + (this.streamName != null ? this.streamName.hashCode() : 0);
            return result;
        }
    }
}
