package software.amazon.awscdk.services.kinesis;

/**
 * A CloudFormation `AWS::Kinesis::Stream`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.4.1 (build 0b09d7b)", date = "2020-04-29T22:49:48.331Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesis.$Module.class, fqn = "@aws-cdk/aws-kinesis.CfnStream")
public class CfnStream extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnStream(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStream(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesis.CfnStream.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::Kinesis::Stream`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnStream(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.CfnStreamProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return this.jsiiGet("attrArn", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::Kinesis::Stream.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::Kinesis::Stream.ShardCount`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-shardcount
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.Number getShardCount() {
        return this.jsiiGet("shardCount", java.lang.Number.class);
    }

    /**
     * `AWS::Kinesis::Stream.ShardCount`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-shardcount
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setShardCount(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        this.jsiiSet("shardCount", java.util.Objects.requireNonNull(value, "shardCount is required"));
    }

    /**
     * `AWS::Kinesis::Stream.Name`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return this.jsiiGet("name", java.lang.String.class);
    }

    /**
     * `AWS::Kinesis::Stream.Name`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("name", value);
    }

    /**
     * `AWS::Kinesis::Stream.RetentionPeriodHours`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-retentionperiodhours
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.Number getRetentionPeriodHours() {
        return this.jsiiGet("retentionPeriodHours", java.lang.Number.class);
    }

    /**
     * `AWS::Kinesis::Stream.RetentionPeriodHours`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-retentionperiodhours
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRetentionPeriodHours(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        this.jsiiSet("retentionPeriodHours", value);
    }

    /**
     * `AWS::Kinesis::Stream.StreamEncryption`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-streamencryption
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStreamEncryption() {
        return this.jsiiGet("streamEncryption", java.lang.Object.class);
    }

    /**
     * `AWS::Kinesis::Stream.StreamEncryption`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-streamencryption
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setStreamEncryption(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesis.CfnStream.StreamEncryptionProperty value) {
        this.jsiiSet("streamEncryption", value);
    }

    /**
     * `AWS::Kinesis::Stream.StreamEncryption`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-streamencryption
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setStreamEncryption(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("streamEncryption", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesis.$Module.class, fqn = "@aws-cdk/aws-kinesis.CfnStream.StreamEncryptionProperty")
    @software.amazon.jsii.Jsii.Proxy(StreamEncryptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface StreamEncryptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStream.StreamEncryptionProperty.EncryptionType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-encryptiontype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.String getEncryptionType();

        /**
         * `CfnStream.StreamEncryptionProperty.KeyId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-keyid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.String getKeyId();

        /**
         * @return a {@link Builder} of {@link StreamEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StreamEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String encryptionType;
            private java.lang.String keyId;

            /**
             * Sets the value of {@link StreamEncryptionProperty#getEncryptionType}
             * @param encryptionType `CfnStream.StreamEncryptionProperty.EncryptionType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder encryptionType(java.lang.String encryptionType) {
                this.encryptionType = encryptionType;
                return this;
            }

            /**
             * Sets the value of {@link StreamEncryptionProperty#getKeyId}
             * @param keyId `CfnStream.StreamEncryptionProperty.KeyId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder keyId(java.lang.String keyId) {
                this.keyId = keyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StreamEncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public StreamEncryptionProperty build() {
                return new Jsii$Proxy(encryptionType, keyId);
            }
        }

        /**
         * An implementation for {@link StreamEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StreamEncryptionProperty {
            private final java.lang.String encryptionType;
            private final java.lang.String keyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encryptionType = this.jsiiGet("encryptionType", java.lang.String.class);
                this.keyId = this.jsiiGet("keyId", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String encryptionType, final java.lang.String keyId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encryptionType = java.util.Objects.requireNonNull(encryptionType, "encryptionType is required");
                this.keyId = java.util.Objects.requireNonNull(keyId, "keyId is required");
            }

            @Override
            public java.lang.String getEncryptionType() {
                return this.encryptionType;
            }

            @Override
            public java.lang.String getKeyId() {
                return this.keyId;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("encryptionType", om.valueToTree(this.getEncryptionType()));
                data.set("keyId", om.valueToTree(this.getKeyId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-kinesis.CfnStream.StreamEncryptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StreamEncryptionProperty.Jsii$Proxy that = (StreamEncryptionProperty.Jsii$Proxy) o;

                if (!encryptionType.equals(that.encryptionType)) return false;
                return this.keyId.equals(that.keyId);
            }

            @Override
            public int hashCode() {
                int result = this.encryptionType.hashCode();
                result = 31 * result + (this.keyId.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.kinesis.CfnStream}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.kinesis.CfnStreamProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.kinesis.CfnStreamProps.Builder();
        }

        /**
         * `AWS::Kinesis::Stream.ShardCount`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-shardcount
         * @param shardCount `AWS::Kinesis::Stream.ShardCount`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder shardCount(final java.lang.Number shardCount) {
            this.props.shardCount(shardCount);
            return this;
        }

        /**
         * `AWS::Kinesis::Stream.Name`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-name
         * @param name `AWS::Kinesis::Stream.Name`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * `AWS::Kinesis::Stream.RetentionPeriodHours`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-retentionperiodhours
         * @param retentionPeriodHours `AWS::Kinesis::Stream.RetentionPeriodHours`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder retentionPeriodHours(final java.lang.Number retentionPeriodHours) {
            this.props.retentionPeriodHours(retentionPeriodHours);
            return this;
        }

        /**
         * `AWS::Kinesis::Stream.StreamEncryption`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-streamencryption
         * @param streamEncryption `AWS::Kinesis::Stream.StreamEncryption`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder streamEncryption(final software.amazon.awscdk.services.kinesis.CfnStream.StreamEncryptionProperty streamEncryption) {
            this.props.streamEncryption(streamEncryption);
            return this;
        }
        /**
         * `AWS::Kinesis::Stream.StreamEncryption`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-streamencryption
         * @param streamEncryption `AWS::Kinesis::Stream.StreamEncryption`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder streamEncryption(final software.amazon.awscdk.core.IResolvable streamEncryption) {
            this.props.streamEncryption(streamEncryption);
            return this;
        }

        /**
         * `AWS::Kinesis::Stream.Tags`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-tags
         * @param tags `AWS::Kinesis::Stream.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(final java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.kinesis.CfnStream}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public software.amazon.awscdk.services.kinesis.CfnStream build() {
            return new software.amazon.awscdk.services.kinesis.CfnStream(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
