package software.amazon.awscdk.services.kinesis;

/**
 * A Kinesis stream.
 * <p>
 * Can be encrypted with a KMS key.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.5.0 (build 46538f8)", date = "2020-05-21T11:01:45.027Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesis.$Module.class, fqn = "@aws-cdk/aws-kinesis.Stream")
public class Stream extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.kinesis.IStream {

    protected Stream(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Stream(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Stream(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesis.StreamProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Stream(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import an existing Kinesis Stream provided an ARN.
     * <p>
     * @param scope The parent creating construct (usually `this`). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param streamArn Stream ARN (i.e. arn:aws:kinesis:<region>:<account-id>:stream/Foo). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.IStream fromStreamArn(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String streamArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kinesis.Stream.class, "fromStreamArn", software.amazon.awscdk.services.kinesis.IStream.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(streamArn, "streamArn is required") });
    }

    /**
     * Creates a Stream construct that represents an external stream.
     * <p>
     * @param scope The parent creating construct (usually `this`). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param attrs Stream import properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.IStream fromStreamAttributes(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.StreamAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kinesis.Stream.class, "fromStreamAttributes", software.amazon.awscdk.services.kinesis.IStream.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Grant the indicated permissions on this stream to the given IAM principal (Role/Group/User).
     * <p>
     * @param grantee This parameter is required.
     * @param actions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        return this.jsiiCall("grant", software.amazon.awscdk.services.iam.Grant.class, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * Grant write permissions for this stream and its contents to an IAM principal (Role/Group/User).
     * <p>
     * If an encryption key is used, permission to ues the key to decrypt the
     * contents of the stream will also be granted.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return this.jsiiCall("grantRead", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grants read/write permissions for this stream and its contents to an IAM principal (Role/Group/User).
     * <p>
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return this.jsiiCall("grantReadWrite", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grant read permissions for this stream and its contents to an IAM principal (Role/Group/User).
     * <p>
     * If an encryption key is used, permission to ues the key to decrypt the
     * contents of the stream will also be granted.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return this.jsiiCall("grantWrite", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * The ARN of the stream.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStreamArn() {
        return this.jsiiGet("streamArn", java.lang.String.class);
    }

    /**
     * The name of the stream.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStreamName() {
        return this.jsiiGet("streamName", java.lang.String.class);
    }

    /**
     * Optional KMS encryption key associated with this stream.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.IKey.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.kinesis.Stream}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.kinesis.StreamProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The kind of server-side encryption to apply to this stream.
         * <p>
         * If you choose KMS, you can specify a KMS key via <code>encryptionKey</code>. If
         * encryption key is not specified, a key will automatically be created.
         * <p>
         * Default: - StreamEncryption.KMS if encrypted Streams are supported in the region
         * or StreamEncryption.UNENCRYPTED otherwise.
         * StreamEncryption.KMS if an encryption key is supplied through the encryptionKey property
         * <p>
         * @return {@code this}
         * @param encryption The kind of server-side encryption to apply to this stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(final software.amazon.awscdk.services.kinesis.StreamEncryption encryption) {
            this.props().encryption(encryption);
            return this;
        }

        /**
         * External KMS key to use for stream encryption.
         * <p>
         * The 'encryption' property must be set to "Kms".
         * <p>
         * Default: - Kinesis Data Streams master key ('/alias/aws/kinesis').
         * If encryption is set to StreamEncryption.KMS and this property is undefined, a new KMS key
         * will be created and associated with this stream.
         * <p>
         * @return {@code this}
         * @param encryptionKey External KMS key to use for stream encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(final software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.props().encryptionKey(encryptionKey);
            return this;
        }

        /**
         * The number of hours for the data records that are stored in shards to remain accessible.
         * <p>
         * Default: Duration.hours(24)
         * <p>
         * @return {@code this}
         * @param retentionPeriod The number of hours for the data records that are stored in shards to remain accessible. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionPeriod(final software.amazon.awscdk.core.Duration retentionPeriod) {
            this.props().retentionPeriod(retentionPeriod);
            return this;
        }

        /**
         * The number of shards for the stream.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param shardCount The number of shards for the stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shardCount(final java.lang.Number shardCount) {
            this.props().shardCount(shardCount);
            return this;
        }

        /**
         * Enforces a particular physical stream name.
         * <p>
         * Default: <generated>
         * <p>
         * @return {@code this}
         * @param streamName Enforces a particular physical stream name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamName(final java.lang.String streamName) {
            this.props().streamName(streamName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.kinesis.Stream}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.kinesis.Stream build() {
            return new software.amazon.awscdk.services.kinesis.Stream(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.kinesis.StreamProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.kinesis.StreamProps.Builder();
            }
            return this.props;
        }
    }
}
