package software.amazon.awscdk.services.kinesis;

/**
 * A reference to a stream.
 * <p>
 * The easiest way to instantiate is to call
 * <code>stream.export()</code>. Then, the consumer can use <code>Stream.import(this, ref)</code> and
 * get a <code>Stream</code>.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.7.0 (build 179a3a5)", date = "2020-06-20T01:23:33.911Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesis.$Module.class, fqn = "@aws-cdk/aws-kinesis.StreamAttributes")
@software.amazon.jsii.Jsii.Proxy(StreamAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StreamAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStreamArn();

    /**
     * The KMS key securing the contents of the stream if encryption is enabled.
     * <p>
     * Default: - No encryption
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StreamAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StreamAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StreamAttributes> {
        private java.lang.String streamArn;
        private software.amazon.awscdk.services.kms.IKey encryptionKey;

        /**
         * Sets the value of {@link StreamAttributes#getStreamArn}
         * @param streamArn The ARN of the stream. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamArn(java.lang.String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        /**
         * Sets the value of {@link StreamAttributes#getEncryptionKey}
         * @param encryptionKey The KMS key securing the contents of the stream if encryption is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StreamAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StreamAttributes build() {
            return new Jsii$Proxy(streamArn, encryptionKey);
        }
    }

    /**
     * An implementation for {@link StreamAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StreamAttributes {
        private final java.lang.String streamArn;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.streamArn = this.jsiiGet("streamArn", java.lang.String.class);
            this.encryptionKey = this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.IKey.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String streamArn, final software.amazon.awscdk.services.kms.IKey encryptionKey) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.streamArn = java.util.Objects.requireNonNull(streamArn, "streamArn is required");
            this.encryptionKey = encryptionKey;
        }

        @Override
        public java.lang.String getStreamArn() {
            return this.streamArn;
        }

        @Override
        public software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("streamArn", om.valueToTree(this.getStreamArn()));
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-kinesis.StreamAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StreamAttributes.Jsii$Proxy that = (StreamAttributes.Jsii$Proxy) o;

            if (!streamArn.equals(that.streamArn)) return false;
            return this.encryptionKey != null ? this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey == null;
        }

        @Override
        public int hashCode() {
            int result = this.streamArn.hashCode();
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            return result;
        }
    }
}
