package software.amazon.awscdk.services.kinesis;

/**
 * A Kinesis Stream.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:12.464Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesis.$Module.class, fqn = "@aws-cdk/aws-kinesis.IStream")
@software.amazon.jsii.Jsii.Proxy(IStream.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IStream extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.core.IResource {

    /**
     * The ARN of the stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStreamArn();

    /**
     * The name of the stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStreamName();

    /**
     * Optional KMS encryption key associated with this stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * Grant the indicated permissions on this stream to the provided IAM principal.
     * <p>
     * @param grantee This parameter is required.
     * @param actions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions);

    /**
     * Grant read permissions for this stream and its contents to an IAM principal (Role/Group/User).
     * <p>
     * If an encryption key is used, permission to ues the key to decrypt the
     * contents of the stream will also be granted.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * Grants read/write permissions for this stream and its contents to an IAM principal (Role/Group/User).
     * <p>
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * Grant write permissions for this stream and its contents to an IAM principal (Role/Group/User).
     * <p>
     * If an encryption key is used, permission to ues the key to encrypt the
     * contents of the stream will also be granted.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesis.IStream {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The ARN of the stream.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getStreamArn() {
            return this.jsiiGet("streamArn", java.lang.String.class);
        }

        /**
         * The name of the stream.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getStreamName() {
            return this.jsiiGet("streamName", java.lang.String.class);
        }

        /**
         * Optional KMS encryption key associated with this stream.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.IKey.class);
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ResourceEnvironment getEnv() {
            return this.jsiiGet("env", software.amazon.awscdk.core.ResourceEnvironment.class);
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return this.jsiiGet("stack", software.amazon.awscdk.core.Stack.class);
        }

        /**
         * The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.core.ConstructNode.class);
        }

        /**
         * Grant the indicated permissions on this stream to the provided IAM principal.
         * <p>
         * @param grantee This parameter is required.
         * @param actions This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
            return this.jsiiCall("grant", software.amazon.awscdk.services.iam.Grant.class, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
        }

        /**
         * Grant read permissions for this stream and its contents to an IAM principal (Role/Group/User).
         * <p>
         * If an encryption key is used, permission to ues the key to decrypt the
         * contents of the stream will also be granted.
         * <p>
         * @param grantee This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return this.jsiiCall("grantRead", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Grants read/write permissions for this stream and its contents to an IAM principal (Role/Group/User).
         * <p>
         * If an encryption key is used, permission to use the key for
         * encrypt/decrypt will also be granted.
         * <p>
         * @param grantee This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return this.jsiiCall("grantReadWrite", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Grant write permissions for this stream and its contents to an IAM principal (Role/Group/User).
         * <p>
         * If an encryption key is used, permission to ues the key to encrypt the
         * contents of the stream will also be granted.
         * <p>
         * @param grantee This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return this.jsiiCall("grantWrite", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }
    }
}
