package software.amazon.awscdk.services.kinesisanalytics;

/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.13 (build 311bf88)", date = "2019-01-11T10:46:38.311Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesisanalytics.$Module.class, fqn = "@aws-cdk/aws-kinesisanalytics.CfnApplication")
public class CfnApplication extends software.amazon.awscdk.Resource {
    protected CfnApplication(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisanalytics.CfnApplication.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::KinesisAnalytics::Application``.
     * @param scope scope in which this resource is defined
     * @param id scoped id of the resource
     * @param props resource properties
     */
    public CfnApplication(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(scope, "scope is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required")).toArray());
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public java.lang.String getApplicationId() {
        return this.jsiiGet("applicationId", java.lang.String.class);
    }

    public software.amazon.awscdk.services.kinesisanalytics.CfnApplicationProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.kinesisanalytics.CfnApplicationProps.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-csvmappingparameters.html
     */
    public static interface CSVMappingParametersProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnApplication.CSVMappingParametersProperty.RecordColumnDelimiter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-csvmappingparameters.html#cfn-kinesisanalytics-application-csvmappingparameters-recordcolumndelimiter
         */
        java.lang.String getRecordColumnDelimiter();
        /**
         * ``CfnApplication.CSVMappingParametersProperty.RecordColumnDelimiter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-csvmappingparameters.html#cfn-kinesisanalytics-application-csvmappingparameters-recordcolumndelimiter
         */
        void setRecordColumnDelimiter(final java.lang.String value);
        /**
         * ``CfnApplication.CSVMappingParametersProperty.RecordRowDelimiter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-csvmappingparameters.html#cfn-kinesisanalytics-application-csvmappingparameters-recordrowdelimiter
         */
        java.lang.String getRecordRowDelimiter();
        /**
         * ``CfnApplication.CSVMappingParametersProperty.RecordRowDelimiter``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-csvmappingparameters.html#cfn-kinesisanalytics-application-csvmappingparameters-recordrowdelimiter
         */
        void setRecordRowDelimiter(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link CSVMappingParametersProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CSVMappingParametersProperty}
         */
        final class Builder {
            private java.lang.String _recordColumnDelimiter;
            private java.lang.String _recordRowDelimiter;

            /**
             * Sets the value of RecordColumnDelimiter
             * @param value ``CfnApplication.CSVMappingParametersProperty.RecordColumnDelimiter``
             * @return {@code this}
             */
            public Builder withRecordColumnDelimiter(final java.lang.String value) {
                this._recordColumnDelimiter = java.util.Objects.requireNonNull(value, "recordColumnDelimiter is required");
                return this;
            }
            /**
             * Sets the value of RecordRowDelimiter
             * @param value ``CfnApplication.CSVMappingParametersProperty.RecordRowDelimiter``
             * @return {@code this}
             */
            public Builder withRecordRowDelimiter(final java.lang.String value) {
                this._recordRowDelimiter = java.util.Objects.requireNonNull(value, "recordRowDelimiter is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CSVMappingParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public CSVMappingParametersProperty build() {
                return new CSVMappingParametersProperty() {
                    private java.lang.String $recordColumnDelimiter = java.util.Objects.requireNonNull(_recordColumnDelimiter, "recordColumnDelimiter is required");
                    private java.lang.String $recordRowDelimiter = java.util.Objects.requireNonNull(_recordRowDelimiter, "recordRowDelimiter is required");

                    @Override
                    public java.lang.String getRecordColumnDelimiter() {
                        return this.$recordColumnDelimiter;
                    }

                    @Override
                    public void setRecordColumnDelimiter(final java.lang.String value) {
                        this.$recordColumnDelimiter = java.util.Objects.requireNonNull(value, "recordColumnDelimiter is required");
                    }

                    @Override
                    public java.lang.String getRecordRowDelimiter() {
                        return this.$recordRowDelimiter;
                    }

                    @Override
                    public void setRecordRowDelimiter(final java.lang.String value) {
                        this.$recordRowDelimiter = java.util.Objects.requireNonNull(value, "recordRowDelimiter is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplication.CSVMappingParametersProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnApplication.CSVMappingParametersProperty.RecordColumnDelimiter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-csvmappingparameters.html#cfn-kinesisanalytics-application-csvmappingparameters-recordcolumndelimiter
             */
            @Override
            public java.lang.String getRecordColumnDelimiter() {
                return this.jsiiGet("recordColumnDelimiter", java.lang.String.class);
            }

            /**
             * ``CfnApplication.CSVMappingParametersProperty.RecordColumnDelimiter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-csvmappingparameters.html#cfn-kinesisanalytics-application-csvmappingparameters-recordcolumndelimiter
             */
            @Override
            public void setRecordColumnDelimiter(final java.lang.String value) {
                this.jsiiSet("recordColumnDelimiter", java.util.Objects.requireNonNull(value, "recordColumnDelimiter is required"));
            }

            /**
             * ``CfnApplication.CSVMappingParametersProperty.RecordRowDelimiter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-csvmappingparameters.html#cfn-kinesisanalytics-application-csvmappingparameters-recordrowdelimiter
             */
            @Override
            public java.lang.String getRecordRowDelimiter() {
                return this.jsiiGet("recordRowDelimiter", java.lang.String.class);
            }

            /**
             * ``CfnApplication.CSVMappingParametersProperty.RecordRowDelimiter``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-csvmappingparameters.html#cfn-kinesisanalytics-application-csvmappingparameters-recordrowdelimiter
             */
            @Override
            public void setRecordRowDelimiter(final java.lang.String value) {
                this.jsiiSet("recordRowDelimiter", java.util.Objects.requireNonNull(value, "recordRowDelimiter is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html
     */
    public static interface InputLambdaProcessorProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnApplication.InputLambdaProcessorProperty.ResourceARN``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html#cfn-kinesisanalytics-application-inputlambdaprocessor-resourcearn
         */
        java.lang.String getResourceArn();
        /**
         * ``CfnApplication.InputLambdaProcessorProperty.ResourceARN``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html#cfn-kinesisanalytics-application-inputlambdaprocessor-resourcearn
         */
        void setResourceArn(final java.lang.String value);
        /**
         * ``CfnApplication.InputLambdaProcessorProperty.RoleARN``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html#cfn-kinesisanalytics-application-inputlambdaprocessor-rolearn
         */
        java.lang.String getRoleArn();
        /**
         * ``CfnApplication.InputLambdaProcessorProperty.RoleARN``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html#cfn-kinesisanalytics-application-inputlambdaprocessor-rolearn
         */
        void setRoleArn(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link InputLambdaProcessorProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InputLambdaProcessorProperty}
         */
        final class Builder {
            private java.lang.String _resourceArn;
            private java.lang.String _roleArn;

            /**
             * Sets the value of ResourceArn
             * @param value ``CfnApplication.InputLambdaProcessorProperty.ResourceARN``
             * @return {@code this}
             */
            public Builder withResourceArn(final java.lang.String value) {
                this._resourceArn = java.util.Objects.requireNonNull(value, "resourceArn is required");
                return this;
            }
            /**
             * Sets the value of RoleArn
             * @param value ``CfnApplication.InputLambdaProcessorProperty.RoleARN``
             * @return {@code this}
             */
            public Builder withRoleArn(final java.lang.String value) {
                this._roleArn = java.util.Objects.requireNonNull(value, "roleArn is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputLambdaProcessorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public InputLambdaProcessorProperty build() {
                return new InputLambdaProcessorProperty() {
                    private java.lang.String $resourceArn = java.util.Objects.requireNonNull(_resourceArn, "resourceArn is required");
                    private java.lang.String $roleArn = java.util.Objects.requireNonNull(_roleArn, "roleArn is required");

                    @Override
                    public java.lang.String getResourceArn() {
                        return this.$resourceArn;
                    }

                    @Override
                    public void setResourceArn(final java.lang.String value) {
                        this.$resourceArn = java.util.Objects.requireNonNull(value, "resourceArn is required");
                    }

                    @Override
                    public java.lang.String getRoleArn() {
                        return this.$roleArn;
                    }

                    @Override
                    public void setRoleArn(final java.lang.String value) {
                        this.$roleArn = java.util.Objects.requireNonNull(value, "roleArn is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputLambdaProcessorProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnApplication.InputLambdaProcessorProperty.ResourceARN``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html#cfn-kinesisanalytics-application-inputlambdaprocessor-resourcearn
             */
            @Override
            public java.lang.String getResourceArn() {
                return this.jsiiGet("resourceArn", java.lang.String.class);
            }

            /**
             * ``CfnApplication.InputLambdaProcessorProperty.ResourceARN``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html#cfn-kinesisanalytics-application-inputlambdaprocessor-resourcearn
             */
            @Override
            public void setResourceArn(final java.lang.String value) {
                this.jsiiSet("resourceArn", java.util.Objects.requireNonNull(value, "resourceArn is required"));
            }

            /**
             * ``CfnApplication.InputLambdaProcessorProperty.RoleARN``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html#cfn-kinesisanalytics-application-inputlambdaprocessor-rolearn
             */
            @Override
            public java.lang.String getRoleArn() {
                return this.jsiiGet("roleArn", java.lang.String.class);
            }

            /**
             * ``CfnApplication.InputLambdaProcessorProperty.RoleARN``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html#cfn-kinesisanalytics-application-inputlambdaprocessor-rolearn
             */
            @Override
            public void setRoleArn(final java.lang.String value) {
                this.jsiiSet("roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputparallelism.html
     */
    public static interface InputParallelismProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnApplication.InputParallelismProperty.Count``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputparallelism.html#cfn-kinesisanalytics-application-inputparallelism-count
         */
        java.lang.Object getCount();
        /**
         * ``CfnApplication.InputParallelismProperty.Count``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputparallelism.html#cfn-kinesisanalytics-application-inputparallelism-count
         */
        void setCount(final java.lang.Number value);
        /**
         * ``CfnApplication.InputParallelismProperty.Count``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputparallelism.html#cfn-kinesisanalytics-application-inputparallelism-count
         */
        void setCount(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link InputParallelismProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InputParallelismProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _count;

            /**
             * Sets the value of Count
             * @param value ``CfnApplication.InputParallelismProperty.Count``
             * @return {@code this}
             */
            public Builder withCount(@javax.annotation.Nullable final java.lang.Number value) {
                this._count = value;
                return this;
            }
            /**
             * Sets the value of Count
             * @param value ``CfnApplication.InputParallelismProperty.Count``
             * @return {@code this}
             */
            public Builder withCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._count = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputParallelismProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public InputParallelismProperty build() {
                return new InputParallelismProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $count = _count;

                    @Override
                    public java.lang.Object getCount() {
                        return this.$count;
                    }

                    @Override
                    public void setCount(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$count = value;
                    }

                    @Override
                    public void setCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$count = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputParallelismProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnApplication.InputParallelismProperty.Count``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputparallelism.html#cfn-kinesisanalytics-application-inputparallelism-count
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCount() {
                return this.jsiiGet("count", java.lang.Object.class);
            }

            /**
             * ``CfnApplication.InputParallelismProperty.Count``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputparallelism.html#cfn-kinesisanalytics-application-inputparallelism-count
             */
            @Override
            public void setCount(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("count", value);
            }

            /**
             * ``CfnApplication.InputParallelismProperty.Count``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputparallelism.html#cfn-kinesisanalytics-application-inputparallelism-count
             */
            @Override
            public void setCount(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("count", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputprocessingconfiguration.html
     */
    public static interface InputProcessingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnApplication.InputProcessingConfigurationProperty.InputLambdaProcessor``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputprocessingconfiguration.html#cfn-kinesisanalytics-application-inputprocessingconfiguration-inputlambdaprocessor
         */
        java.lang.Object getInputLambdaProcessor();
        /**
         * ``CfnApplication.InputProcessingConfigurationProperty.InputLambdaProcessor``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputprocessingconfiguration.html#cfn-kinesisanalytics-application-inputprocessingconfiguration-inputlambdaprocessor
         */
        void setInputLambdaProcessor(final software.amazon.awscdk.Token value);
        /**
         * ``CfnApplication.InputProcessingConfigurationProperty.InputLambdaProcessor``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputprocessingconfiguration.html#cfn-kinesisanalytics-application-inputprocessingconfiguration-inputlambdaprocessor
         */
        void setInputLambdaProcessor(final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputLambdaProcessorProperty value);

        /**
         * @return a {@link Builder} of {@link InputProcessingConfigurationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InputProcessingConfigurationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _inputLambdaProcessor;

            /**
             * Sets the value of InputLambdaProcessor
             * @param value ``CfnApplication.InputProcessingConfigurationProperty.InputLambdaProcessor``
             * @return {@code this}
             */
            public Builder withInputLambdaProcessor(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._inputLambdaProcessor = value;
                return this;
            }
            /**
             * Sets the value of InputLambdaProcessor
             * @param value ``CfnApplication.InputProcessingConfigurationProperty.InputLambdaProcessor``
             * @return {@code this}
             */
            public Builder withInputLambdaProcessor(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputLambdaProcessorProperty value) {
                this._inputLambdaProcessor = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputProcessingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public InputProcessingConfigurationProperty build() {
                return new InputProcessingConfigurationProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $inputLambdaProcessor = _inputLambdaProcessor;

                    @Override
                    public java.lang.Object getInputLambdaProcessor() {
                        return this.$inputLambdaProcessor;
                    }

                    @Override
                    public void setInputLambdaProcessor(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$inputLambdaProcessor = value;
                    }

                    @Override
                    public void setInputLambdaProcessor(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputLambdaProcessorProperty value) {
                        this.$inputLambdaProcessor = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputProcessingConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnApplication.InputProcessingConfigurationProperty.InputLambdaProcessor``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputprocessingconfiguration.html#cfn-kinesisanalytics-application-inputprocessingconfiguration-inputlambdaprocessor
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getInputLambdaProcessor() {
                return this.jsiiGet("inputLambdaProcessor", java.lang.Object.class);
            }

            /**
             * ``CfnApplication.InputProcessingConfigurationProperty.InputLambdaProcessor``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputprocessingconfiguration.html#cfn-kinesisanalytics-application-inputprocessingconfiguration-inputlambdaprocessor
             */
            @Override
            public void setInputLambdaProcessor(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("inputLambdaProcessor", value);
            }

            /**
             * ``CfnApplication.InputProcessingConfigurationProperty.InputLambdaProcessor``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputprocessingconfiguration.html#cfn-kinesisanalytics-application-inputprocessingconfiguration-inputlambdaprocessor
             */
            @Override
            public void setInputLambdaProcessor(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputLambdaProcessorProperty value) {
                this.jsiiSet("inputLambdaProcessor", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html
     */
    public static interface InputProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnApplication.InputProperty.InputSchema``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputschema
         */
        java.lang.Object getInputSchema();
        /**
         * ``CfnApplication.InputProperty.InputSchema``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputschema
         */
        void setInputSchema(final software.amazon.awscdk.Token value);
        /**
         * ``CfnApplication.InputProperty.InputSchema``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputschema
         */
        void setInputSchema(final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputSchemaProperty value);
        /**
         * ``CfnApplication.InputProperty.NamePrefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-nameprefix
         */
        java.lang.String getNamePrefix();
        /**
         * ``CfnApplication.InputProperty.NamePrefix``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-nameprefix
         */
        void setNamePrefix(final java.lang.String value);
        /**
         * ``CfnApplication.InputProperty.InputParallelism``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputparallelism
         */
        java.lang.Object getInputParallelism();
        /**
         * ``CfnApplication.InputProperty.InputParallelism``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputparallelism
         */
        void setInputParallelism(final software.amazon.awscdk.Token value);
        /**
         * ``CfnApplication.InputProperty.InputParallelism``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputparallelism
         */
        void setInputParallelism(final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputParallelismProperty value);
        /**
         * ``CfnApplication.InputProperty.InputProcessingConfiguration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputprocessingconfiguration
         */
        java.lang.Object getInputProcessingConfiguration();
        /**
         * ``CfnApplication.InputProperty.InputProcessingConfiguration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputprocessingconfiguration
         */
        void setInputProcessingConfiguration(final software.amazon.awscdk.Token value);
        /**
         * ``CfnApplication.InputProperty.InputProcessingConfiguration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputprocessingconfiguration
         */
        void setInputProcessingConfiguration(final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputProcessingConfigurationProperty value);
        /**
         * ``CfnApplication.InputProperty.KinesisFirehoseInput``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-kinesisfirehoseinput
         */
        java.lang.Object getKinesisFirehoseInput();
        /**
         * ``CfnApplication.InputProperty.KinesisFirehoseInput``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-kinesisfirehoseinput
         */
        void setKinesisFirehoseInput(final software.amazon.awscdk.Token value);
        /**
         * ``CfnApplication.InputProperty.KinesisFirehoseInput``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-kinesisfirehoseinput
         */
        void setKinesisFirehoseInput(final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.KinesisFirehoseInputProperty value);
        /**
         * ``CfnApplication.InputProperty.KinesisStreamsInput``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-kinesisstreamsinput
         */
        java.lang.Object getKinesisStreamsInput();
        /**
         * ``CfnApplication.InputProperty.KinesisStreamsInput``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-kinesisstreamsinput
         */
        void setKinesisStreamsInput(final software.amazon.awscdk.Token value);
        /**
         * ``CfnApplication.InputProperty.KinesisStreamsInput``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-kinesisstreamsinput
         */
        void setKinesisStreamsInput(final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.KinesisStreamsInputProperty value);

        /**
         * @return a {@link Builder} of {@link InputProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InputProperty}
         */
        final class Builder {
            private java.lang.Object _inputSchema;
            private java.lang.String _namePrefix;
            @javax.annotation.Nullable
            private java.lang.Object _inputParallelism;
            @javax.annotation.Nullable
            private java.lang.Object _inputProcessingConfiguration;
            @javax.annotation.Nullable
            private java.lang.Object _kinesisFirehoseInput;
            @javax.annotation.Nullable
            private java.lang.Object _kinesisStreamsInput;

            /**
             * Sets the value of InputSchema
             * @param value ``CfnApplication.InputProperty.InputSchema``
             * @return {@code this}
             */
            public Builder withInputSchema(final software.amazon.awscdk.Token value) {
                this._inputSchema = java.util.Objects.requireNonNull(value, "inputSchema is required");
                return this;
            }
            /**
             * Sets the value of InputSchema
             * @param value ``CfnApplication.InputProperty.InputSchema``
             * @return {@code this}
             */
            public Builder withInputSchema(final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputSchemaProperty value) {
                this._inputSchema = java.util.Objects.requireNonNull(value, "inputSchema is required");
                return this;
            }
            /**
             * Sets the value of NamePrefix
             * @param value ``CfnApplication.InputProperty.NamePrefix``
             * @return {@code this}
             */
            public Builder withNamePrefix(final java.lang.String value) {
                this._namePrefix = java.util.Objects.requireNonNull(value, "namePrefix is required");
                return this;
            }
            /**
             * Sets the value of InputParallelism
             * @param value ``CfnApplication.InputProperty.InputParallelism``
             * @return {@code this}
             */
            public Builder withInputParallelism(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._inputParallelism = value;
                return this;
            }
            /**
             * Sets the value of InputParallelism
             * @param value ``CfnApplication.InputProperty.InputParallelism``
             * @return {@code this}
             */
            public Builder withInputParallelism(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputParallelismProperty value) {
                this._inputParallelism = value;
                return this;
            }
            /**
             * Sets the value of InputProcessingConfiguration
             * @param value ``CfnApplication.InputProperty.InputProcessingConfiguration``
             * @return {@code this}
             */
            public Builder withInputProcessingConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._inputProcessingConfiguration = value;
                return this;
            }
            /**
             * Sets the value of InputProcessingConfiguration
             * @param value ``CfnApplication.InputProperty.InputProcessingConfiguration``
             * @return {@code this}
             */
            public Builder withInputProcessingConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputProcessingConfigurationProperty value) {
                this._inputProcessingConfiguration = value;
                return this;
            }
            /**
             * Sets the value of KinesisFirehoseInput
             * @param value ``CfnApplication.InputProperty.KinesisFirehoseInput``
             * @return {@code this}
             */
            public Builder withKinesisFirehoseInput(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._kinesisFirehoseInput = value;
                return this;
            }
            /**
             * Sets the value of KinesisFirehoseInput
             * @param value ``CfnApplication.InputProperty.KinesisFirehoseInput``
             * @return {@code this}
             */
            public Builder withKinesisFirehoseInput(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.KinesisFirehoseInputProperty value) {
                this._kinesisFirehoseInput = value;
                return this;
            }
            /**
             * Sets the value of KinesisStreamsInput
             * @param value ``CfnApplication.InputProperty.KinesisStreamsInput``
             * @return {@code this}
             */
            public Builder withKinesisStreamsInput(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._kinesisStreamsInput = value;
                return this;
            }
            /**
             * Sets the value of KinesisStreamsInput
             * @param value ``CfnApplication.InputProperty.KinesisStreamsInput``
             * @return {@code this}
             */
            public Builder withKinesisStreamsInput(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.KinesisStreamsInputProperty value) {
                this._kinesisStreamsInput = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public InputProperty build() {
                return new InputProperty() {
                    private java.lang.Object $inputSchema = java.util.Objects.requireNonNull(_inputSchema, "inputSchema is required");
                    private java.lang.String $namePrefix = java.util.Objects.requireNonNull(_namePrefix, "namePrefix is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $inputParallelism = _inputParallelism;
                    @javax.annotation.Nullable
                    private java.lang.Object $inputProcessingConfiguration = _inputProcessingConfiguration;
                    @javax.annotation.Nullable
                    private java.lang.Object $kinesisFirehoseInput = _kinesisFirehoseInput;
                    @javax.annotation.Nullable
                    private java.lang.Object $kinesisStreamsInput = _kinesisStreamsInput;

                    @Override
                    public java.lang.Object getInputSchema() {
                        return this.$inputSchema;
                    }

                    @Override
                    public void setInputSchema(final software.amazon.awscdk.Token value) {
                        this.$inputSchema = java.util.Objects.requireNonNull(value, "inputSchema is required");
                    }

                    @Override
                    public void setInputSchema(final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputSchemaProperty value) {
                        this.$inputSchema = java.util.Objects.requireNonNull(value, "inputSchema is required");
                    }

                    @Override
                    public java.lang.String getNamePrefix() {
                        return this.$namePrefix;
                    }

                    @Override
                    public void setNamePrefix(final java.lang.String value) {
                        this.$namePrefix = java.util.Objects.requireNonNull(value, "namePrefix is required");
                    }

                    @Override
                    public java.lang.Object getInputParallelism() {
                        return this.$inputParallelism;
                    }

                    @Override
                    public void setInputParallelism(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$inputParallelism = value;
                    }

                    @Override
                    public void setInputParallelism(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputParallelismProperty value) {
                        this.$inputParallelism = value;
                    }

                    @Override
                    public java.lang.Object getInputProcessingConfiguration() {
                        return this.$inputProcessingConfiguration;
                    }

                    @Override
                    public void setInputProcessingConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$inputProcessingConfiguration = value;
                    }

                    @Override
                    public void setInputProcessingConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputProcessingConfigurationProperty value) {
                        this.$inputProcessingConfiguration = value;
                    }

                    @Override
                    public java.lang.Object getKinesisFirehoseInput() {
                        return this.$kinesisFirehoseInput;
                    }

                    @Override
                    public void setKinesisFirehoseInput(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$kinesisFirehoseInput = value;
                    }

                    @Override
                    public void setKinesisFirehoseInput(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.KinesisFirehoseInputProperty value) {
                        this.$kinesisFirehoseInput = value;
                    }

                    @Override
                    public java.lang.Object getKinesisStreamsInput() {
                        return this.$kinesisStreamsInput;
                    }

                    @Override
                    public void setKinesisStreamsInput(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$kinesisStreamsInput = value;
                    }

                    @Override
                    public void setKinesisStreamsInput(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.KinesisStreamsInputProperty value) {
                        this.$kinesisStreamsInput = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnApplication.InputProperty.InputSchema``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputschema
             */
            @Override
            public java.lang.Object getInputSchema() {
                return this.jsiiGet("inputSchema", java.lang.Object.class);
            }

            /**
             * ``CfnApplication.InputProperty.InputSchema``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputschema
             */
            @Override
            public void setInputSchema(final software.amazon.awscdk.Token value) {
                this.jsiiSet("inputSchema", java.util.Objects.requireNonNull(value, "inputSchema is required"));
            }

            /**
             * ``CfnApplication.InputProperty.InputSchema``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputschema
             */
            @Override
            public void setInputSchema(final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputSchemaProperty value) {
                this.jsiiSet("inputSchema", java.util.Objects.requireNonNull(value, "inputSchema is required"));
            }

            /**
             * ``CfnApplication.InputProperty.NamePrefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-nameprefix
             */
            @Override
            public java.lang.String getNamePrefix() {
                return this.jsiiGet("namePrefix", java.lang.String.class);
            }

            /**
             * ``CfnApplication.InputProperty.NamePrefix``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-nameprefix
             */
            @Override
            public void setNamePrefix(final java.lang.String value) {
                this.jsiiSet("namePrefix", java.util.Objects.requireNonNull(value, "namePrefix is required"));
            }

            /**
             * ``CfnApplication.InputProperty.InputParallelism``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputparallelism
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getInputParallelism() {
                return this.jsiiGet("inputParallelism", java.lang.Object.class);
            }

            /**
             * ``CfnApplication.InputProperty.InputParallelism``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputparallelism
             */
            @Override
            public void setInputParallelism(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("inputParallelism", value);
            }

            /**
             * ``CfnApplication.InputProperty.InputParallelism``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputparallelism
             */
            @Override
            public void setInputParallelism(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputParallelismProperty value) {
                this.jsiiSet("inputParallelism", value);
            }

            /**
             * ``CfnApplication.InputProperty.InputProcessingConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputprocessingconfiguration
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getInputProcessingConfiguration() {
                return this.jsiiGet("inputProcessingConfiguration", java.lang.Object.class);
            }

            /**
             * ``CfnApplication.InputProperty.InputProcessingConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputprocessingconfiguration
             */
            @Override
            public void setInputProcessingConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("inputProcessingConfiguration", value);
            }

            /**
             * ``CfnApplication.InputProperty.InputProcessingConfiguration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputprocessingconfiguration
             */
            @Override
            public void setInputProcessingConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputProcessingConfigurationProperty value) {
                this.jsiiSet("inputProcessingConfiguration", value);
            }

            /**
             * ``CfnApplication.InputProperty.KinesisFirehoseInput``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-kinesisfirehoseinput
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getKinesisFirehoseInput() {
                return this.jsiiGet("kinesisFirehoseInput", java.lang.Object.class);
            }

            /**
             * ``CfnApplication.InputProperty.KinesisFirehoseInput``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-kinesisfirehoseinput
             */
            @Override
            public void setKinesisFirehoseInput(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("kinesisFirehoseInput", value);
            }

            /**
             * ``CfnApplication.InputProperty.KinesisFirehoseInput``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-kinesisfirehoseinput
             */
            @Override
            public void setKinesisFirehoseInput(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.KinesisFirehoseInputProperty value) {
                this.jsiiSet("kinesisFirehoseInput", value);
            }

            /**
             * ``CfnApplication.InputProperty.KinesisStreamsInput``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-kinesisstreamsinput
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getKinesisStreamsInput() {
                return this.jsiiGet("kinesisStreamsInput", java.lang.Object.class);
            }

            /**
             * ``CfnApplication.InputProperty.KinesisStreamsInput``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-kinesisstreamsinput
             */
            @Override
            public void setKinesisStreamsInput(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("kinesisStreamsInput", value);
            }

            /**
             * ``CfnApplication.InputProperty.KinesisStreamsInput``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-kinesisstreamsinput
             */
            @Override
            public void setKinesisStreamsInput(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.KinesisStreamsInputProperty value) {
                this.jsiiSet("kinesisStreamsInput", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html
     */
    public static interface InputSchemaProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnApplication.InputSchemaProperty.RecordColumns``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordcolumns
         */
        java.lang.Object getRecordColumns();
        /**
         * ``CfnApplication.InputSchemaProperty.RecordColumns``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordcolumns
         */
        void setRecordColumns(final software.amazon.awscdk.Token value);
        /**
         * ``CfnApplication.InputSchemaProperty.RecordColumns``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordcolumns
         */
        void setRecordColumns(final java.util.List<java.lang.Object> value);
        /**
         * ``CfnApplication.InputSchemaProperty.RecordFormat``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordformat
         */
        java.lang.Object getRecordFormat();
        /**
         * ``CfnApplication.InputSchemaProperty.RecordFormat``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordformat
         */
        void setRecordFormat(final software.amazon.awscdk.Token value);
        /**
         * ``CfnApplication.InputSchemaProperty.RecordFormat``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordformat
         */
        void setRecordFormat(final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.RecordFormatProperty value);
        /**
         * ``CfnApplication.InputSchemaProperty.RecordEncoding``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordencoding
         */
        java.lang.String getRecordEncoding();
        /**
         * ``CfnApplication.InputSchemaProperty.RecordEncoding``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordencoding
         */
        void setRecordEncoding(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link InputSchemaProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InputSchemaProperty}
         */
        final class Builder {
            private java.lang.Object _recordColumns;
            private java.lang.Object _recordFormat;
            @javax.annotation.Nullable
            private java.lang.String _recordEncoding;

            /**
             * Sets the value of RecordColumns
             * @param value ``CfnApplication.InputSchemaProperty.RecordColumns``
             * @return {@code this}
             */
            public Builder withRecordColumns(final software.amazon.awscdk.Token value) {
                this._recordColumns = java.util.Objects.requireNonNull(value, "recordColumns is required");
                return this;
            }
            /**
             * Sets the value of RecordColumns
             * @param value ``CfnApplication.InputSchemaProperty.RecordColumns``
             * @return {@code this}
             */
            public Builder withRecordColumns(final java.util.List<java.lang.Object> value) {
                this._recordColumns = java.util.Objects.requireNonNull(value, "recordColumns is required");
                return this;
            }
            /**
             * Sets the value of RecordFormat
             * @param value ``CfnApplication.InputSchemaProperty.RecordFormat``
             * @return {@code this}
             */
            public Builder withRecordFormat(final software.amazon.awscdk.Token value) {
                this._recordFormat = java.util.Objects.requireNonNull(value, "recordFormat is required");
                return this;
            }
            /**
             * Sets the value of RecordFormat
             * @param value ``CfnApplication.InputSchemaProperty.RecordFormat``
             * @return {@code this}
             */
            public Builder withRecordFormat(final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.RecordFormatProperty value) {
                this._recordFormat = java.util.Objects.requireNonNull(value, "recordFormat is required");
                return this;
            }
            /**
             * Sets the value of RecordEncoding
             * @param value ``CfnApplication.InputSchemaProperty.RecordEncoding``
             * @return {@code this}
             */
            public Builder withRecordEncoding(@javax.annotation.Nullable final java.lang.String value) {
                this._recordEncoding = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputSchemaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public InputSchemaProperty build() {
                return new InputSchemaProperty() {
                    private java.lang.Object $recordColumns = java.util.Objects.requireNonNull(_recordColumns, "recordColumns is required");
                    private java.lang.Object $recordFormat = java.util.Objects.requireNonNull(_recordFormat, "recordFormat is required");
                    @javax.annotation.Nullable
                    private java.lang.String $recordEncoding = _recordEncoding;

                    @Override
                    public java.lang.Object getRecordColumns() {
                        return this.$recordColumns;
                    }

                    @Override
                    public void setRecordColumns(final software.amazon.awscdk.Token value) {
                        this.$recordColumns = java.util.Objects.requireNonNull(value, "recordColumns is required");
                    }

                    @Override
                    public void setRecordColumns(final java.util.List<java.lang.Object> value) {
                        this.$recordColumns = java.util.Objects.requireNonNull(value, "recordColumns is required");
                    }

                    @Override
                    public java.lang.Object getRecordFormat() {
                        return this.$recordFormat;
                    }

                    @Override
                    public void setRecordFormat(final software.amazon.awscdk.Token value) {
                        this.$recordFormat = java.util.Objects.requireNonNull(value, "recordFormat is required");
                    }

                    @Override
                    public void setRecordFormat(final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.RecordFormatProperty value) {
                        this.$recordFormat = java.util.Objects.requireNonNull(value, "recordFormat is required");
                    }

                    @Override
                    public java.lang.String getRecordEncoding() {
                        return this.$recordEncoding;
                    }

                    @Override
                    public void setRecordEncoding(@javax.annotation.Nullable final java.lang.String value) {
                        this.$recordEncoding = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputSchemaProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnApplication.InputSchemaProperty.RecordColumns``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordcolumns
             */
            @Override
            public java.lang.Object getRecordColumns() {
                return this.jsiiGet("recordColumns", java.lang.Object.class);
            }

            /**
             * ``CfnApplication.InputSchemaProperty.RecordColumns``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordcolumns
             */
            @Override
            public void setRecordColumns(final software.amazon.awscdk.Token value) {
                this.jsiiSet("recordColumns", java.util.Objects.requireNonNull(value, "recordColumns is required"));
            }

            /**
             * ``CfnApplication.InputSchemaProperty.RecordColumns``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordcolumns
             */
            @Override
            public void setRecordColumns(final java.util.List<java.lang.Object> value) {
                this.jsiiSet("recordColumns", java.util.Objects.requireNonNull(value, "recordColumns is required"));
            }

            /**
             * ``CfnApplication.InputSchemaProperty.RecordFormat``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordformat
             */
            @Override
            public java.lang.Object getRecordFormat() {
                return this.jsiiGet("recordFormat", java.lang.Object.class);
            }

            /**
             * ``CfnApplication.InputSchemaProperty.RecordFormat``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordformat
             */
            @Override
            public void setRecordFormat(final software.amazon.awscdk.Token value) {
                this.jsiiSet("recordFormat", java.util.Objects.requireNonNull(value, "recordFormat is required"));
            }

            /**
             * ``CfnApplication.InputSchemaProperty.RecordFormat``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordformat
             */
            @Override
            public void setRecordFormat(final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.RecordFormatProperty value) {
                this.jsiiSet("recordFormat", java.util.Objects.requireNonNull(value, "recordFormat is required"));
            }

            /**
             * ``CfnApplication.InputSchemaProperty.RecordEncoding``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordencoding
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getRecordEncoding() {
                return this.jsiiGet("recordEncoding", java.lang.String.class);
            }

            /**
             * ``CfnApplication.InputSchemaProperty.RecordEncoding``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordencoding
             */
            @Override
            public void setRecordEncoding(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("recordEncoding", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-jsonmappingparameters.html
     */
    public static interface JSONMappingParametersProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnApplication.JSONMappingParametersProperty.RecordRowPath``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-jsonmappingparameters.html#cfn-kinesisanalytics-application-jsonmappingparameters-recordrowpath
         */
        java.lang.String getRecordRowPath();
        /**
         * ``CfnApplication.JSONMappingParametersProperty.RecordRowPath``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-jsonmappingparameters.html#cfn-kinesisanalytics-application-jsonmappingparameters-recordrowpath
         */
        void setRecordRowPath(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link JSONMappingParametersProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link JSONMappingParametersProperty}
         */
        final class Builder {
            private java.lang.String _recordRowPath;

            /**
             * Sets the value of RecordRowPath
             * @param value ``CfnApplication.JSONMappingParametersProperty.RecordRowPath``
             * @return {@code this}
             */
            public Builder withRecordRowPath(final java.lang.String value) {
                this._recordRowPath = java.util.Objects.requireNonNull(value, "recordRowPath is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JSONMappingParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public JSONMappingParametersProperty build() {
                return new JSONMappingParametersProperty() {
                    private java.lang.String $recordRowPath = java.util.Objects.requireNonNull(_recordRowPath, "recordRowPath is required");

                    @Override
                    public java.lang.String getRecordRowPath() {
                        return this.$recordRowPath;
                    }

                    @Override
                    public void setRecordRowPath(final java.lang.String value) {
                        this.$recordRowPath = java.util.Objects.requireNonNull(value, "recordRowPath is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplication.JSONMappingParametersProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnApplication.JSONMappingParametersProperty.RecordRowPath``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-jsonmappingparameters.html#cfn-kinesisanalytics-application-jsonmappingparameters-recordrowpath
             */
            @Override
            public java.lang.String getRecordRowPath() {
                return this.jsiiGet("recordRowPath", java.lang.String.class);
            }

            /**
             * ``CfnApplication.JSONMappingParametersProperty.RecordRowPath``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-jsonmappingparameters.html#cfn-kinesisanalytics-application-jsonmappingparameters-recordrowpath
             */
            @Override
            public void setRecordRowPath(final java.lang.String value) {
                this.jsiiSet("recordRowPath", java.util.Objects.requireNonNull(value, "recordRowPath is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisfirehoseinput.html
     */
    public static interface KinesisFirehoseInputProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnApplication.KinesisFirehoseInputProperty.ResourceARN``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisfirehoseinput.html#cfn-kinesisanalytics-application-kinesisfirehoseinput-resourcearn
         */
        java.lang.String getResourceArn();
        /**
         * ``CfnApplication.KinesisFirehoseInputProperty.ResourceARN``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisfirehoseinput.html#cfn-kinesisanalytics-application-kinesisfirehoseinput-resourcearn
         */
        void setResourceArn(final java.lang.String value);
        /**
         * ``CfnApplication.KinesisFirehoseInputProperty.RoleARN``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisfirehoseinput.html#cfn-kinesisanalytics-application-kinesisfirehoseinput-rolearn
         */
        java.lang.String getRoleArn();
        /**
         * ``CfnApplication.KinesisFirehoseInputProperty.RoleARN``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisfirehoseinput.html#cfn-kinesisanalytics-application-kinesisfirehoseinput-rolearn
         */
        void setRoleArn(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link KinesisFirehoseInputProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link KinesisFirehoseInputProperty}
         */
        final class Builder {
            private java.lang.String _resourceArn;
            private java.lang.String _roleArn;

            /**
             * Sets the value of ResourceArn
             * @param value ``CfnApplication.KinesisFirehoseInputProperty.ResourceARN``
             * @return {@code this}
             */
            public Builder withResourceArn(final java.lang.String value) {
                this._resourceArn = java.util.Objects.requireNonNull(value, "resourceArn is required");
                return this;
            }
            /**
             * Sets the value of RoleArn
             * @param value ``CfnApplication.KinesisFirehoseInputProperty.RoleARN``
             * @return {@code this}
             */
            public Builder withRoleArn(final java.lang.String value) {
                this._roleArn = java.util.Objects.requireNonNull(value, "roleArn is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisFirehoseInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public KinesisFirehoseInputProperty build() {
                return new KinesisFirehoseInputProperty() {
                    private java.lang.String $resourceArn = java.util.Objects.requireNonNull(_resourceArn, "resourceArn is required");
                    private java.lang.String $roleArn = java.util.Objects.requireNonNull(_roleArn, "roleArn is required");

                    @Override
                    public java.lang.String getResourceArn() {
                        return this.$resourceArn;
                    }

                    @Override
                    public void setResourceArn(final java.lang.String value) {
                        this.$resourceArn = java.util.Objects.requireNonNull(value, "resourceArn is required");
                    }

                    @Override
                    public java.lang.String getRoleArn() {
                        return this.$roleArn;
                    }

                    @Override
                    public void setRoleArn(final java.lang.String value) {
                        this.$roleArn = java.util.Objects.requireNonNull(value, "roleArn is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplication.KinesisFirehoseInputProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnApplication.KinesisFirehoseInputProperty.ResourceARN``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisfirehoseinput.html#cfn-kinesisanalytics-application-kinesisfirehoseinput-resourcearn
             */
            @Override
            public java.lang.String getResourceArn() {
                return this.jsiiGet("resourceArn", java.lang.String.class);
            }

            /**
             * ``CfnApplication.KinesisFirehoseInputProperty.ResourceARN``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisfirehoseinput.html#cfn-kinesisanalytics-application-kinesisfirehoseinput-resourcearn
             */
            @Override
            public void setResourceArn(final java.lang.String value) {
                this.jsiiSet("resourceArn", java.util.Objects.requireNonNull(value, "resourceArn is required"));
            }

            /**
             * ``CfnApplication.KinesisFirehoseInputProperty.RoleARN``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisfirehoseinput.html#cfn-kinesisanalytics-application-kinesisfirehoseinput-rolearn
             */
            @Override
            public java.lang.String getRoleArn() {
                return this.jsiiGet("roleArn", java.lang.String.class);
            }

            /**
             * ``CfnApplication.KinesisFirehoseInputProperty.RoleARN``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisfirehoseinput.html#cfn-kinesisanalytics-application-kinesisfirehoseinput-rolearn
             */
            @Override
            public void setRoleArn(final java.lang.String value) {
                this.jsiiSet("roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisstreamsinput.html
     */
    public static interface KinesisStreamsInputProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnApplication.KinesisStreamsInputProperty.ResourceARN``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisstreamsinput.html#cfn-kinesisanalytics-application-kinesisstreamsinput-resourcearn
         */
        java.lang.String getResourceArn();
        /**
         * ``CfnApplication.KinesisStreamsInputProperty.ResourceARN``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisstreamsinput.html#cfn-kinesisanalytics-application-kinesisstreamsinput-resourcearn
         */
        void setResourceArn(final java.lang.String value);
        /**
         * ``CfnApplication.KinesisStreamsInputProperty.RoleARN``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisstreamsinput.html#cfn-kinesisanalytics-application-kinesisstreamsinput-rolearn
         */
        java.lang.String getRoleArn();
        /**
         * ``CfnApplication.KinesisStreamsInputProperty.RoleARN``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisstreamsinput.html#cfn-kinesisanalytics-application-kinesisstreamsinput-rolearn
         */
        void setRoleArn(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link KinesisStreamsInputProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link KinesisStreamsInputProperty}
         */
        final class Builder {
            private java.lang.String _resourceArn;
            private java.lang.String _roleArn;

            /**
             * Sets the value of ResourceArn
             * @param value ``CfnApplication.KinesisStreamsInputProperty.ResourceARN``
             * @return {@code this}
             */
            public Builder withResourceArn(final java.lang.String value) {
                this._resourceArn = java.util.Objects.requireNonNull(value, "resourceArn is required");
                return this;
            }
            /**
             * Sets the value of RoleArn
             * @param value ``CfnApplication.KinesisStreamsInputProperty.RoleARN``
             * @return {@code this}
             */
            public Builder withRoleArn(final java.lang.String value) {
                this._roleArn = java.util.Objects.requireNonNull(value, "roleArn is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisStreamsInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public KinesisStreamsInputProperty build() {
                return new KinesisStreamsInputProperty() {
                    private java.lang.String $resourceArn = java.util.Objects.requireNonNull(_resourceArn, "resourceArn is required");
                    private java.lang.String $roleArn = java.util.Objects.requireNonNull(_roleArn, "roleArn is required");

                    @Override
                    public java.lang.String getResourceArn() {
                        return this.$resourceArn;
                    }

                    @Override
                    public void setResourceArn(final java.lang.String value) {
                        this.$resourceArn = java.util.Objects.requireNonNull(value, "resourceArn is required");
                    }

                    @Override
                    public java.lang.String getRoleArn() {
                        return this.$roleArn;
                    }

                    @Override
                    public void setRoleArn(final java.lang.String value) {
                        this.$roleArn = java.util.Objects.requireNonNull(value, "roleArn is required");
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplication.KinesisStreamsInputProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnApplication.KinesisStreamsInputProperty.ResourceARN``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisstreamsinput.html#cfn-kinesisanalytics-application-kinesisstreamsinput-resourcearn
             */
            @Override
            public java.lang.String getResourceArn() {
                return this.jsiiGet("resourceArn", java.lang.String.class);
            }

            /**
             * ``CfnApplication.KinesisStreamsInputProperty.ResourceARN``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisstreamsinput.html#cfn-kinesisanalytics-application-kinesisstreamsinput-resourcearn
             */
            @Override
            public void setResourceArn(final java.lang.String value) {
                this.jsiiSet("resourceArn", java.util.Objects.requireNonNull(value, "resourceArn is required"));
            }

            /**
             * ``CfnApplication.KinesisStreamsInputProperty.RoleARN``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisstreamsinput.html#cfn-kinesisanalytics-application-kinesisstreamsinput-rolearn
             */
            @Override
            public java.lang.String getRoleArn() {
                return this.jsiiGet("roleArn", java.lang.String.class);
            }

            /**
             * ``CfnApplication.KinesisStreamsInputProperty.RoleARN``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisstreamsinput.html#cfn-kinesisanalytics-application-kinesisstreamsinput-rolearn
             */
            @Override
            public void setRoleArn(final java.lang.String value) {
                this.jsiiSet("roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html
     */
    public static interface MappingParametersProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnApplication.MappingParametersProperty.CSVMappingParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html#cfn-kinesisanalytics-application-mappingparameters-csvmappingparameters
         */
        java.lang.Object getCsvMappingParameters();
        /**
         * ``CfnApplication.MappingParametersProperty.CSVMappingParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html#cfn-kinesisanalytics-application-mappingparameters-csvmappingparameters
         */
        void setCsvMappingParameters(final software.amazon.awscdk.Token value);
        /**
         * ``CfnApplication.MappingParametersProperty.CSVMappingParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html#cfn-kinesisanalytics-application-mappingparameters-csvmappingparameters
         */
        void setCsvMappingParameters(final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.CSVMappingParametersProperty value);
        /**
         * ``CfnApplication.MappingParametersProperty.JSONMappingParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html#cfn-kinesisanalytics-application-mappingparameters-jsonmappingparameters
         */
        java.lang.Object getJsonMappingParameters();
        /**
         * ``CfnApplication.MappingParametersProperty.JSONMappingParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html#cfn-kinesisanalytics-application-mappingparameters-jsonmappingparameters
         */
        void setJsonMappingParameters(final software.amazon.awscdk.Token value);
        /**
         * ``CfnApplication.MappingParametersProperty.JSONMappingParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html#cfn-kinesisanalytics-application-mappingparameters-jsonmappingparameters
         */
        void setJsonMappingParameters(final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.JSONMappingParametersProperty value);

        /**
         * @return a {@link Builder} of {@link MappingParametersProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link MappingParametersProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _csvMappingParameters;
            @javax.annotation.Nullable
            private java.lang.Object _jsonMappingParameters;

            /**
             * Sets the value of CsvMappingParameters
             * @param value ``CfnApplication.MappingParametersProperty.CSVMappingParameters``
             * @return {@code this}
             */
            public Builder withCsvMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._csvMappingParameters = value;
                return this;
            }
            /**
             * Sets the value of CsvMappingParameters
             * @param value ``CfnApplication.MappingParametersProperty.CSVMappingParameters``
             * @return {@code this}
             */
            public Builder withCsvMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.CSVMappingParametersProperty value) {
                this._csvMappingParameters = value;
                return this;
            }
            /**
             * Sets the value of JsonMappingParameters
             * @param value ``CfnApplication.MappingParametersProperty.JSONMappingParameters``
             * @return {@code this}
             */
            public Builder withJsonMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._jsonMappingParameters = value;
                return this;
            }
            /**
             * Sets the value of JsonMappingParameters
             * @param value ``CfnApplication.MappingParametersProperty.JSONMappingParameters``
             * @return {@code this}
             */
            public Builder withJsonMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.JSONMappingParametersProperty value) {
                this._jsonMappingParameters = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MappingParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public MappingParametersProperty build() {
                return new MappingParametersProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $csvMappingParameters = _csvMappingParameters;
                    @javax.annotation.Nullable
                    private java.lang.Object $jsonMappingParameters = _jsonMappingParameters;

                    @Override
                    public java.lang.Object getCsvMappingParameters() {
                        return this.$csvMappingParameters;
                    }

                    @Override
                    public void setCsvMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$csvMappingParameters = value;
                    }

                    @Override
                    public void setCsvMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.CSVMappingParametersProperty value) {
                        this.$csvMappingParameters = value;
                    }

                    @Override
                    public java.lang.Object getJsonMappingParameters() {
                        return this.$jsonMappingParameters;
                    }

                    @Override
                    public void setJsonMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$jsonMappingParameters = value;
                    }

                    @Override
                    public void setJsonMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.JSONMappingParametersProperty value) {
                        this.$jsonMappingParameters = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplication.MappingParametersProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnApplication.MappingParametersProperty.CSVMappingParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html#cfn-kinesisanalytics-application-mappingparameters-csvmappingparameters
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCsvMappingParameters() {
                return this.jsiiGet("csvMappingParameters", java.lang.Object.class);
            }

            /**
             * ``CfnApplication.MappingParametersProperty.CSVMappingParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html#cfn-kinesisanalytics-application-mappingparameters-csvmappingparameters
             */
            @Override
            public void setCsvMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("csvMappingParameters", value);
            }

            /**
             * ``CfnApplication.MappingParametersProperty.CSVMappingParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html#cfn-kinesisanalytics-application-mappingparameters-csvmappingparameters
             */
            @Override
            public void setCsvMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.CSVMappingParametersProperty value) {
                this.jsiiSet("csvMappingParameters", value);
            }

            /**
             * ``CfnApplication.MappingParametersProperty.JSONMappingParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html#cfn-kinesisanalytics-application-mappingparameters-jsonmappingparameters
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getJsonMappingParameters() {
                return this.jsiiGet("jsonMappingParameters", java.lang.Object.class);
            }

            /**
             * ``CfnApplication.MappingParametersProperty.JSONMappingParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html#cfn-kinesisanalytics-application-mappingparameters-jsonmappingparameters
             */
            @Override
            public void setJsonMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("jsonMappingParameters", value);
            }

            /**
             * ``CfnApplication.MappingParametersProperty.JSONMappingParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html#cfn-kinesisanalytics-application-mappingparameters-jsonmappingparameters
             */
            @Override
            public void setJsonMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.JSONMappingParametersProperty value) {
                this.jsiiSet("jsonMappingParameters", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html
     */
    public static interface RecordColumnProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnApplication.RecordColumnProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-name
         */
        java.lang.String getName();
        /**
         * ``CfnApplication.RecordColumnProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-name
         */
        void setName(final java.lang.String value);
        /**
         * ``CfnApplication.RecordColumnProperty.SqlType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-sqltype
         */
        java.lang.String getSqlType();
        /**
         * ``CfnApplication.RecordColumnProperty.SqlType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-sqltype
         */
        void setSqlType(final java.lang.String value);
        /**
         * ``CfnApplication.RecordColumnProperty.Mapping``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-mapping
         */
        java.lang.String getMapping();
        /**
         * ``CfnApplication.RecordColumnProperty.Mapping``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-mapping
         */
        void setMapping(final java.lang.String value);

        /**
         * @return a {@link Builder} of {@link RecordColumnProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RecordColumnProperty}
         */
        final class Builder {
            private java.lang.String _name;
            private java.lang.String _sqlType;
            @javax.annotation.Nullable
            private java.lang.String _mapping;

            /**
             * Sets the value of Name
             * @param value ``CfnApplication.RecordColumnProperty.Name``
             * @return {@code this}
             */
            public Builder withName(final java.lang.String value) {
                this._name = java.util.Objects.requireNonNull(value, "name is required");
                return this;
            }
            /**
             * Sets the value of SqlType
             * @param value ``CfnApplication.RecordColumnProperty.SqlType``
             * @return {@code this}
             */
            public Builder withSqlType(final java.lang.String value) {
                this._sqlType = java.util.Objects.requireNonNull(value, "sqlType is required");
                return this;
            }
            /**
             * Sets the value of Mapping
             * @param value ``CfnApplication.RecordColumnProperty.Mapping``
             * @return {@code this}
             */
            public Builder withMapping(@javax.annotation.Nullable final java.lang.String value) {
                this._mapping = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecordColumnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public RecordColumnProperty build() {
                return new RecordColumnProperty() {
                    private java.lang.String $name = java.util.Objects.requireNonNull(_name, "name is required");
                    private java.lang.String $sqlType = java.util.Objects.requireNonNull(_sqlType, "sqlType is required");
                    @javax.annotation.Nullable
                    private java.lang.String $mapping = _mapping;

                    @Override
                    public java.lang.String getName() {
                        return this.$name;
                    }

                    @Override
                    public void setName(final java.lang.String value) {
                        this.$name = java.util.Objects.requireNonNull(value, "name is required");
                    }

                    @Override
                    public java.lang.String getSqlType() {
                        return this.$sqlType;
                    }

                    @Override
                    public void setSqlType(final java.lang.String value) {
                        this.$sqlType = java.util.Objects.requireNonNull(value, "sqlType is required");
                    }

                    @Override
                    public java.lang.String getMapping() {
                        return this.$mapping;
                    }

                    @Override
                    public void setMapping(@javax.annotation.Nullable final java.lang.String value) {
                        this.$mapping = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplication.RecordColumnProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnApplication.RecordColumnProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-name
             */
            @Override
            public java.lang.String getName() {
                return this.jsiiGet("name", java.lang.String.class);
            }

            /**
             * ``CfnApplication.RecordColumnProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-name
             */
            @Override
            public void setName(final java.lang.String value) {
                this.jsiiSet("name", java.util.Objects.requireNonNull(value, "name is required"));
            }

            /**
             * ``CfnApplication.RecordColumnProperty.SqlType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-sqltype
             */
            @Override
            public java.lang.String getSqlType() {
                return this.jsiiGet("sqlType", java.lang.String.class);
            }

            /**
             * ``CfnApplication.RecordColumnProperty.SqlType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-sqltype
             */
            @Override
            public void setSqlType(final java.lang.String value) {
                this.jsiiSet("sqlType", java.util.Objects.requireNonNull(value, "sqlType is required"));
            }

            /**
             * ``CfnApplication.RecordColumnProperty.Mapping``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-mapping
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getMapping() {
                return this.jsiiGet("mapping", java.lang.String.class);
            }

            /**
             * ``CfnApplication.RecordColumnProperty.Mapping``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-mapping
             */
            @Override
            public void setMapping(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("mapping", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordformat.html
     */
    public static interface RecordFormatProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``CfnApplication.RecordFormatProperty.RecordFormatType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordformat.html#cfn-kinesisanalytics-application-recordformat-recordformattype
         */
        java.lang.String getRecordFormatType();
        /**
         * ``CfnApplication.RecordFormatProperty.RecordFormatType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordformat.html#cfn-kinesisanalytics-application-recordformat-recordformattype
         */
        void setRecordFormatType(final java.lang.String value);
        /**
         * ``CfnApplication.RecordFormatProperty.MappingParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordformat.html#cfn-kinesisanalytics-application-recordformat-mappingparameters
         */
        java.lang.Object getMappingParameters();
        /**
         * ``CfnApplication.RecordFormatProperty.MappingParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordformat.html#cfn-kinesisanalytics-application-recordformat-mappingparameters
         */
        void setMappingParameters(final software.amazon.awscdk.Token value);
        /**
         * ``CfnApplication.RecordFormatProperty.MappingParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordformat.html#cfn-kinesisanalytics-application-recordformat-mappingparameters
         */
        void setMappingParameters(final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.MappingParametersProperty value);

        /**
         * @return a {@link Builder} of {@link RecordFormatProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RecordFormatProperty}
         */
        final class Builder {
            private java.lang.String _recordFormatType;
            @javax.annotation.Nullable
            private java.lang.Object _mappingParameters;

            /**
             * Sets the value of RecordFormatType
             * @param value ``CfnApplication.RecordFormatProperty.RecordFormatType``
             * @return {@code this}
             */
            public Builder withRecordFormatType(final java.lang.String value) {
                this._recordFormatType = java.util.Objects.requireNonNull(value, "recordFormatType is required");
                return this;
            }
            /**
             * Sets the value of MappingParameters
             * @param value ``CfnApplication.RecordFormatProperty.MappingParameters``
             * @return {@code this}
             */
            public Builder withMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._mappingParameters = value;
                return this;
            }
            /**
             * Sets the value of MappingParameters
             * @param value ``CfnApplication.RecordFormatProperty.MappingParameters``
             * @return {@code this}
             */
            public Builder withMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.MappingParametersProperty value) {
                this._mappingParameters = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecordFormatProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public RecordFormatProperty build() {
                return new RecordFormatProperty() {
                    private java.lang.String $recordFormatType = java.util.Objects.requireNonNull(_recordFormatType, "recordFormatType is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $mappingParameters = _mappingParameters;

                    @Override
                    public java.lang.String getRecordFormatType() {
                        return this.$recordFormatType;
                    }

                    @Override
                    public void setRecordFormatType(final java.lang.String value) {
                        this.$recordFormatType = java.util.Objects.requireNonNull(value, "recordFormatType is required");
                    }

                    @Override
                    public java.lang.Object getMappingParameters() {
                        return this.$mappingParameters;
                    }

                    @Override
                    public void setMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$mappingParameters = value;
                    }

                    @Override
                    public void setMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.MappingParametersProperty value) {
                        this.$mappingParameters = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplication.RecordFormatProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``CfnApplication.RecordFormatProperty.RecordFormatType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordformat.html#cfn-kinesisanalytics-application-recordformat-recordformattype
             */
            @Override
            public java.lang.String getRecordFormatType() {
                return this.jsiiGet("recordFormatType", java.lang.String.class);
            }

            /**
             * ``CfnApplication.RecordFormatProperty.RecordFormatType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordformat.html#cfn-kinesisanalytics-application-recordformat-recordformattype
             */
            @Override
            public void setRecordFormatType(final java.lang.String value) {
                this.jsiiSet("recordFormatType", java.util.Objects.requireNonNull(value, "recordFormatType is required"));
            }

            /**
             * ``CfnApplication.RecordFormatProperty.MappingParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordformat.html#cfn-kinesisanalytics-application-recordformat-mappingparameters
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getMappingParameters() {
                return this.jsiiGet("mappingParameters", java.lang.Object.class);
            }

            /**
             * ``CfnApplication.RecordFormatProperty.MappingParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordformat.html#cfn-kinesisanalytics-application-recordformat-mappingparameters
             */
            @Override
            public void setMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("mappingParameters", value);
            }

            /**
             * ``CfnApplication.RecordFormatProperty.MappingParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordformat.html#cfn-kinesisanalytics-application-recordformat-mappingparameters
             */
            @Override
            public void setMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.MappingParametersProperty value) {
                this.jsiiSet("mappingParameters", value);
            }
        }
    }
}
