/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.kinesisanalytics;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.kinesisanalytics.;
import software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSourceV2;
import software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSourceV2Props;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationReferenceDataSourceV2")
public class CfnApplicationReferenceDataSourceV2
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnApplicationReferenceDataSourceV2.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnApplicationReferenceDataSourceV2(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApplicationReferenceDataSourceV2(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnApplicationReferenceDataSourceV2(@NotNull Construct scope, @NotNull String id, @NotNull CfnApplicationReferenceDataSourceV2Props props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getApplicationName() {
        return (String)Kernel.get((Object)((Object)this), (String)"applicationName", (NativeType)NativeType.forClass(String.class));
    }

    public void setApplicationName(@NotNull String value) {
        Kernel.set((Object)((Object)this), (String)"applicationName", (Object)Objects.requireNonNull(value, "applicationName is required"));
    }

    @NotNull
    public Object getReferenceDataSource() {
        return Kernel.get((Object)((Object)this), (String)"referenceDataSource", (NativeType)NativeType.forClass(Object.class));
    }

    public void setReferenceDataSource(@NotNull IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"referenceDataSource", (Object)Objects.requireNonNull(value, "referenceDataSource is required"));
    }

    public void setReferenceDataSource(@NotNull ReferenceDataSourceProperty value) {
        Kernel.set((Object)((Object)this), (String)"referenceDataSource", (Object)Objects.requireNonNull(value, "referenceDataSource is required"));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnApplicationReferenceDataSourceV2> {
        private final Construct scope;
        private final String id;
        private final CfnApplicationReferenceDataSourceV2Props.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnApplicationReferenceDataSourceV2Props.Builder();
        }

        public Builder applicationName(String applicationName) {
            this.props.applicationName(applicationName);
            return this;
        }

        public Builder referenceDataSource(IResolvable referenceDataSource) {
            this.props.referenceDataSource(referenceDataSource);
            return this;
        }

        public Builder referenceDataSource(ReferenceDataSourceProperty referenceDataSource) {
            this.props.referenceDataSource(referenceDataSource);
            return this;
        }

        public CfnApplicationReferenceDataSourceV2 build() {
            return new CfnApplicationReferenceDataSourceV2(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationReferenceDataSourceV2.S3ReferenceDataSourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3ReferenceDataSourceProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucketArn();

        @NotNull
        public String getFileKey();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3ReferenceDataSourceProperty> {
            String bucketArn;
            String fileKey;

            public Builder bucketArn(String bucketArn) {
                this.bucketArn = bucketArn;
                return this;
            }

            public Builder fileKey(String fileKey) {
                this.fileKey = fileKey;
                return this;
            }

            public S3ReferenceDataSourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationReferenceDataSourceV2.ReferenceSchemaProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ReferenceSchemaProperty
    extends JsiiSerializable {
        @NotNull
        public Object getRecordColumns();

        @NotNull
        public Object getRecordFormat();

        @Nullable
        default public String getRecordEncoding() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ReferenceSchemaProperty> {
            Object recordColumns;
            Object recordFormat;
            String recordEncoding;

            public Builder recordColumns(IResolvable recordColumns) {
                this.recordColumns = recordColumns;
                return this;
            }

            public Builder recordColumns(List<? extends Object> recordColumns) {
                this.recordColumns = recordColumns;
                return this;
            }

            public Builder recordFormat(IResolvable recordFormat) {
                this.recordFormat = recordFormat;
                return this;
            }

            public Builder recordFormat(RecordFormatProperty recordFormat) {
                this.recordFormat = recordFormat;
                return this;
            }

            public Builder recordEncoding(String recordEncoding) {
                this.recordEncoding = recordEncoding;
                return this;
            }

            public ReferenceSchemaProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationReferenceDataSourceV2.ReferenceDataSourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ReferenceDataSourceProperty
    extends JsiiSerializable {
        @NotNull
        public Object getReferenceSchema();

        @Nullable
        default public Object getS3ReferenceDataSource() {
            return null;
        }

        @Nullable
        default public String getTableName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ReferenceDataSourceProperty> {
            Object referenceSchema;
            Object s3ReferenceDataSource;
            String tableName;

            public Builder referenceSchema(IResolvable referenceSchema) {
                this.referenceSchema = referenceSchema;
                return this;
            }

            public Builder referenceSchema(ReferenceSchemaProperty referenceSchema) {
                this.referenceSchema = referenceSchema;
                return this;
            }

            public Builder s3ReferenceDataSource(IResolvable s3ReferenceDataSource) {
                this.s3ReferenceDataSource = s3ReferenceDataSource;
                return this;
            }

            public Builder s3ReferenceDataSource(S3ReferenceDataSourceProperty s3ReferenceDataSource) {
                this.s3ReferenceDataSource = s3ReferenceDataSource;
                return this;
            }

            public Builder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public ReferenceDataSourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationReferenceDataSourceV2.RecordFormatProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RecordFormatProperty
    extends JsiiSerializable {
        @NotNull
        public String getRecordFormatType();

        @Nullable
        default public Object getMappingParameters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RecordFormatProperty> {
            String recordFormatType;
            Object mappingParameters;

            public Builder recordFormatType(String recordFormatType) {
                this.recordFormatType = recordFormatType;
                return this;
            }

            public Builder mappingParameters(IResolvable mappingParameters) {
                this.mappingParameters = mappingParameters;
                return this;
            }

            public Builder mappingParameters(MappingParametersProperty mappingParameters) {
                this.mappingParameters = mappingParameters;
                return this;
            }

            public RecordFormatProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationReferenceDataSourceV2.RecordColumnProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RecordColumnProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getSqlType();

        @Nullable
        default public String getMapping() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RecordColumnProperty> {
            String name;
            String sqlType;
            String mapping;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder sqlType(String sqlType) {
                this.sqlType = sqlType;
                return this;
            }

            public Builder mapping(String mapping) {
                this.mapping = mapping;
                return this;
            }

            public RecordColumnProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationReferenceDataSourceV2.MappingParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MappingParametersProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCsvMappingParameters() {
            return null;
        }

        @Nullable
        default public Object getJsonMappingParameters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MappingParametersProperty> {
            Object csvMappingParameters;
            Object jsonMappingParameters;

            public Builder csvMappingParameters(IResolvable csvMappingParameters) {
                this.csvMappingParameters = csvMappingParameters;
                return this;
            }

            public Builder csvMappingParameters(CSVMappingParametersProperty csvMappingParameters) {
                this.csvMappingParameters = csvMappingParameters;
                return this;
            }

            public Builder jsonMappingParameters(IResolvable jsonMappingParameters) {
                this.jsonMappingParameters = jsonMappingParameters;
                return this;
            }

            public Builder jsonMappingParameters(JSONMappingParametersProperty jsonMappingParameters) {
                this.jsonMappingParameters = jsonMappingParameters;
                return this;
            }

            public MappingParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationReferenceDataSourceV2.JSONMappingParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface JSONMappingParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getRecordRowPath();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<JSONMappingParametersProperty> {
            String recordRowPath;

            public Builder recordRowPath(String recordRowPath) {
                this.recordRowPath = recordRowPath;
                return this;
            }

            public JSONMappingParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationReferenceDataSourceV2.CSVMappingParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CSVMappingParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getRecordColumnDelimiter();

        @NotNull
        public String getRecordRowDelimiter();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CSVMappingParametersProperty> {
            String recordColumnDelimiter;
            String recordRowDelimiter;

            public Builder recordColumnDelimiter(String recordColumnDelimiter) {
                this.recordColumnDelimiter = recordColumnDelimiter;
                return this;
            }

            public Builder recordRowDelimiter(String recordRowDelimiter) {
                this.recordRowDelimiter = recordRowDelimiter;
                return this;
            }

            public CSVMappingParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

