/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.kinesisanalytics;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.kinesisanalytics.$Module;
import software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2;
import software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2Props;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2")
public class CfnApplicationV2
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnApplicationV2.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnApplicationV2(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApplicationV2(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnApplicationV2(@NotNull Construct scope, @NotNull String id, @NotNull CfnApplicationV2Props props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)Kernel.get((Object)((Object)this), (String)"tags", (NativeType)NativeType.forClass(TagManager.class));
    }

    @NotNull
    public String getRuntimeEnvironment() {
        return (String)Kernel.get((Object)((Object)this), (String)"runtimeEnvironment", (NativeType)NativeType.forClass(String.class));
    }

    public void setRuntimeEnvironment(@NotNull String value) {
        Kernel.set((Object)((Object)this), (String)"runtimeEnvironment", (Object)Objects.requireNonNull(value, "runtimeEnvironment is required"));
    }

    @NotNull
    public String getServiceExecutionRole() {
        return (String)Kernel.get((Object)((Object)this), (String)"serviceExecutionRole", (NativeType)NativeType.forClass(String.class));
    }

    public void setServiceExecutionRole(@NotNull String value) {
        Kernel.set((Object)((Object)this), (String)"serviceExecutionRole", (Object)Objects.requireNonNull(value, "serviceExecutionRole is required"));
    }

    @Nullable
    public Object getApplicationConfiguration() {
        return Kernel.get((Object)((Object)this), (String)"applicationConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setApplicationConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"applicationConfiguration", (Object)value);
    }

    public void setApplicationConfiguration(@Nullable ApplicationConfigurationProperty value) {
        Kernel.set((Object)((Object)this), (String)"applicationConfiguration", (Object)value);
    }

    @Nullable
    public String getApplicationDescription() {
        return (String)Kernel.get((Object)((Object)this), (String)"applicationDescription", (NativeType)NativeType.forClass(String.class));
    }

    public void setApplicationDescription(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"applicationDescription", (Object)value);
    }

    @Nullable
    public Object getApplicationMaintenanceConfiguration() {
        return Kernel.get((Object)((Object)this), (String)"applicationMaintenanceConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setApplicationMaintenanceConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"applicationMaintenanceConfiguration", (Object)value);
    }

    public void setApplicationMaintenanceConfiguration(@Nullable ApplicationMaintenanceConfigurationProperty value) {
        Kernel.set((Object)((Object)this), (String)"applicationMaintenanceConfiguration", (Object)value);
    }

    @Nullable
    public String getApplicationMode() {
        return (String)Kernel.get((Object)((Object)this), (String)"applicationMode", (NativeType)NativeType.forClass(String.class));
    }

    public void setApplicationMode(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"applicationMode", (Object)value);
    }

    @Nullable
    public String getApplicationName() {
        return (String)Kernel.get((Object)((Object)this), (String)"applicationName", (NativeType)NativeType.forClass(String.class));
    }

    public void setApplicationName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"applicationName", (Object)value);
    }

    @Nullable
    public Object getRunConfiguration() {
        return Kernel.get((Object)((Object)this), (String)"runConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRunConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"runConfiguration", (Object)value);
    }

    public void setRunConfiguration(@Nullable RunConfigurationProperty value) {
        Kernel.set((Object)((Object)this), (String)"runConfiguration", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnApplicationV2> {
        private final Construct scope;
        private final String id;
        private final CfnApplicationV2Props.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnApplicationV2Props.Builder();
        }

        public Builder runtimeEnvironment(String runtimeEnvironment) {
            this.props.runtimeEnvironment(runtimeEnvironment);
            return this;
        }

        public Builder serviceExecutionRole(String serviceExecutionRole) {
            this.props.serviceExecutionRole(serviceExecutionRole);
            return this;
        }

        public Builder applicationConfiguration(IResolvable applicationConfiguration) {
            this.props.applicationConfiguration(applicationConfiguration);
            return this;
        }

        public Builder applicationConfiguration(ApplicationConfigurationProperty applicationConfiguration) {
            this.props.applicationConfiguration(applicationConfiguration);
            return this;
        }

        public Builder applicationDescription(String applicationDescription) {
            this.props.applicationDescription(applicationDescription);
            return this;
        }

        public Builder applicationMaintenanceConfiguration(IResolvable applicationMaintenanceConfiguration) {
            this.props.applicationMaintenanceConfiguration(applicationMaintenanceConfiguration);
            return this;
        }

        public Builder applicationMaintenanceConfiguration(ApplicationMaintenanceConfigurationProperty applicationMaintenanceConfiguration) {
            this.props.applicationMaintenanceConfiguration(applicationMaintenanceConfiguration);
            return this;
        }

        public Builder applicationMode(String applicationMode) {
            this.props.applicationMode(applicationMode);
            return this;
        }

        public Builder applicationName(String applicationName) {
            this.props.applicationName(applicationName);
            return this;
        }

        public Builder runConfiguration(IResolvable runConfiguration) {
            this.props.runConfiguration(runConfiguration);
            return this;
        }

        public Builder runConfiguration(RunConfigurationProperty runConfiguration) {
            this.props.runConfiguration(runConfiguration);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnApplicationV2 build() {
            return new CfnApplicationV2(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.ZeppelinMonitoringConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ZeppelinMonitoringConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getLogLevel() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ZeppelinMonitoringConfigurationProperty> {
            String logLevel;

            public Builder logLevel(String logLevel) {
                this.logLevel = logLevel;
                return this;
            }

            public ZeppelinMonitoringConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.ZeppelinApplicationConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ZeppelinApplicationConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCatalogConfiguration() {
            return null;
        }

        @Nullable
        default public Object getCustomArtifactsConfiguration() {
            return null;
        }

        @Nullable
        default public Object getDeployAsApplicationConfiguration() {
            return null;
        }

        @Nullable
        default public Object getMonitoringConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ZeppelinApplicationConfigurationProperty> {
            Object catalogConfiguration;
            Object customArtifactsConfiguration;
            Object deployAsApplicationConfiguration;
            Object monitoringConfiguration;

            public Builder catalogConfiguration(IResolvable catalogConfiguration) {
                this.catalogConfiguration = catalogConfiguration;
                return this;
            }

            public Builder catalogConfiguration(CatalogConfigurationProperty catalogConfiguration) {
                this.catalogConfiguration = catalogConfiguration;
                return this;
            }

            public Builder customArtifactsConfiguration(IResolvable customArtifactsConfiguration) {
                this.customArtifactsConfiguration = customArtifactsConfiguration;
                return this;
            }

            public Builder customArtifactsConfiguration(List<? extends Object> customArtifactsConfiguration) {
                this.customArtifactsConfiguration = customArtifactsConfiguration;
                return this;
            }

            public Builder deployAsApplicationConfiguration(IResolvable deployAsApplicationConfiguration) {
                this.deployAsApplicationConfiguration = deployAsApplicationConfiguration;
                return this;
            }

            public Builder deployAsApplicationConfiguration(DeployAsApplicationConfigurationProperty deployAsApplicationConfiguration) {
                this.deployAsApplicationConfiguration = deployAsApplicationConfiguration;
                return this;
            }

            public Builder monitoringConfiguration(IResolvable monitoringConfiguration) {
                this.monitoringConfiguration = monitoringConfiguration;
                return this;
            }

            public Builder monitoringConfiguration(ZeppelinMonitoringConfigurationProperty monitoringConfiguration) {
                this.monitoringConfiguration = monitoringConfiguration;
                return this;
            }

            public ZeppelinApplicationConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.VpcConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VpcConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getSecurityGroupIds();

        @NotNull
        public List<String> getSubnetIds();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VpcConfigurationProperty> {
            List<String> securityGroupIds;
            List<String> subnetIds;

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public Builder subnetIds(List<String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            public VpcConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.SqlApplicationConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SqlApplicationConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getInputs() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SqlApplicationConfigurationProperty> {
            Object inputs;

            public Builder inputs(IResolvable inputs) {
                this.inputs = inputs;
                return this;
            }

            public Builder inputs(List<? extends Object> inputs) {
                this.inputs = inputs;
                return this;
            }

            public SqlApplicationConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.S3ContentLocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3ContentLocationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucketArn();

        @NotNull
        public String getFileKey();

        @Nullable
        default public String getObjectVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3ContentLocationProperty> {
            String bucketArn;
            String fileKey;
            String objectVersion;

            public Builder bucketArn(String bucketArn) {
                this.bucketArn = bucketArn;
                return this;
            }

            public Builder fileKey(String fileKey) {
                this.fileKey = fileKey;
                return this;
            }

            public Builder objectVersion(String objectVersion) {
                this.objectVersion = objectVersion;
                return this;
            }

            public S3ContentLocationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.S3ContentBaseLocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3ContentBaseLocationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucketArn();

        @Nullable
        default public String getBasePath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3ContentBaseLocationProperty> {
            String bucketArn;
            String basePath;

            public Builder bucketArn(String bucketArn) {
                this.bucketArn = bucketArn;
                return this;
            }

            public Builder basePath(String basePath) {
                this.basePath = basePath;
                return this;
            }

            public S3ContentBaseLocationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.RunConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RunConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getApplicationRestoreConfiguration() {
            return null;
        }

        @Nullable
        default public Object getFlinkRunConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RunConfigurationProperty> {
            Object applicationRestoreConfiguration;
            Object flinkRunConfiguration;

            public Builder applicationRestoreConfiguration(IResolvable applicationRestoreConfiguration) {
                this.applicationRestoreConfiguration = applicationRestoreConfiguration;
                return this;
            }

            public Builder applicationRestoreConfiguration(ApplicationRestoreConfigurationProperty applicationRestoreConfiguration) {
                this.applicationRestoreConfiguration = applicationRestoreConfiguration;
                return this;
            }

            public Builder flinkRunConfiguration(IResolvable flinkRunConfiguration) {
                this.flinkRunConfiguration = flinkRunConfiguration;
                return this;
            }

            public Builder flinkRunConfiguration(FlinkRunConfigurationProperty flinkRunConfiguration) {
                this.flinkRunConfiguration = flinkRunConfiguration;
                return this;
            }

            public RunConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.RecordFormatProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RecordFormatProperty
    extends JsiiSerializable {
        @NotNull
        public String getRecordFormatType();

        @Nullable
        default public Object getMappingParameters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RecordFormatProperty> {
            String recordFormatType;
            Object mappingParameters;

            public Builder recordFormatType(String recordFormatType) {
                this.recordFormatType = recordFormatType;
                return this;
            }

            public Builder mappingParameters(IResolvable mappingParameters) {
                this.mappingParameters = mappingParameters;
                return this;
            }

            public Builder mappingParameters(MappingParametersProperty mappingParameters) {
                this.mappingParameters = mappingParameters;
                return this;
            }

            public RecordFormatProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.RecordColumnProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RecordColumnProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getSqlType();

        @Nullable
        default public String getMapping() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RecordColumnProperty> {
            String name;
            String sqlType;
            String mapping;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder sqlType(String sqlType) {
                this.sqlType = sqlType;
                return this;
            }

            public Builder mapping(String mapping) {
                this.mapping = mapping;
                return this;
            }

            public RecordColumnProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.PropertyGroupProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PropertyGroupProperty
    extends JsiiSerializable {
        @Nullable
        default public String getPropertyGroupId() {
            return null;
        }

        @Nullable
        default public Object getPropertyMap() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PropertyGroupProperty> {
            String propertyGroupId;
            Object propertyMap;

            public Builder propertyGroupId(String propertyGroupId) {
                this.propertyGroupId = propertyGroupId;
                return this;
            }

            public Builder propertyMap(IResolvable propertyMap) {
                this.propertyMap = propertyMap;
                return this;
            }

            public Builder propertyMap(Map<String, String> propertyMap) {
                this.propertyMap = propertyMap;
                return this;
            }

            public PropertyGroupProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.ParallelismConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ParallelismConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getConfigurationType();

        @Nullable
        default public Object getAutoScalingEnabled() {
            return null;
        }

        @Nullable
        default public Number getParallelism() {
            return null;
        }

        @Nullable
        default public Number getParallelismPerKpu() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ParallelismConfigurationProperty> {
            String configurationType;
            Object autoScalingEnabled;
            Number parallelism;
            Number parallelismPerKpu;

            public Builder configurationType(String configurationType) {
                this.configurationType = configurationType;
                return this;
            }

            public Builder autoScalingEnabled(Boolean autoScalingEnabled) {
                this.autoScalingEnabled = autoScalingEnabled;
                return this;
            }

            public Builder autoScalingEnabled(IResolvable autoScalingEnabled) {
                this.autoScalingEnabled = autoScalingEnabled;
                return this;
            }

            public Builder parallelism(Number parallelism) {
                this.parallelism = parallelism;
                return this;
            }

            public Builder parallelismPerKpu(Number parallelismPerKpu) {
                this.parallelismPerKpu = parallelismPerKpu;
                return this;
            }

            public ParallelismConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.MonitoringConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MonitoringConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getConfigurationType();

        @Nullable
        default public String getLogLevel() {
            return null;
        }

        @Nullable
        default public String getMetricsLevel() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MonitoringConfigurationProperty> {
            String configurationType;
            String logLevel;
            String metricsLevel;

            public Builder configurationType(String configurationType) {
                this.configurationType = configurationType;
                return this;
            }

            public Builder logLevel(String logLevel) {
                this.logLevel = logLevel;
                return this;
            }

            public Builder metricsLevel(String metricsLevel) {
                this.metricsLevel = metricsLevel;
                return this;
            }

            public MonitoringConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.MavenReferenceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MavenReferenceProperty
    extends JsiiSerializable {
        @NotNull
        public String getArtifactId();

        @NotNull
        public String getGroupId();

        @NotNull
        public String getVersion();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MavenReferenceProperty> {
            String artifactId;
            String groupId;
            String version;

            public Builder artifactId(String artifactId) {
                this.artifactId = artifactId;
                return this;
            }

            public Builder groupId(String groupId) {
                this.groupId = groupId;
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public MavenReferenceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.MappingParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MappingParametersProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCsvMappingParameters() {
            return null;
        }

        @Nullable
        default public Object getJsonMappingParameters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MappingParametersProperty> {
            Object csvMappingParameters;
            Object jsonMappingParameters;

            public Builder csvMappingParameters(IResolvable csvMappingParameters) {
                this.csvMappingParameters = csvMappingParameters;
                return this;
            }

            public Builder csvMappingParameters(CSVMappingParametersProperty csvMappingParameters) {
                this.csvMappingParameters = csvMappingParameters;
                return this;
            }

            public Builder jsonMappingParameters(IResolvable jsonMappingParameters) {
                this.jsonMappingParameters = jsonMappingParameters;
                return this;
            }

            public Builder jsonMappingParameters(JSONMappingParametersProperty jsonMappingParameters) {
                this.jsonMappingParameters = jsonMappingParameters;
                return this;
            }

            public MappingParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.KinesisStreamsInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KinesisStreamsInputProperty
    extends JsiiSerializable {
        @NotNull
        public String getResourceArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KinesisStreamsInputProperty> {
            String resourceArn;

            public Builder resourceArn(String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            public KinesisStreamsInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.KinesisFirehoseInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KinesisFirehoseInputProperty
    extends JsiiSerializable {
        @NotNull
        public String getResourceArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KinesisFirehoseInputProperty> {
            String resourceArn;

            public Builder resourceArn(String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            public KinesisFirehoseInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.JSONMappingParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface JSONMappingParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getRecordRowPath();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<JSONMappingParametersProperty> {
            String recordRowPath;

            public Builder recordRowPath(String recordRowPath) {
                this.recordRowPath = recordRowPath;
                return this;
            }

            public JSONMappingParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.InputSchemaProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InputSchemaProperty
    extends JsiiSerializable {
        @NotNull
        public Object getRecordColumns();

        @NotNull
        public Object getRecordFormat();

        @Nullable
        default public String getRecordEncoding() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InputSchemaProperty> {
            Object recordColumns;
            Object recordFormat;
            String recordEncoding;

            public Builder recordColumns(IResolvable recordColumns) {
                this.recordColumns = recordColumns;
                return this;
            }

            public Builder recordColumns(List<? extends Object> recordColumns) {
                this.recordColumns = recordColumns;
                return this;
            }

            public Builder recordFormat(IResolvable recordFormat) {
                this.recordFormat = recordFormat;
                return this;
            }

            public Builder recordFormat(RecordFormatProperty recordFormat) {
                this.recordFormat = recordFormat;
                return this;
            }

            public Builder recordEncoding(String recordEncoding) {
                this.recordEncoding = recordEncoding;
                return this;
            }

            public InputSchemaProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.InputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InputProperty
    extends JsiiSerializable {
        @NotNull
        public Object getInputSchema();

        @NotNull
        public String getNamePrefix();

        @Nullable
        default public Object getInputParallelism() {
            return null;
        }

        @Nullable
        default public Object getInputProcessingConfiguration() {
            return null;
        }

        @Nullable
        default public Object getKinesisFirehoseInput() {
            return null;
        }

        @Nullable
        default public Object getKinesisStreamsInput() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InputProperty> {
            Object inputSchema;
            String namePrefix;
            Object inputParallelism;
            Object inputProcessingConfiguration;
            Object kinesisFirehoseInput;
            Object kinesisStreamsInput;

            public Builder inputSchema(IResolvable inputSchema) {
                this.inputSchema = inputSchema;
                return this;
            }

            public Builder inputSchema(InputSchemaProperty inputSchema) {
                this.inputSchema = inputSchema;
                return this;
            }

            public Builder namePrefix(String namePrefix) {
                this.namePrefix = namePrefix;
                return this;
            }

            public Builder inputParallelism(IResolvable inputParallelism) {
                this.inputParallelism = inputParallelism;
                return this;
            }

            public Builder inputParallelism(InputParallelismProperty inputParallelism) {
                this.inputParallelism = inputParallelism;
                return this;
            }

            public Builder inputProcessingConfiguration(IResolvable inputProcessingConfiguration) {
                this.inputProcessingConfiguration = inputProcessingConfiguration;
                return this;
            }

            public Builder inputProcessingConfiguration(InputProcessingConfigurationProperty inputProcessingConfiguration) {
                this.inputProcessingConfiguration = inputProcessingConfiguration;
                return this;
            }

            public Builder kinesisFirehoseInput(IResolvable kinesisFirehoseInput) {
                this.kinesisFirehoseInput = kinesisFirehoseInput;
                return this;
            }

            public Builder kinesisFirehoseInput(KinesisFirehoseInputProperty kinesisFirehoseInput) {
                this.kinesisFirehoseInput = kinesisFirehoseInput;
                return this;
            }

            public Builder kinesisStreamsInput(IResolvable kinesisStreamsInput) {
                this.kinesisStreamsInput = kinesisStreamsInput;
                return this;
            }

            public Builder kinesisStreamsInput(KinesisStreamsInputProperty kinesisStreamsInput) {
                this.kinesisStreamsInput = kinesisStreamsInput;
                return this;
            }

            public InputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.InputProcessingConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InputProcessingConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getInputLambdaProcessor() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InputProcessingConfigurationProperty> {
            Object inputLambdaProcessor;

            public Builder inputLambdaProcessor(IResolvable inputLambdaProcessor) {
                this.inputLambdaProcessor = inputLambdaProcessor;
                return this;
            }

            public Builder inputLambdaProcessor(InputLambdaProcessorProperty inputLambdaProcessor) {
                this.inputLambdaProcessor = inputLambdaProcessor;
                return this;
            }

            public InputProcessingConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.InputParallelismProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InputParallelismProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getCount() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InputParallelismProperty> {
            Number count;

            public Builder count(Number count) {
                this.count = count;
                return this;
            }

            public InputParallelismProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.InputLambdaProcessorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InputLambdaProcessorProperty
    extends JsiiSerializable {
        @NotNull
        public String getResourceArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InputLambdaProcessorProperty> {
            String resourceArn;

            public Builder resourceArn(String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            public InputLambdaProcessorProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.GlueDataCatalogConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GlueDataCatalogConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDatabaseArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GlueDataCatalogConfigurationProperty> {
            String databaseArn;

            public Builder databaseArn(String databaseArn) {
                this.databaseArn = databaseArn;
                return this;
            }

            public GlueDataCatalogConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.FlinkRunConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FlinkRunConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAllowNonRestoredState() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FlinkRunConfigurationProperty> {
            Object allowNonRestoredState;

            public Builder allowNonRestoredState(Boolean allowNonRestoredState) {
                this.allowNonRestoredState = allowNonRestoredState;
                return this;
            }

            public Builder allowNonRestoredState(IResolvable allowNonRestoredState) {
                this.allowNonRestoredState = allowNonRestoredState;
                return this;
            }

            public FlinkRunConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.FlinkApplicationConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FlinkApplicationConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCheckpointConfiguration() {
            return null;
        }

        @Nullable
        default public Object getMonitoringConfiguration() {
            return null;
        }

        @Nullable
        default public Object getParallelismConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FlinkApplicationConfigurationProperty> {
            Object checkpointConfiguration;
            Object monitoringConfiguration;
            Object parallelismConfiguration;

            public Builder checkpointConfiguration(IResolvable checkpointConfiguration) {
                this.checkpointConfiguration = checkpointConfiguration;
                return this;
            }

            public Builder checkpointConfiguration(CheckpointConfigurationProperty checkpointConfiguration) {
                this.checkpointConfiguration = checkpointConfiguration;
                return this;
            }

            public Builder monitoringConfiguration(IResolvable monitoringConfiguration) {
                this.monitoringConfiguration = monitoringConfiguration;
                return this;
            }

            public Builder monitoringConfiguration(MonitoringConfigurationProperty monitoringConfiguration) {
                this.monitoringConfiguration = monitoringConfiguration;
                return this;
            }

            public Builder parallelismConfiguration(IResolvable parallelismConfiguration) {
                this.parallelismConfiguration = parallelismConfiguration;
                return this;
            }

            public Builder parallelismConfiguration(ParallelismConfigurationProperty parallelismConfiguration) {
                this.parallelismConfiguration = parallelismConfiguration;
                return this;
            }

            public FlinkApplicationConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.EnvironmentPropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EnvironmentPropertiesProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getPropertyGroups() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EnvironmentPropertiesProperty> {
            Object propertyGroups;

            public Builder propertyGroups(IResolvable propertyGroups) {
                this.propertyGroups = propertyGroups;
                return this;
            }

            public Builder propertyGroups(List<? extends Object> propertyGroups) {
                this.propertyGroups = propertyGroups;
                return this;
            }

            public EnvironmentPropertiesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.DeployAsApplicationConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeployAsApplicationConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getS3ContentLocation();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeployAsApplicationConfigurationProperty> {
            Object s3ContentLocation;

            public Builder s3ContentLocation(IResolvable s3ContentLocation) {
                this.s3ContentLocation = s3ContentLocation;
                return this;
            }

            public Builder s3ContentLocation(S3ContentBaseLocationProperty s3ContentLocation) {
                this.s3ContentLocation = s3ContentLocation;
                return this;
            }

            public DeployAsApplicationConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.CustomArtifactConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomArtifactConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getArtifactType();

        @Nullable
        default public Object getMavenReference() {
            return null;
        }

        @Nullable
        default public Object getS3ContentLocation() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomArtifactConfigurationProperty> {
            String artifactType;
            Object mavenReference;
            Object s3ContentLocation;

            public Builder artifactType(String artifactType) {
                this.artifactType = artifactType;
                return this;
            }

            public Builder mavenReference(IResolvable mavenReference) {
                this.mavenReference = mavenReference;
                return this;
            }

            public Builder mavenReference(MavenReferenceProperty mavenReference) {
                this.mavenReference = mavenReference;
                return this;
            }

            public Builder s3ContentLocation(IResolvable s3ContentLocation) {
                this.s3ContentLocation = s3ContentLocation;
                return this;
            }

            public Builder s3ContentLocation(S3ContentLocationProperty s3ContentLocation) {
                this.s3ContentLocation = s3ContentLocation;
                return this;
            }

            public CustomArtifactConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.CodeContentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CodeContentProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getS3ContentLocation() {
            return null;
        }

        @Nullable
        default public String getTextContent() {
            return null;
        }

        @Nullable
        default public String getZipFileContent() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CodeContentProperty> {
            Object s3ContentLocation;
            String textContent;
            String zipFileContent;

            public Builder s3ContentLocation(IResolvable s3ContentLocation) {
                this.s3ContentLocation = s3ContentLocation;
                return this;
            }

            public Builder s3ContentLocation(S3ContentLocationProperty s3ContentLocation) {
                this.s3ContentLocation = s3ContentLocation;
                return this;
            }

            public Builder textContent(String textContent) {
                this.textContent = textContent;
                return this;
            }

            public Builder zipFileContent(String zipFileContent) {
                this.zipFileContent = zipFileContent;
                return this;
            }

            public CodeContentProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.CheckpointConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CheckpointConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getConfigurationType();

        @Nullable
        default public Object getCheckpointingEnabled() {
            return null;
        }

        @Nullable
        default public Number getCheckpointInterval() {
            return null;
        }

        @Nullable
        default public Number getMinPauseBetweenCheckpoints() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CheckpointConfigurationProperty> {
            String configurationType;
            Object checkpointingEnabled;
            Number checkpointInterval;
            Number minPauseBetweenCheckpoints;

            public Builder configurationType(String configurationType) {
                this.configurationType = configurationType;
                return this;
            }

            public Builder checkpointingEnabled(Boolean checkpointingEnabled) {
                this.checkpointingEnabled = checkpointingEnabled;
                return this;
            }

            public Builder checkpointingEnabled(IResolvable checkpointingEnabled) {
                this.checkpointingEnabled = checkpointingEnabled;
                return this;
            }

            public Builder checkpointInterval(Number checkpointInterval) {
                this.checkpointInterval = checkpointInterval;
                return this;
            }

            public Builder minPauseBetweenCheckpoints(Number minPauseBetweenCheckpoints) {
                this.minPauseBetweenCheckpoints = minPauseBetweenCheckpoints;
                return this;
            }

            public CheckpointConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.CatalogConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CatalogConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getGlueDataCatalogConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CatalogConfigurationProperty> {
            Object glueDataCatalogConfiguration;

            public Builder glueDataCatalogConfiguration(IResolvable glueDataCatalogConfiguration) {
                this.glueDataCatalogConfiguration = glueDataCatalogConfiguration;
                return this;
            }

            public Builder glueDataCatalogConfiguration(GlueDataCatalogConfigurationProperty glueDataCatalogConfiguration) {
                this.glueDataCatalogConfiguration = glueDataCatalogConfiguration;
                return this;
            }

            public CatalogConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.CSVMappingParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CSVMappingParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getRecordColumnDelimiter();

        @NotNull
        public String getRecordRowDelimiter();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CSVMappingParametersProperty> {
            String recordColumnDelimiter;
            String recordRowDelimiter;

            public Builder recordColumnDelimiter(String recordColumnDelimiter) {
                this.recordColumnDelimiter = recordColumnDelimiter;
                return this;
            }

            public Builder recordRowDelimiter(String recordRowDelimiter) {
                this.recordRowDelimiter = recordRowDelimiter;
                return this;
            }

            public CSVMappingParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.ApplicationSnapshotConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ApplicationSnapshotConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getSnapshotsEnabled();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ApplicationSnapshotConfigurationProperty> {
            Object snapshotsEnabled;

            public Builder snapshotsEnabled(Boolean snapshotsEnabled) {
                this.snapshotsEnabled = snapshotsEnabled;
                return this;
            }

            public Builder snapshotsEnabled(IResolvable snapshotsEnabled) {
                this.snapshotsEnabled = snapshotsEnabled;
                return this;
            }

            public ApplicationSnapshotConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.ApplicationRestoreConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ApplicationRestoreConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getApplicationRestoreType();

        @Nullable
        default public String getSnapshotName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ApplicationRestoreConfigurationProperty> {
            String applicationRestoreType;
            String snapshotName;

            public Builder applicationRestoreType(String applicationRestoreType) {
                this.applicationRestoreType = applicationRestoreType;
                return this;
            }

            public Builder snapshotName(String snapshotName) {
                this.snapshotName = snapshotName;
                return this;
            }

            public ApplicationRestoreConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.ApplicationMaintenanceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ApplicationMaintenanceConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getApplicationMaintenanceWindowStartTime();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ApplicationMaintenanceConfigurationProperty> {
            String applicationMaintenanceWindowStartTime;

            public Builder applicationMaintenanceWindowStartTime(String applicationMaintenanceWindowStartTime) {
                this.applicationMaintenanceWindowStartTime = applicationMaintenanceWindowStartTime;
                return this;
            }

            public ApplicationMaintenanceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.ApplicationConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ApplicationConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getApplicationCodeConfiguration() {
            return null;
        }

        @Nullable
        default public Object getApplicationSnapshotConfiguration() {
            return null;
        }

        @Nullable
        default public Object getEnvironmentProperties() {
            return null;
        }

        @Nullable
        default public Object getFlinkApplicationConfiguration() {
            return null;
        }

        @Nullable
        default public Object getSqlApplicationConfiguration() {
            return null;
        }

        @Nullable
        default public Object getVpcConfigurations() {
            return null;
        }

        @Nullable
        default public Object getZeppelinApplicationConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ApplicationConfigurationProperty> {
            Object applicationCodeConfiguration;
            Object applicationSnapshotConfiguration;
            Object environmentProperties;
            Object flinkApplicationConfiguration;
            Object sqlApplicationConfiguration;
            Object vpcConfigurations;
            Object zeppelinApplicationConfiguration;

            public Builder applicationCodeConfiguration(IResolvable applicationCodeConfiguration) {
                this.applicationCodeConfiguration = applicationCodeConfiguration;
                return this;
            }

            public Builder applicationCodeConfiguration(ApplicationCodeConfigurationProperty applicationCodeConfiguration) {
                this.applicationCodeConfiguration = applicationCodeConfiguration;
                return this;
            }

            public Builder applicationSnapshotConfiguration(IResolvable applicationSnapshotConfiguration) {
                this.applicationSnapshotConfiguration = applicationSnapshotConfiguration;
                return this;
            }

            public Builder applicationSnapshotConfiguration(ApplicationSnapshotConfigurationProperty applicationSnapshotConfiguration) {
                this.applicationSnapshotConfiguration = applicationSnapshotConfiguration;
                return this;
            }

            public Builder environmentProperties(IResolvable environmentProperties) {
                this.environmentProperties = environmentProperties;
                return this;
            }

            public Builder environmentProperties(EnvironmentPropertiesProperty environmentProperties) {
                this.environmentProperties = environmentProperties;
                return this;
            }

            public Builder flinkApplicationConfiguration(IResolvable flinkApplicationConfiguration) {
                this.flinkApplicationConfiguration = flinkApplicationConfiguration;
                return this;
            }

            public Builder flinkApplicationConfiguration(FlinkApplicationConfigurationProperty flinkApplicationConfiguration) {
                this.flinkApplicationConfiguration = flinkApplicationConfiguration;
                return this;
            }

            public Builder sqlApplicationConfiguration(IResolvable sqlApplicationConfiguration) {
                this.sqlApplicationConfiguration = sqlApplicationConfiguration;
                return this;
            }

            public Builder sqlApplicationConfiguration(SqlApplicationConfigurationProperty sqlApplicationConfiguration) {
                this.sqlApplicationConfiguration = sqlApplicationConfiguration;
                return this;
            }

            public Builder vpcConfigurations(IResolvable vpcConfigurations) {
                this.vpcConfigurations = vpcConfigurations;
                return this;
            }

            public Builder vpcConfigurations(List<? extends Object> vpcConfigurations) {
                this.vpcConfigurations = vpcConfigurations;
                return this;
            }

            public Builder zeppelinApplicationConfiguration(IResolvable zeppelinApplicationConfiguration) {
                this.zeppelinApplicationConfiguration = zeppelinApplicationConfiguration;
                return this;
            }

            public Builder zeppelinApplicationConfiguration(ZeppelinApplicationConfigurationProperty zeppelinApplicationConfiguration) {
                this.zeppelinApplicationConfiguration = zeppelinApplicationConfiguration;
                return this;
            }

            public ApplicationConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplicationV2.ApplicationCodeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ApplicationCodeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getCodeContent();

        @NotNull
        public String getCodeContentType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ApplicationCodeConfigurationProperty> {
            Object codeContent;
            String codeContentType;

            public Builder codeContent(IResolvable codeContent) {
                this.codeContent = codeContent;
                return this;
            }

            public Builder codeContent(CodeContentProperty codeContent) {
                this.codeContent = codeContent;
                return this;
            }

            public Builder codeContentType(String codeContentType) {
                this.codeContentType = codeContentType;
                return this;
            }

            public ApplicationCodeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

