/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.kinesisanalytics;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.kinesisanalytics.;
import software.amazon.awscdk.services.kinesisanalytics.CfnApplication;
import software.amazon.awscdk.services.kinesisanalytics.CfnApplicationProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplication")
public class CfnApplication
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnApplication.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnApplication(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApplication(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnApplication(@NotNull Construct scope, @NotNull String id, @NotNull CfnApplicationProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getInputs() {
        return Kernel.get((Object)((Object)this), (String)"inputs", (NativeType)NativeType.forClass(Object.class));
    }

    public void setInputs(@NotNull IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"inputs", (Object)Objects.requireNonNull(value, "inputs is required"));
    }

    public void setInputs(@NotNull List<Object> value) {
        Kernel.set((Object)((Object)this), (String)"inputs", Objects.requireNonNull(value, "inputs is required"));
    }

    @Nullable
    public String getApplicationCode() {
        return (String)Kernel.get((Object)((Object)this), (String)"applicationCode", (NativeType)NativeType.forClass(String.class));
    }

    public void setApplicationCode(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"applicationCode", (Object)value);
    }

    @Nullable
    public String getApplicationDescription() {
        return (String)Kernel.get((Object)((Object)this), (String)"applicationDescription", (NativeType)NativeType.forClass(String.class));
    }

    public void setApplicationDescription(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"applicationDescription", (Object)value);
    }

    @Nullable
    public String getApplicationName() {
        return (String)Kernel.get((Object)((Object)this), (String)"applicationName", (NativeType)NativeType.forClass(String.class));
    }

    public void setApplicationName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"applicationName", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnApplication> {
        private final Construct scope;
        private final String id;
        private final CfnApplicationProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnApplicationProps.Builder();
        }

        public Builder inputs(IResolvable inputs) {
            this.props.inputs(inputs);
            return this;
        }

        public Builder inputs(List<? extends Object> inputs) {
            this.props.inputs(inputs);
            return this;
        }

        public Builder applicationCode(String applicationCode) {
            this.props.applicationCode(applicationCode);
            return this;
        }

        public Builder applicationDescription(String applicationDescription) {
            this.props.applicationDescription(applicationDescription);
            return this;
        }

        public Builder applicationName(String applicationName) {
            this.props.applicationName(applicationName);
            return this;
        }

        public CfnApplication build() {
            return new CfnApplication(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplication.RecordFormatProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RecordFormatProperty
    extends JsiiSerializable {
        @NotNull
        public String getRecordFormatType();

        @Nullable
        default public Object getMappingParameters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RecordFormatProperty> {
            private String recordFormatType;
            private Object mappingParameters;

            public Builder recordFormatType(String recordFormatType) {
                this.recordFormatType = recordFormatType;
                return this;
            }

            public Builder mappingParameters(IResolvable mappingParameters) {
                this.mappingParameters = mappingParameters;
                return this;
            }

            public Builder mappingParameters(MappingParametersProperty mappingParameters) {
                this.mappingParameters = mappingParameters;
                return this;
            }

            public RecordFormatProperty build() {
                return new Jsii.Proxy(this.recordFormatType, this.mappingParameters);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplication.RecordColumnProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RecordColumnProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getSqlType();

        @Nullable
        default public String getMapping() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RecordColumnProperty> {
            private String name;
            private String sqlType;
            private String mapping;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder sqlType(String sqlType) {
                this.sqlType = sqlType;
                return this;
            }

            public Builder mapping(String mapping) {
                this.mapping = mapping;
                return this;
            }

            public RecordColumnProperty build() {
                return new Jsii.Proxy(this.name, this.sqlType, this.mapping);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplication.MappingParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MappingParametersProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCsvMappingParameters() {
            return null;
        }

        @Nullable
        default public Object getJsonMappingParameters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MappingParametersProperty> {
            private Object csvMappingParameters;
            private Object jsonMappingParameters;

            public Builder csvMappingParameters(IResolvable csvMappingParameters) {
                this.csvMappingParameters = csvMappingParameters;
                return this;
            }

            public Builder csvMappingParameters(CSVMappingParametersProperty csvMappingParameters) {
                this.csvMappingParameters = csvMappingParameters;
                return this;
            }

            public Builder jsonMappingParameters(IResolvable jsonMappingParameters) {
                this.jsonMappingParameters = jsonMappingParameters;
                return this;
            }

            public Builder jsonMappingParameters(JSONMappingParametersProperty jsonMappingParameters) {
                this.jsonMappingParameters = jsonMappingParameters;
                return this;
            }

            public MappingParametersProperty build() {
                return new Jsii.Proxy(this.csvMappingParameters, this.jsonMappingParameters);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplication.KinesisStreamsInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KinesisStreamsInputProperty
    extends JsiiSerializable {
        @NotNull
        public String getResourceArn();

        @NotNull
        public String getRoleArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KinesisStreamsInputProperty> {
            private String resourceArn;
            private String roleArn;

            public Builder resourceArn(String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public KinesisStreamsInputProperty build() {
                return new Jsii.Proxy(this.resourceArn, this.roleArn);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplication.KinesisFirehoseInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KinesisFirehoseInputProperty
    extends JsiiSerializable {
        @NotNull
        public String getResourceArn();

        @NotNull
        public String getRoleArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KinesisFirehoseInputProperty> {
            private String resourceArn;
            private String roleArn;

            public Builder resourceArn(String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public KinesisFirehoseInputProperty build() {
                return new Jsii.Proxy(this.resourceArn, this.roleArn);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplication.JSONMappingParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface JSONMappingParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getRecordRowPath();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<JSONMappingParametersProperty> {
            private String recordRowPath;

            public Builder recordRowPath(String recordRowPath) {
                this.recordRowPath = recordRowPath;
                return this;
            }

            public JSONMappingParametersProperty build() {
                return new Jsii.Proxy(this.recordRowPath);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplication.InputSchemaProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InputSchemaProperty
    extends JsiiSerializable {
        @NotNull
        public Object getRecordColumns();

        @NotNull
        public Object getRecordFormat();

        @Nullable
        default public String getRecordEncoding() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InputSchemaProperty> {
            private Object recordColumns;
            private Object recordFormat;
            private String recordEncoding;

            public Builder recordColumns(IResolvable recordColumns) {
                this.recordColumns = recordColumns;
                return this;
            }

            public Builder recordColumns(List<? extends Object> recordColumns) {
                this.recordColumns = recordColumns;
                return this;
            }

            public Builder recordFormat(IResolvable recordFormat) {
                this.recordFormat = recordFormat;
                return this;
            }

            public Builder recordFormat(RecordFormatProperty recordFormat) {
                this.recordFormat = recordFormat;
                return this;
            }

            public Builder recordEncoding(String recordEncoding) {
                this.recordEncoding = recordEncoding;
                return this;
            }

            public InputSchemaProperty build() {
                return new Jsii.Proxy(this.recordColumns, this.recordFormat, this.recordEncoding);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplication.InputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InputProperty
    extends JsiiSerializable {
        @NotNull
        public Object getInputSchema();

        @NotNull
        public String getNamePrefix();

        @Nullable
        default public Object getInputParallelism() {
            return null;
        }

        @Nullable
        default public Object getInputProcessingConfiguration() {
            return null;
        }

        @Nullable
        default public Object getKinesisFirehoseInput() {
            return null;
        }

        @Nullable
        default public Object getKinesisStreamsInput() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InputProperty> {
            private Object inputSchema;
            private String namePrefix;
            private Object inputParallelism;
            private Object inputProcessingConfiguration;
            private Object kinesisFirehoseInput;
            private Object kinesisStreamsInput;

            public Builder inputSchema(IResolvable inputSchema) {
                this.inputSchema = inputSchema;
                return this;
            }

            public Builder inputSchema(InputSchemaProperty inputSchema) {
                this.inputSchema = inputSchema;
                return this;
            }

            public Builder namePrefix(String namePrefix) {
                this.namePrefix = namePrefix;
                return this;
            }

            public Builder inputParallelism(IResolvable inputParallelism) {
                this.inputParallelism = inputParallelism;
                return this;
            }

            public Builder inputParallelism(InputParallelismProperty inputParallelism) {
                this.inputParallelism = inputParallelism;
                return this;
            }

            public Builder inputProcessingConfiguration(IResolvable inputProcessingConfiguration) {
                this.inputProcessingConfiguration = inputProcessingConfiguration;
                return this;
            }

            public Builder inputProcessingConfiguration(InputProcessingConfigurationProperty inputProcessingConfiguration) {
                this.inputProcessingConfiguration = inputProcessingConfiguration;
                return this;
            }

            public Builder kinesisFirehoseInput(IResolvable kinesisFirehoseInput) {
                this.kinesisFirehoseInput = kinesisFirehoseInput;
                return this;
            }

            public Builder kinesisFirehoseInput(KinesisFirehoseInputProperty kinesisFirehoseInput) {
                this.kinesisFirehoseInput = kinesisFirehoseInput;
                return this;
            }

            public Builder kinesisStreamsInput(IResolvable kinesisStreamsInput) {
                this.kinesisStreamsInput = kinesisStreamsInput;
                return this;
            }

            public Builder kinesisStreamsInput(KinesisStreamsInputProperty kinesisStreamsInput) {
                this.kinesisStreamsInput = kinesisStreamsInput;
                return this;
            }

            public InputProperty build() {
                return new Jsii.Proxy(this.inputSchema, this.namePrefix, this.inputParallelism, this.inputProcessingConfiguration, this.kinesisFirehoseInput, this.kinesisStreamsInput);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplication.InputProcessingConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InputProcessingConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getInputLambdaProcessor() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InputProcessingConfigurationProperty> {
            private Object inputLambdaProcessor;

            public Builder inputLambdaProcessor(IResolvable inputLambdaProcessor) {
                this.inputLambdaProcessor = inputLambdaProcessor;
                return this;
            }

            public Builder inputLambdaProcessor(InputLambdaProcessorProperty inputLambdaProcessor) {
                this.inputLambdaProcessor = inputLambdaProcessor;
                return this;
            }

            public InputProcessingConfigurationProperty build() {
                return new Jsii.Proxy(this.inputLambdaProcessor);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplication.InputParallelismProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InputParallelismProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getCount() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InputParallelismProperty> {
            private Number count;

            public Builder count(Number count) {
                this.count = count;
                return this;
            }

            public InputParallelismProperty build() {
                return new Jsii.Proxy(this.count);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplication.InputLambdaProcessorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InputLambdaProcessorProperty
    extends JsiiSerializable {
        @NotNull
        public String getResourceArn();

        @NotNull
        public String getRoleArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InputLambdaProcessorProperty> {
            private String resourceArn;
            private String roleArn;

            public Builder resourceArn(String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public InputLambdaProcessorProperty build() {
                return new Jsii.Proxy(this.resourceArn, this.roleArn);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-kinesisanalytics.CfnApplication.CSVMappingParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CSVMappingParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getRecordColumnDelimiter();

        @NotNull
        public String getRecordRowDelimiter();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CSVMappingParametersProperty> {
            private String recordColumnDelimiter;
            private String recordRowDelimiter;

            public Builder recordColumnDelimiter(String recordColumnDelimiter) {
                this.recordColumnDelimiter = recordColumnDelimiter;
                return this;
            }

            public Builder recordRowDelimiter(String recordRowDelimiter) {
                this.recordRowDelimiter = recordRowDelimiter;
                return this;
            }

            public CSVMappingParametersProperty build() {
                return new Jsii.Proxy(this.recordColumnDelimiter, this.recordRowDelimiter);
            }
        }
    }
}

